/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.lib.internal.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolHandshake;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolMessage;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.engine.ProtocolEngine;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientModel {
    private static ClientModel instance;
    private Map<ProtocolHandle, ProtocolEngine> runningEngines = new HashMap<ProtocolHandle, ProtocolEngine>();

    private ClientModel() {
    }

    public static ClientModel getInstance() {
        if (instance == null) {
            instance = new ClientModel();
        }
        return instance;
    }

    public ProtocolHandle requestStartProtocol(Map<Long, ProtocolMsgDefinition> map, Collection<String> collection, Collection<String> collection2, IProtocolHandshake iProtocolHandshake, IProtocolExceptionHandler iProtocolExceptionHandler, Boolean bl, String string, int n, Map<String, Object> map2) {
        Integer n2 = (Integer)map2.get("connectionRetries");
        int n3 = n2 != null ? n2 : -1;
        ProtocolHandle protocolHandle = new ProtocolHandle();
        BasePlugin.logDebugMessage((String)"ClientModel", (String)("Creating a protocol engine to handle the protocol connection. Generated handle: " + protocolHandle + "."));
        ProtocolEngine protocolEngine = new ProtocolEngine(protocolHandle, iProtocolHandshake, map, collection, collection2, iProtocolExceptionHandler, bl, false, n3);
        protocolEngine.requestStart(string, n, map2);
        BasePlugin.logDebugMessage((String)"ClientModel", (String)"Registering the protocol engine at Client Model.");
        this.runningEngines.put(protocolHandle, protocolEngine);
        return protocolHandle;
    }

    public void requestStopProtocol(ProtocolHandle protocolHandle) {
        ProtocolEngine protocolEngine = this.runningEngines.get(protocolHandle);
        if (protocolEngine != null) {
            protocolEngine.requestStop();
            this.cleanStoppedProtocols();
            BasePlugin.logDebugMessage((String)"ClientModel", (String)"Unregistering the protocol engine from Client Model.");
            this.runningEngines.remove(protocolHandle);
        }
    }

    public void requestRestartProtocol(ProtocolHandle protocolHandle) {
        ProtocolEngine protocolEngine = this.runningEngines.get(protocolHandle);
        if (protocolEngine != null) {
            protocolEngine.requestRestart();
        }
    }

    public void sendMessage(ProtocolHandle protocolHandle, ProtocolMessage protocolMessage) {
        ProtocolEngine protocolEngine = this.runningEngines.get(protocolHandle);
        if (protocolEngine != null) {
            protocolEngine.requestSendMessage(protocolMessage);
        }
    }

    public void cleanStoppedProtocols() {
        BasePlugin.logDebugMessage((String)"ClientModel", (String)"Removing all stopped protocol engines from Client Model.");
        Set<ProtocolHandle> set = this.runningEngines.keySet();
        for (ProtocolHandle protocolHandle : set) {
            ProtocolEngine protocolEngine = this.runningEngines.get(protocolHandle);
            if (protocolEngine.isConnected()) continue;
            protocolEngine.dispose();
            set.remove(protocolHandle);
        }
    }

    public boolean isClientProtocolRunning(ProtocolHandle protocolHandle) {
        boolean bl = false;
        ProtocolEngine protocolEngine = this.runningEngines.get(protocolHandle);
        if (protocolEngine != null) {
            bl = protocolEngine.isRunning();
        }
        return bl;
    }
}

