/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.protocol.lib.internal.model;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolHandshake;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.ProtocolHandshakeException;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.engine.ProtocolEngine;
import org.eclipse.sequoyah.vnc.protocol.lib.internal.model.ServerProtocolEngineFactory;
import org.eclipse.sequoyah.vnc.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerModel {
    private static ServerModel instance;
    private Map<ProtocolHandle, ServerSocketChannel> openedSocketChannels = new HashMap<ProtocolHandle, ServerSocketChannel>();
    private Map<ProtocolHandle, ServerProtocolEngineFactory> engineFactories = new HashMap<ProtocolHandle, ServerProtocolEngineFactory>();
    private Map<ProtocolHandle, Collection<ProtocolEngine>> connectedClients = new HashMap<ProtocolHandle, Collection<ProtocolEngine>>();

    private ServerModel() {
    }

    public static ServerModel getInstance() {
        if (instance == null) {
            instance = new ServerModel();
        }
        return instance;
    }

    public ProtocolHandle startListeningToPort(int n, Map<Long, ProtocolMsgDefinition> map, Collection<String> collection, Collection<String> collection2, IProtocolHandshake iProtocolHandshake, IProtocolExceptionHandler iProtocolExceptionHandler, boolean bl) {
        ProtocolHandle protocolHandle;
        block4: {
            protocolHandle = new ProtocolHandle();
            if (n <= 0 || map == null || collection == null || collection2 == null) {
                BasePlugin.logError((String)"Invalid parameters provided to method.");
                if (iProtocolExceptionHandler != null) {
                    iProtocolExceptionHandler.handleProtocolHandshakeException(protocolHandle, new ProtocolHandshakeException("Invalid parameters provided to method"));
                }
            }
            BasePlugin.logDebugMessage((String)"ServerModel", (String)("Creating a server socket channel to listen to connections at port " + n + ". Generated handle: " + protocolHandle + "."));
            try {
                ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.socket().bind(new InetSocketAddress(n));
                BasePlugin.logDebugMessage((String)"ServerModel", (String)"Registering needed objects at Server Model.");
                ServerProtocolEngineFactory serverProtocolEngineFactory = new ServerProtocolEngineFactory(protocolHandle, iProtocolHandshake, map, collection, collection2, iProtocolExceptionHandler, bl);
                this.openedSocketChannels.put(protocolHandle, serverSocketChannel);
                this.engineFactories.put(protocolHandle, serverProtocolEngineFactory);
                ServerDeamon serverDeamon = new ServerDeamon(protocolHandle, serverSocketChannel, serverProtocolEngineFactory);
                Thread thread = new Thread(serverDeamon);
                thread.start();
            }
            catch (IOException iOException) {
                BasePlugin.logError((String)("Error opening server socket. Cause: " + iOException.getMessage()));
                if (iProtocolExceptionHandler == null) break block4;
                iProtocolExceptionHandler.handleIOException(protocolHandle, iOException);
            }
        }
        return protocolHandle;
    }

    public void stopListeningToPort(ProtocolHandle protocolHandle) {
        ServerSocketChannel serverSocketChannel = this.openedSocketChannels.get(protocolHandle);
        if (serverSocketChannel != null) {
            block4: {
                BasePlugin.logDebugMessage((String)"ServerModel", (String)"Closing server socket channel related to provided handle.");
                try {
                    serverSocketChannel.close();
                }
                catch (IOException iOException) {
                    Object object;
                    BasePlugin.logError((String)("Error closing server socket. Cause: " + iOException.getMessage()));
                    ServerProtocolEngineFactory object2 = this.engineFactories.get(protocolHandle);
                    if (object2 == null || (object = object2.getExceptionHandler()) == null) break block4;
                    object.handleIOException(protocolHandle, iOException);
                }
            }
            BasePlugin.logDebugMessage((String)"ServerModel", (String)"Unregistering all objects related to provided handle from Server Model.");
            Collection<ProtocolEngine> collection = this.connectedClients.get(protocolHandle);
            for (ProtocolEngine protocolEngine : collection) {
                protocolEngine.dispose();
                collection.remove(protocolEngine);
            }
            this.connectedClients.remove(protocolHandle);
            this.openedSocketChannels.remove(protocolHandle);
            this.engineFactories.remove(protocolHandle);
        }
    }

    public void requestRestartProtocol(ProtocolHandle protocolHandle) {
        ServerSocketChannel serverSocketChannel = this.openedSocketChannels.get(protocolHandle);
        if (serverSocketChannel != null) {
            int n = serverSocketChannel.socket().getLocalPort();
            ServerProtocolEngineFactory serverProtocolEngineFactory = this.engineFactories.get(protocolHandle);
            this.stopListeningToPort(protocolHandle);
            this.startListeningToPort(n, serverProtocolEngineFactory.getAllMessages(), serverProtocolEngineFactory.getIncomingMessages(), serverProtocolEngineFactory.getOutgoingMessages(), null, serverProtocolEngineFactory.getExceptionHandler(), serverProtocolEngineFactory.isBigEndianProtocol());
        }
    }

    public void cleanStoppedProtocols() {
        BasePlugin.logDebugMessage((String)"ServerModel", (String)"Removing all stopped protocol engines from Server Model.");
        Set<ProtocolHandle> set = this.connectedClients.keySet();
        for (ProtocolHandle protocolHandle : set) {
            Collection<ProtocolEngine> collection = this.connectedClients.get(protocolHandle);
            for (ProtocolEngine protocolEngine : collection) {
                if (protocolEngine.isConnected()) continue;
                protocolEngine.dispose();
                collection.remove(protocolEngine);
            }
        }
    }

    public boolean isListeningToPort(ProtocolHandle protocolHandle) {
        boolean bl = false;
        ServerSocketChannel serverSocketChannel = this.openedSocketChannels.get(protocolHandle);
        if (serverSocketChannel != null) {
            bl = serverSocketChannel.socket().isBound() && !serverSocketChannel.isOpen();
        }
        return bl;
    }

    private class ServerDeamon
    implements Runnable {
        private ProtocolHandle handle;
        private ServerSocketChannel channel;
        private ServerProtocolEngineFactory factory;

        public ServerDeamon(ProtocolHandle protocolHandle, ServerSocketChannel serverSocketChannel, ServerProtocolEngineFactory serverProtocolEngineFactory) {
            BasePlugin.logDebugMessage((String)"ServerDeamon", (String)("Creating a server deamon to listen to connections to port " + serverSocketChannel.socket().getLocalPort()));
            this.handle = protocolHandle;
            this.channel = serverSocketChannel;
            this.factory = serverProtocolEngineFactory;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block16: {
                BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Starting the server deamon.");
                if (this.channel == null) {
                }
                if (this.factory == null) {
                }
                break block16;
                finally {
                    BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Stopping the server deamon.");
                    try {
                        if (this.channel.isOpen()) {
                            this.channel.close();
                        }
                        BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Unregistering all objects related to provided handle from Server Model.");
                        Collection collection = (Collection)ServerModel.this.connectedClients.get(this.handle);
                        Iterator iterator = collection.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                ServerModel.this.openedSocketChannels.remove(this.handle);
                                ServerModel.this.engineFactories.remove(this.handle);
                                ServerModel.this.connectedClients.remove(this.handle);
                                BasePlugin.logInfo((String)"Server deamon stopped.");
                                return;
                            }
                            ProtocolEngine protocolEngine = (ProtocolEngine)iterator.next();
                            protocolEngine.requestStop();
                            collection.remove(protocolEngine);
                            protocolEngine.dispose();
                        }
                    }
                    catch (IOException iOException) {
                        IProtocolExceptionHandler iProtocolExceptionHandler = this.factory.getExceptionHandler();
                        if (iProtocolExceptionHandler == null) return;
                        iProtocolExceptionHandler.handleIOException(this.handle, iOException);
                    }
                }
            }
            while (true) {
                SocketChannel socketChannel;
                try {
                    BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Listening to incoming connections.");
                    socketChannel = this.channel.accept();
                }
                catch (IOException iOException) {
                }
                BasePlugin.logInfo((String)("A client has connected to port " + this.channel.socket().getLocalPort()));
                BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Creating a protocol engine to handle the protocol connection.");
                ProtocolEngine protocolEngine = this.factory.getServerProtocolEngine();
                protocolEngine.requestStart(socketChannel, null);
                BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Registering the protocol engine at Server Model.");
                HashSet<ProtocolEngine> hashSet = (HashSet<ProtocolEngine>)ServerModel.this.connectedClients.get(this.handle);
                if (hashSet == null) {
                    hashSet = new HashSet<ProtocolEngine>();
                    ServerModel.this.connectedClients.put(this.handle, hashSet);
                }
                hashSet.add(protocolEngine);
            }
        }
    }
}

