/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.graphics;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.AbstractPaintStrategy;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.IPainterContext;
import org.eclipse.sequoyah.vnc.vncviewer.network.PixelFormat;
import org.eclipse.sequoyah.vnc.vncviewer.network.RectHeader;

public class ZRLEPaintStrategy
extends AbstractPaintStrategy {
    private MemoryBlockInputStream memoryBlockStream = new MemoryBlockInputStream();
    private DataInput zlibStream = null;

    public ZRLEPaintStrategy(IPainterContext iPainterContext) {
        super(iPainterContext);
    }

    protected int getBytesPerCPixel() {
        int n = 0;
        PixelFormat pixelFormat = this.getContext().getPixelFormat();
        n = pixelFormat.getTrueColourFlag() != 0 && pixelFormat.getBitsPerPixel() == 32 && pixelFormat.getDepth() <= 24 ? 3 : this.getContext().getBytesPerPixel();
        return n;
    }

    public void processRectangle(RectHeader rectHeader, DataInput dataInput) throws Exception {
        int n = rectHeader.getX();
        int n2 = rectHeader.getY();
        int n3 = rectHeader.getWidth();
        int n4 = rectHeader.getHeight();
        DataInput dataInput2 = this.getZlibInputStream();
        this.memoryBlockStream.readBlock(dataInput);
        int[] nArray = new int[4096];
        int n5 = n2;
        while (n5 < n2 + n4) {
            int n6 = Math.min(n2 + n4 - n5, 64);
            int n7 = n;
            while (n7 < n + n3) {
                int n8 = Math.min(n + n3 - n7, 64);
                int n9 = dataInput2.readUnsignedByte();
                boolean bl = (n9 & 0x80) != 0;
                int n10 = n9 & 0x7F;
                int[] nArray2 = new int[128];
                this.readZrlePalette(dataInput2, nArray2, n10);
                if (n10 == 1) {
                    int n11 = nArray2[0];
                    this.getContext().fillRect(n11, n7, n5, n8, n6);
                } else {
                    if (!bl) {
                        if (n10 == 0) {
                            this.readZrleRawPixels(dataInput2, nArray, n8, n6);
                        } else {
                            this.readZrlePackedPixels(dataInput2, nArray, n8, n6, nArray2, n10);
                        }
                    } else if (n10 == 0) {
                        this.readZrlePlainRLEPixels(dataInput2, nArray, n8, n6);
                    } else {
                        this.readZrlePackedRLEPixels(dataInput2, nArray, n8, n6, nArray2);
                    }
                    this.processUpdatedZrleTile(nArray, n7, n5, n8, n6);
                }
                n7 += 64;
            }
            n5 += 64;
        }
    }

    void readZrlePalette(DataInput dataInput, int[] nArray, int n) throws Exception {
        this.readPixels(dataInput, nArray, n);
    }

    void readZrleRawPixels(DataInput dataInput, int[] nArray, int n, int n2) throws Exception {
        this.readPixels(dataInput, nArray, n * n2);
    }

    void readZrlePackedPixels(DataInput dataInput, int[] nArray, int n, int n2, int[] nArray2, int n3) throws Exception {
        int n4 = n3 > 16 ? 8 : (n3 > 4 ? 4 : (n3 > 2 ? 2 : 1));
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = n5 + n;
            int n8 = 0;
            int n9 = 0;
            while (n5 < n7) {
                if (n9 == 0) {
                    n8 = dataInput.readUnsignedByte();
                    n9 = 8;
                }
                int n10 = n8 >> (n9 -= n4) & (1 << n4) - 1 & 0x7F;
                nArray[n5++] = nArray2[n10];
            }
            ++n6;
        }
    }

    /*
     * Unable to fully structure code
     */
    void readZrlePlainRLEPixels(DataInput var1_1, int[] var2_2, int var3_3, int var4_4) throws Exception {
        var5_5 = 0;
        var6_6 = var5_5 + var3_3 * var4_4;
        while (var5_5 < var6_6) {
            var7_7 = this.readPixel(var1_1);
            var8_8 = 1;
            do {
                var9_9 = var1_1.readUnsignedByte();
                var8_8 += var9_9;
            } while (var9_9 == 255);
            if (var8_8 <= var6_6 - var5_5) ** GOTO lbl13
            throw new Exception("ZRLE decoder: assertion failed (len <= end-ptr)");
lbl-1000:
            // 1 sources

            {
                var2_2[var5_5++] = var7_7;
lbl13:
                // 2 sources

                ** while (var8_8-- > 0)
            }
lbl14:
            // 1 sources

        }
    }

    void readZrlePackedRLEPixels(DataInput dataInput, int[] nArray, int n, int n2, int[] nArray2) throws Exception {
        int n3 = 0;
        int n4 = n3 + n * n2;
        while (n3 < n4) {
            int n5;
            int n6 = dataInput.readUnsignedByte();
            int n7 = 1;
            if ((n6 & 0x80) != 0) {
                do {
                    n5 = dataInput.readUnsignedByte();
                    n7 += n5;
                } while (n5 == 255);
                if (n7 > n4 - n3) {
                    throw new Exception("ZRLE decoder: assertion failed (len <= end - ptr)");
                }
            }
            n5 = nArray2[n6 &= 0x7F];
            while (n7-- > 0) {
                nArray[n3++] = n5;
            }
        }
    }

    void readPixels(DataInput dataInput, int[] nArray, int n) throws Exception {
        int n2 = this.getBytesPerCPixel();
        IPainterContext iPainterContext = this.getContext();
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = iPainterContext.readPixel(dataInput, n2);
            ++n3;
        }
    }

    int readPixel(DataInput dataInput) throws Exception {
        return this.getContext().readPixel(dataInput, this.getBytesPerCPixel());
    }

    void processUpdatedZrleTile(int[] nArray, int n, int n2, int n3, int n4) {
        this.getContext().setPixels(n, n2, n3, n4, nArray, 0);
    }

    private DataInput getZlibInputStream() {
        if (this.zlibStream == null) {
            this.zlibStream = new DataInputStream(new InflaterInputStream(this.memoryBlockStream, new Inflater(), 16384));
        }
        return this.zlibStream;
    }

    protected static class MemoryBlockInputStream
    extends InputStream {
        protected byte[] buffer;
        protected int bufferLength;
        int pointer = 0;

        protected MemoryBlockInputStream() {
        }

        public int read() throws IOException {
            if (this.buffer != null) {
                if (this.pointer < this.bufferLength) {
                    return this.buffer[this.pointer++] & 0xFF;
                }
                return -1;
            }
            throw new IOException("EOF");
        }

        public void readBlock(DataInput dataInput) throws Exception {
            int n = dataInput.readInt();
            if (this.buffer == null || this.buffer.length < n) {
                this.buffer = new byte[n];
            }
            dataInput.readFully(this.buffer, 0, n);
            this.bufferLength = n;
            this.pointer = 0;
        }

        public int available() throws IOException {
            if (this.buffer != null) {
                return this.bufferLength - this.pointer;
            }
            return 0;
        }
    }
}

