/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.osgi.framework.Bundle;

public class ScaClassLoader
extends URLClassLoader {
    protected static ClassLoader preferredClassLoader = null;
    private final Bundle bundle;

    public static void setPreferredLoader(EObject object) {
        ClassLoader loader;
        preferredClassLoader = object != null ? (loader = object.getClass().getClassLoader()) : null;
    }

    public static void setPreferredClassLoader(ClassLoader loader) {
        preferredClassLoader = loader;
    }

    public static ClassLoader getPreferredClassLoader() {
        return preferredClassLoader;
    }

    public ScaClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.bundle = null;
    }

    public ScaClassLoader(Bundle bundle, ClassLoader parent) {
        super(new URL[0], parent);
        this.bundle = bundle;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        try {
            if (this.bundle != null) {
                Class c = this.loadClassInBundle(this.bundle, name, true);
                if (c != null) {
                    return c;
                }
                return this.loadClassInPreferredLoader(name);
            }
            return this.loadClassInPreferredLoader(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.loadClassInPreferredLoader(name);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return this.loadClassInPreferredLoader(name);
        }
    }

    private Class loadClassInBundle(Bundle bundle, String name, boolean requiredSearch) {
        block4: {
            try {
                return bundle.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (requiredSearch) {
                    return this.loadClassInRequiredBundles(bundle, name);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (!requiredSearch) break block4;
                return this.loadClassInRequiredBundles(bundle, name);
            }
        }
        return null;
    }

    private Class loadClassInRequiredBundles(Bundle bundle, String name) {
        String requiredBundles = (String)bundle.getHeaders().get("Require-Bundle");
        if (requiredBundles != null) {
            StringTokenizer st = new StringTokenizer(requiredBundles, ",");
            while (st.hasMoreTokens()) {
                Class c;
                Bundle requiredBundle;
                String id = st.nextToken().trim();
                int iDot = id.indexOf(59);
                if (iDot > -1) {
                    id = id.substring(0, iDot).trim();
                }
                if (id.length() <= 0 || (requiredBundle = Platform.getBundle((String)id)) == null || (c = this.loadClassInBundle(requiredBundle, name, false)) == null) continue;
                return c;
            }
        }
        return null;
    }

    private Class loadClassInPreferredLoader(String name) throws ClassNotFoundException {
        try {
            if (preferredClassLoader != null && preferredClassLoader != this && preferredClassLoader != this.getParent()) {
                return preferredClassLoader.loadClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        try {
            return this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.loadClass(name);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return super.loadClass(name);
        }
    }
}

