/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.editors.images;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.internal.provisional.xmleditor.IImageRegistry;
import org.eclipse.soa.sca.core.common.utils.StringUtils;

public class ScaImageRegistryManager {
    public static ScaImageRegistryManager INSTANCE = new ScaImageRegistryManager();
    private final Map<String, IImageRegistry> idToImageRegistry = new HashMap<String, IImageRegistry>();
    private static final String EP_ID = "org.eclipse.soa.sca.common.editors";
    private static final String EP_SCA_ID_ATTR = "specification-id";
    private static final String COMMON_ELT = "Commons";
    private static final String COMMON_REGISTRY_ATT = "class";

    private ScaImageRegistryManager() {
        this.populate();
    }

    public IImageRegistry getIImageRegistry(String spec_id) {
        return this.idToImageRegistry.get(spec_id);
    }

    private void populate() {
        IConfigurationElement[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = reg.getConfigurationElementsFor(EP_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String className;
            IConfigurationElement rootElement = iConfigurationElementArray[n2];
            if (COMMON_ELT.equals(rootElement.getName()) && !StringUtils.isEmpty(className = rootElement.getAttribute(COMMON_REGISTRY_ATT))) {
                String id = rootElement.getAttribute(EP_SCA_ID_ATTR);
                try {
                    Object instance = rootElement.createExecutableExtension(COMMON_REGISTRY_ATT);
                    this.idToImageRegistry.put(id, (IImageRegistry)instance);
                }
                catch (CoreException e) {
                    ScaCoreCommonPlugin.log((Exception)((Object)e), 4);
                }
            }
            ++n2;
        }
    }
}

