/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.editors.preferences.viewers;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.soa.sca.core.common.internal.editors.preferences.beans.ScaXmlAttribute;
import org.eclipse.soa.sca.core.common.internal.editors.preferences.beans.ScaXmlElement;
import org.eclipse.soa.sca.core.common.internal.editors.preferences.beans.ScaXmlNamespace;
import org.eclipse.soa.sca.core.common.internal.editors.preferences.beans.ScaXmlPlatform;

public class ScaXmlPreferencesViewerFilter
extends ViewerFilter {
    private String namespaceFilter;
    private final ScaXmlPlatform.ScaXmlElementType elementType;

    public ScaXmlPreferencesViewerFilter(String namespaceFilter, ScaXmlPlatform.ScaXmlElementType elementType) {
        this.namespaceFilter = namespaceFilter == null ? "" : namespaceFilter;
        this.elementType = elementType;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.namespaceFilter.length() == 0) {
            return true;
        }
        if (element instanceof ScaXmlPlatform) {
            ScaXmlPlatform platform = (ScaXmlPlatform)element;
            if (platform.namespaces.size() == 0) {
                return true;
            }
            for (ScaXmlNamespace ns : platform.namespaces) {
                if (!ns.getName().equals(this.namespaceFilter)) continue;
                return true;
            }
        } else if (element instanceof ScaXmlElement) {
            ScaXmlElement elt = (ScaXmlElement)element;
            if (elt.getPlatform() == null) {
                return true;
            }
            ScaXmlPlatform platform = elt.getPlatform();
            Map<ScaXmlNamespace, List<ScaXmlElement>> elements = this.elementType == ScaXmlPlatform.ScaXmlElementType.bindings ? platform.nsToBindings : (this.elementType == ScaXmlPlatform.ScaXmlElementType.implementations ? platform.nsToImplementations : platform.nsToInterfaces);
            for (Map.Entry<ScaXmlNamespace, List<ScaXmlElement>> entry : elements.entrySet()) {
                boolean result = entry.getKey().getName().equals(this.namespaceFilter);
                if (!result || !entry.getValue().contains(element)) continue;
                return true;
            }
        } else if (element instanceof ScaXmlAttribute) {
            return true;
        }
        return false;
    }

    public String getNamespaceFilter() {
        return this.namespaceFilter;
    }

    public void setNamespaceFilter(String namespaceFilter) {
        this.namespaceFilter = namespaceFilter == null ? "" : namespaceFilter;
    }
}

