/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.formeditor.pages;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.soa.sca.core.common.internal.formeditor.ScaFormEditor;
import org.eclipse.soa.sca.core.common.utils.DomUtils;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractPage
extends FormPage {
    protected IMessageManager mmng;
    protected FormToolkit toolkit;
    protected Document document;
    private static XPath X_PATH = XPathFactory.newInstance().newXPath();
    private static AtomicBoolean inTransaction = new AtomicBoolean(false);

    public AbstractPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public static XPath getXPath() {
        return X_PATH;
    }

    public abstract void updatePage();

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public synchronized void startTransaction() {
        inTransaction.set(true);
        ((ScaFormEditor)this.getEditor()).aboutToChangeModel();
    }

    public synchronized void stopTransaction() {
        ((ScaFormEditor)this.getEditor()).changedModel();
        inTransaction.set(false);
    }

    public Element addElement(String newNodeName, String newNodeNamespaceUri) {
        Node node;
        NodeList nodes = this.document.getElementsByTagNameNS("*", "composite");
        if (nodes.getLength() > 0 && (node = nodes.item(0)) instanceof Element) {
            return this.addElement(node, newNodeName, newNodeNamespaceUri);
        }
        return null;
    }

    public Element addElement(Node parentElement, String newNodeName, String newNodeNamespaceUri) {
        boolean localTransaction = !inTransaction.get();
        try {
            String prefix;
            if (localTransaction) {
                this.startTransaction();
            }
            prefix = (prefix = DomUtils.lookupNamespacePrefix(newNodeNamespaceUri, parentElement)) != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" : "";
            Element newChild = this.document.createElementNS(newNodeNamespaceUri, String.valueOf(prefix) + newNodeName);
            parentElement.appendChild(newChild);
            Element element = newChild;
            return element;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (localTransaction) {
                this.stopTransaction();
            }
        }
        return null;
    }

    public void removeElement(Element element) {
        boolean localTransaction = !inTransaction.get();
        try {
            try {
                if (localTransaction) {
                    this.startTransaction();
                }
                element.getParentNode().removeChild(element);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (localTransaction) {
                    this.stopTransaction();
                }
            }
        }
        finally {
            if (localTransaction) {
                this.stopTransaction();
            }
        }
    }

    public Attr addOrSetAttribute(Element element, String attributeName, String attributeValue) {
        boolean localTransaction = !inTransaction.get();
        try {
            if (localTransaction) {
                this.startTransaction();
            }
            element.setAttribute(attributeName, attributeValue);
            Attr attr = element.getAttributeNode(attributeName);
            return attr;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (localTransaction) {
                this.stopTransaction();
            }
        }
        return null;
    }

    public void updateWiresAndPromotes(String previousName, String newName, boolean isComponentSegment) {
        boolean localTransaction = !inTransaction.get();
        try {
            try {
                if (localTransaction) {
                    this.startTransaction();
                }
                this.updateWiresAndPromotesInTransaction(previousName, newName, isComponentSegment);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (localTransaction) {
                    this.stopTransaction();
                }
            }
        }
        finally {
            if (localTransaction) {
                this.stopTransaction();
            }
        }
    }

    private void updateWiresAndPromotesInTransaction(String previousName, String newName, boolean isComponentSegment) {
        String[] expressions;
        String[] stringArray = expressions = new String[]{"/*[local-name()='composite']/*[local-name()='wire']/@target", "/*[local-name()='composite']/*[local-name()='wire']/@source", "/*[local-name()='composite']/*[local-name()='component']/*[local-name()='reference']/@target", "/*[local-name()='composite']/*[local-name()='service']/@promote", "/*[local-name()='composite']/*[local-name()='reference']/@promote", "/*[local-name()='composite']/*[local-name()='property']/@promote"};
        int n = expressions.length;
        int n2 = 0;
        while (n2 < n) {
            String expr = stringArray[n2];
            try {
                Object result = AbstractPage.getXPath().evaluate(expr, this.getDocument(), XPathConstants.NODESET);
                NodeList nodes = (NodeList)result;
                int i = 0;
                while (i < nodes.getLength()) {
                    String value = nodes.item(i).getNodeValue();
                    String updatedValue = null;
                    if (isComponentSegment) {
                        if (value.startsWith(String.valueOf(previousName) + "/")) {
                            updatedValue = String.valueOf(newName) + "/" + value.substring(previousName.length() + 1);
                        } else if (value.equals(previousName)) {
                            updatedValue = newName;
                        }
                    } else if (value.endsWith("/" + previousName)) {
                        updatedValue = String.valueOf(value.substring(0, value.lastIndexOf(47))) + "/" + newName;
                    }
                    if (updatedValue != null) {
                        nodes.item(i).setNodeValue(updatedValue);
                    }
                    ++i;
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }
}

