/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.soa.sca.core.common.Messages;
import org.eclipse.soa.sca.core.common.ScaCoreCommonPlugin;
import org.eclipse.soa.sca.core.common.utils.ScaResourcesFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    public static List<IFile> getFiles(String extension, Collection<? extends IContainer> containers) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (containers == null) {
            return result;
        }
        for (IContainer iContainer : containers) {
            try {
                IResource[] resources;
                IResource[] iResourceArray = resources = iContainer.members();
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    switch (resource.getType()) {
                        case 1: {
                            String fileExtension = resource.getFileExtension();
                            if (fileExtension == null || !(fileExtension = resource.getFileExtension().toLowerCase()).equals(extension) && !fileExtension.equals("*")) break;
                            result.add((IFile)resource);
                            break;
                        }
                        case 2: {
                            IFolder subFolder = (IFolder)resource;
                            result.addAll(ResourceUtils.getFiles(extension, Arrays.asList(subFolder)));
                            break;
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static List<IFolder> getFolders(IContainer container) {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 2: {
                        IFolder subFolder = (IFolder)resource;
                        result.add(subFolder);
                        result.addAll(ResourceUtils.getFolders((IContainer)subFolder));
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static IFile getIFileFromEditor() {
        IFile result = null;
        try {
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            result = ((FileEditorInput)editorPart.getEditorInput()).getFile();
        }
        catch (Exception e) {
            ScaCoreCommonPlugin.log(e, 4, Messages.ResourceUtils_0);
        }
        return result;
    }

    public static List<IContainer> getContainerChildren(IContainer container) {
        ArrayList<IContainer> result = new ArrayList<IContainer>();
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IContainer) {
                    result.add((IContainer)res);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            ScaCoreCommonPlugin.log((Exception)((Object)e), 4);
        }
        return result;
    }

    public static IResource[] getDirectValidChildren(IContainer container, List<String> extensions, List<IResource> resourcesToSkip) {
        IResource[] result = new IResource[]{};
        if (container instanceof IProject && ((IProject)container).isAccessible()) {
            try {
                result = container.members();
            }
            catch (CoreException coreException) {}
            ArrayList<IResource> resources = new ArrayList<IResource>();
            IResource[] iResourceArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (!resourcesToSkip.contains(r)) {
                    String extension;
                    if (r instanceof IContainer) {
                        IResource[] subRes = ResourceUtils.getDirectValidChildren((IContainer)r, extensions, resourcesToSkip);
                        if (subRes.length > 0) {
                            resources.add(r);
                        }
                    } else if (r instanceof IFile && extensions.contains(extension = ((IFile)r).getFileExtension())) {
                        resources.add(r);
                    }
                }
                ++n2;
            }
            result = new IResource[resources.size()];
            result = resources.toArray(result);
        }
        return result;
    }

    public static IResource[] getDirectValidChildren(IContainer container, String[] extensions, List<IResource> resourcesToSkip) {
        return ResourceUtils.getDirectValidChildren(container, Arrays.asList(extensions), resourcesToSkip);
    }

    public static File getPluginBinaryPath(String pluginId, String binaryFolderName) {
        File result = null;
        if (binaryFolderName == null || binaryFolderName.trim().length() == 0) {
            binaryFolderName = "bin";
        }
        try {
            File binaryFolder;
            File bundleFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)pluginId));
            if (bundleFile.isFile()) {
                result = bundleFile;
            } else if (bundleFile.isDirectory() && (binaryFolder = new File(bundleFile, binaryFolderName)).exists() && binaryFolder.isDirectory()) {
                result = binaryFolder;
            }
        }
        catch (Exception e) {
            ScaCoreCommonPlugin.log(e, 4);
        }
        return result;
    }

    public static IFile getCompositeFile(String compositeName) {
        IFile result = null;
        IFile currentCompositeFile = null;
        if (compositeName != null && (currentCompositeFile = ResourceUtils.getIFileFromEditor()) != null) {
            IProject project = currentCompositeFile.getProject();
            Set<IContainer> sourceContainers = ScaResourcesFilter.getSourceContainers(project);
            List<IFile> composites = ResourceUtils.getFiles("composite", sourceContainers);
            for (IFile compositeFile : composites) {
                if (!compositeName.equals(compositeFile.getName())) continue;
                result = compositeFile;
                break;
            }
            if (result == null) {
                try {
                    IProject[] projects = project.getReferencedProjects();
                    if (projects == null) {
                        projects = new IProject[]{};
                    }
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject refProject = iProjectArray[n2];
                        sourceContainers = ScaResourcesFilter.getSourceContainers(refProject);
                        composites = ResourceUtils.getFiles("composite", sourceContainers);
                        for (IFile compositeFile : composites) {
                            if (!compositeName.equals(compositeFile.getName())) continue;
                            result = compositeFile;
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return result;
    }
}

