/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.common.introspection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.soa.sca.sca1_0.common.Messages;
import org.eclipse.soa.sca.sca1_0.common.introspection.IntrospectionUtils;
import org.eclipse.soa.sca.sca1_0.common.introspection.Resolver;
import org.eclipse.soa.sca.sca1_0.common.introspection.metadata.MetaData;
import org.eclipse.soa.sca.sca1_0.model.sca.Component;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_0.model.sca.Composite;
import org.eclipse.soa.sca.sca1_0.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_0.model.sca.Interface;
import org.eclipse.soa.sca.sca1_0.model.sca.JavaImplementation;
import org.eclipse.soa.sca.sca1_0.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_0.model.sca.ScaFactory;
import org.eclipse.soa.sca.sca1_0.model.sca.ScaPackage;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaInterfaceResolver
implements Resolver {
    private final ClassLoader classLoader;
    Logger log = Logger.getLogger(JavaInterfaceResolver.class.getCanonicalName());

    public JavaInterfaceResolver(ClassLoader classLoaderC) {
        this.classLoader = classLoaderC;
    }

    @Override
    public Composite resolve(Composite composite) {
        for (Component c : composite.getComponent()) {
            Implementation imp = c.getImplementation();
            if (imp.eClass().getClassifierID() != 43) continue;
            JavaImplementation javaImpl = (JavaImplementation)imp;
            try {
                Class<?> cl = this.classLoader.loadClass(javaImpl.getClass_());
                MetaData ccmd = new MetaData(cl);
                this.resolveServices(c, ccmd);
                this.resolveReferences(c, ccmd);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.fine(String.valueOf(Messages.JavaInterfaceResolver_0) + javaImpl.getClass_());
            }
        }
        return composite;
    }

    public void resolveServices(Component component, MetaData<?> cMetaData) {
        Class[] i;
        Service s = cMetaData.getAnnotation(Service.class);
        Class[] interfaces = null;
        if (s != null) {
            interfaces = s.interfaces().length < 1 ? new Class[]{s.value()} : s.interfaces();
        } else {
            JavaImplementation javaImpl = (JavaImplementation)component.getImplementation();
            try {
                Class<?> implementation = this.classLoader.loadClass(javaImpl.getClass_());
                interfaces = implementation.getInterfaces();
            }
            catch (ClassNotFoundException e) {
                this.log.severe(NLS.bind((String)Messages.JavaInterfaceResolver_1, (Object)javaImpl.getClass_()));
                e.printStackTrace();
            }
        }
        HashMap<String, String> serviceMap = new HashMap<String, String>();
        HashMap<String, String> missingServiceMap = new HashMap<String, String>();
        EList serviceList = component.getService();
        for (ComponentService componentService : serviceList) {
            Interface itf = componentService.getInterface();
            if (itf != null) {
                if (componentService.getInterface().eClass().getClassifierID() != 44) continue;
                serviceMap.put(componentService.getName(), ((JavaInterface)componentService.getInterface()).getInterface());
                continue;
            }
            i = ScaFactory.eINSTANCE.createJavaInterface();
            i.setInterface(interfaces[0].getCanonicalName());
            ((FeatureMap.Internal)componentService.getInterfaceGroup()).clear();
            ((FeatureMap.Internal)componentService.getInterfaceGroup()).add((EStructuralFeature)ScaPackage.Literals.BASE_SERVICE__INTERFACE_GROUP, (Object)FeatureMapUtil.createEntry((EStructuralFeature)ScaPackage.Literals.DOCUMENT_ROOT__INTERFACE_JAVA, (Object)i));
            serviceMap.put(componentService.getName(), interfaces[0].getCanonicalName());
        }
        if (interfaces != null) {
            i = interfaces;
            int n = i.length;
            int n2 = 0;
            while (n2 < n) {
                JavaInterface jInterface = i[n2];
                if (!serviceMap.containsValue(jInterface.getName())) {
                    String sName = jInterface.getSimpleName();
                    missingServiceMap.put(sName, jInterface.getName());
                }
                ++n2;
            }
        }
        Set serviceSet = missingServiceMap.keySet();
        for (String key : serviceSet) {
            ComponentService c = ScaFactory.eINSTANCE.createComponentService();
            JavaInterface i2 = ScaFactory.eINSTANCE.createJavaInterface();
            i2.setInterface((String)missingServiceMap.get(key));
            c.setName(key);
            ((FeatureMap.Internal)c.getInterfaceGroup()).clear();
            ((FeatureMap.Internal)c.getInterfaceGroup()).add((EStructuralFeature)ScaPackage.Literals.BASE_SERVICE__INTERFACE_GROUP, (Object)FeatureMapUtil.createEntry((EStructuralFeature)ScaPackage.Literals.DOCUMENT_ROOT__INTERFACE_JAVA, (Object)i2));
            component.getService().add((Object)c);
        }
    }

    public void resolveReferences(Component component, MetaData<?> cMetaData) {
        AccessibleObject[] o = cMetaData.getAllAnnotatedMethodsAndFields(Reference.class);
        if (o != null) {
            HashMap<String, String> referenceMap = new HashMap<String, String>();
            HashMap<String, String> referenceDecMap = new HashMap<String, String>();
            AccessibleObject[] accessibleObjectArray = o;
            int n = o.length;
            int n2 = 0;
            while (n2 < n) {
                AccessibleObject object = accessibleObjectArray[n2];
                String key = IntrospectionUtils.getReferenceName(object);
                if (key != null) {
                    referenceDecMap.put(key, this.getReferenceClassName(object));
                }
                ++n2;
            }
            EList referenceList = component.getReference();
            for (ComponentReference componentReference : referenceList) {
                Interface itf = componentReference.getInterface();
                if (itf != null) {
                    if (itf.eClass().getClassifierID() != 44) continue;
                    referenceMap.put(componentReference.getName(), ((JavaInterface)componentReference.getInterface()).getInterface());
                    continue;
                }
                String referenceName = componentReference.getName();
                String interfaceClass = (String)referenceDecMap.get(referenceName);
                if (interfaceClass == null) continue;
                JavaInterface newJavaItf = ScaFactory.eINSTANCE.createJavaInterface();
                newJavaItf.setInterface(interfaceClass);
                ((FeatureMap.Internal)componentReference.getInterfaceGroup()).clear();
                ((FeatureMap.Internal)componentReference.getInterfaceGroup()).add((EStructuralFeature)ScaPackage.Literals.BASE_REFERENCE__INTERFACE_GROUP, (Object)FeatureMapUtil.createEntry((EStructuralFeature)ScaPackage.Literals.DOCUMENT_ROOT__INTERFACE_JAVA, (Object)newJavaItf));
                referenceMap.put(referenceName, interfaceClass);
            }
            Set references = referenceDecMap.keySet();
            for (String key : references) {
                if (referenceMap.containsKey(key)) continue;
                ComponentReference c = ScaFactory.eINSTANCE.createComponentReference();
                JavaInterface i = ScaFactory.eINSTANCE.createJavaInterface();
                i.setInterface((String)referenceDecMap.get(key));
                c.setName(key);
                ((FeatureMap.Internal)c.getInterfaceGroup()).clear();
                ((FeatureMap.Internal)c.getInterfaceGroup()).add((EStructuralFeature)ScaPackage.Literals.BASE_REFERENCE__INTERFACE_GROUP, (Object)FeatureMapUtil.createEntry((EStructuralFeature)ScaPackage.Literals.DOCUMENT_ROOT__INTERFACE_JAVA, (Object)i));
                component.getReference().add((Object)c);
            }
        }
    }

    private String getReferenceClassName(AccessibleObject object) {
        if (object instanceof Field) {
            Field field = (Field)object;
            return field.getType().getCanonicalName();
        }
        if (object instanceof Method) {
            Method method = (Method)object;
            Class<?>[] classe = method.getParameterTypes();
            if (classe.length > 0) {
                return classe[0].getCanonicalName();
            }
            return method.getReturnType().getCanonicalName();
        }
        return null;
    }
}

