/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_1.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.DocumentRoot;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.soa.sca.sca1_1.model.sca.util.ScaResourceFactoryImpl;
import org.eclipse.soa.sca.sca1_1.model.sca.util.ScaResourceImpl;

public class ScaCompositeUtils {
    public static Composite getComposite(IResource compositeFile) {
        Composite result = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ScaResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://docs.oasis-open.org/ns/opencsa/sca/200912", (Object)ScaPackage.eINSTANCE);
        URI uri = URI.createFileURI((String)compositeFile.getFullPath().toString());
        try {
            Resource resource = resourceSet.getResource(uri, true);
            for (EObject eObject : resource.getContents()) {
                Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
                if (diagnostic.getSeverity() != 0 || !(eObject instanceof DocumentRoot)) continue;
                result = ((DocumentRoot)eObject).getComposite();
            }
        }
        catch (RuntimeException exception) {
            exception.printStackTrace();
        }
        return result;
    }

    public static Composite getComposite(InputStream inputStream) {
        Composite result = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ScaResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://docs.oasis-open.org/ns/opencsa/sca/200912", (Object)ScaPackage.eINSTANCE);
        try {
            ScaResourceImpl resource = new ScaResourceImpl(null);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("EXTENDED_META_DATA", ExtendedMetaData.INSTANCE);
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
            options.put("ZIP", Boolean.FALSE);
            try {
                resource.load(inputStream, options);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (EObject eObject : resource.getContents()) {
                Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
                if (diagnostic.getSeverity() != 0 || !(eObject instanceof DocumentRoot)) continue;
                result = ((DocumentRoot)eObject).getComposite();
            }
        }
        catch (RuntimeException exception) {
            exception.printStackTrace();
        }
        return result;
    }
}

