/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.PromptForConnectionAndEndCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.ElementTypeLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.commands.IElementTypeEx;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.diagram.ui.PopupMenuWithDisableSupport;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class PromptForConnectionAndEndCommandEx
extends PromptForConnectionAndEndCommand {
    private static final String UNDERLYING_POOL = "underlying pool";
    private static Image EXISTING = null;
    protected static String EXISTING_ELEMENT = DiagramUIMessages.ConnectionHandle_Popup_ExistingElement;
    private CreateConnectionRequest request;
    private IGraphicalEditPart _containerEP;
    private ObjectAdapter connectionAdapter = new ObjectAdapter();
    private ObjectAdapter endAdapter = new ObjectAdapter();

    public PromptForConnectionAndEndCommandEx(CreateConnectionRequest request, IGraphicalEditPart containerEP) {
        super(request, containerEP);
        this.request = request;
        this._containerEP = containerEP;
    }

    protected List getConnectionMenuContent() {
        ArrayList l = new ArrayList(super.getConnectionMenuContent());
        EditPart source = this.request.getSourceEditPart();
        EditPart target = this.request.getTargetEditPart();
        EditPart sPool = this.getPool(source);
        EditPart tPool = this.getPool(target);
        EditPart sContainer = this.getContainer(source.getParent());
        if (tPool != null && sPool.equals(tPool)) {
            l.remove(BpmnElementTypes.MessagingEdge_3002);
        }
        if (!(tPool == null || sContainer == this._containerEP && sPool.equals(tPool))) {
            l.remove(BpmnElementTypes.SequenceEdge_3001);
        }
        return l;
    }

    protected List getEndMenuContent(Object connectionItem) {
        List l = super.getEndMenuContent(connectionItem);
        if ((IMetamodelType)connectionItem == BpmnElementTypes.Association_3003) {
            l.remove(EXISTING_ELEMENT);
        }
        EditPart source = this.request.getSourceEditPart();
        EditPart target = this.request.getTargetEditPart();
        EditPart sPool = this.getPool(source);
        EditPart tPool = this.getPool(target);
        EditPart sContainer = this.getContainer(source.getParent());
        if (!(connectionItem instanceof IMetamodelType)) {
            return l;
        }
        if ((IMetamodelType)connectionItem == BpmnElementTypes.MessagingEdge_3002) {
            if (tPool != null && sPool.equals(tPool)) {
                l.clear();
            } else {
                l.add(0, UNDERLYING_POOL);
            }
        } else if (!((IMetamodelType)connectionItem != BpmnElementTypes.SequenceEdge_3001 || tPool == null || sContainer == this._containerEP && sPool.equals(tPool))) {
            l.clear();
        }
        if (l.isEmpty()) {
            return l;
        }
        ArrayList result = new ArrayList();
        ArrayList<Object> activities = new ArrayList<Object>();
        ArrayList tasks = new ArrayList();
        ArrayList gateways = new ArrayList();
        ArrayList startEvents = new ArrayList();
        ArrayList intermediateEvents = new ArrayList();
        ArrayList endEvents = new ArrayList();
        IElementType simpleTask = null;
        for (Object elt : l) {
            if (elt instanceof IElementTypeEx) {
                IElementTypeEx eltType = (IElementTypeEx)elt;
                String secHint = eltType.getSecondarySemanticHint();
                ActivityType actype = ActivityType.get((String)secHint);
                if (ActivityType.VALUES_EVENTS.contains(actype)) {
                    if (ActivityType.VALUES_EVENTS_START.contains(actype)) {
                        startEvents.add(elt);
                        continue;
                    }
                    if (ActivityType.VALUES_EVENTS_INTERMEDIATE.contains(actype)) {
                        intermediateEvents.add(elt);
                        continue;
                    }
                    endEvents.add(elt);
                    continue;
                }
                if (ActivityType.VALUES_GATEWAYS.contains(actype)) {
                    gateways.add(elt);
                    continue;
                }
                if (eltType.getId().equals(BpmnElementTypes.Activity_2001.getId()) && ActivityType.TASK_LITERAL.equals((Object)actype)) {
                    simpleTask = (IElementType)elt;
                    continue;
                }
                tasks.add(elt);
                continue;
            }
            if (elt == BpmnElementTypes.SubProcess_2002) {
                tasks.add(elt);
                continue;
            }
            if (elt == null) continue;
            result.add(elt);
        }
        ILabelProvider provider = this.getConnectionAndEndLabelProvider(connectionItem);
        if (simpleTask != null) {
            activities.add(simpleTask);
        }
        if (!tasks.isEmpty()) {
            activities.add((Object)new PopupMenuWithDisableSupport.CascadingMenuWithDisableSupport(BpmnDiagramMessages.PromptForConnectionAndEndCommandEx_activities_menu_label, new PopupMenuWithDisableSupport(tasks, provider)));
        }
        if (!gateways.isEmpty()) {
            activities.add((Object)new PopupMenuWithDisableSupport.CascadingMenuWithDisableSupport(BpmnDiagramMessages.PromptForConnectionAndEndCommandEx_gateways_menu_label, new PopupMenuWithDisableSupport(gateways, provider)));
        }
        if (!startEvents.isEmpty()) {
            activities.add((Object)new PopupMenuWithDisableSupport.CascadingMenuWithDisableSupport(BpmnDiagramMessages.PromptForConnectionAndEndCommandEx_start_events_menu_label, new PopupMenuWithDisableSupport(startEvents, provider)));
        }
        if (!intermediateEvents.isEmpty()) {
            activities.add((Object)new PopupMenuWithDisableSupport.CascadingMenuWithDisableSupport(BpmnDiagramMessages.PromptForConnectionAndEndCommandEx_intermediate_label, new PopupMenuWithDisableSupport(intermediateEvents, provider)));
        }
        if (!endEvents.isEmpty()) {
            activities.add((Object)new PopupMenuWithDisableSupport.CascadingMenuWithDisableSupport(BpmnDiagramMessages.PromptForConnectionAndEndCommandEx_end_events_menu_label, new PopupMenuWithDisableSupport(endEvents, provider)));
        }
        result.addAll(0, activities);
        return result;
    }

    protected EditPart getPool(EditPart editPart) {
        if (editPart instanceof PoolEditPart) {
            return editPart;
        }
        if (editPart == null) {
            return null;
        }
        EditPart parent = editPart.getParent();
        while (!(parent instanceof PoolEditPart) && parent != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    protected EditPart getContainer(EditPart editPart) {
        if (editPart instanceof PoolPoolCompartmentEditPart || editPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
            return editPart;
        }
        EditPart parent = editPart.getParent();
        if (parent == null) {
            return null;
        }
        return this.getContainer(parent);
    }

    protected ILabelProvider getConnectionAndEndLabelProvider(Object connectionItem) {
        return new ConnectionAndEndLabelProviderEx(connectionItem);
    }

    private CommandResult doExecuteWithResultPopupMenuCommand(IProgressMonitor progressMonitor) {
        if (this.getPopupMenu() != null) {
            if (!this.getPopupMenu().show((Control)this.getParentShell())) {
                progressMonitor.setCanceled(true);
                return CommandResult.newCancelledCommandResult();
            }
            return CommandResult.newOKCommandResult((Object)this.getPopupMenu().getResult());
        }
        if (this.getPopupDialog() != null) {
            if (this.getPopupDialog().open() == 1 || this.getPopupDialog().getResult() == null || this.getPopupDialog().getResult().length <= 0) {
                progressMonitor.setCanceled(true);
                return CommandResult.newCancelledCommandResult();
            }
            return CommandResult.newOKCommandResult((Object)this.getPopupDialog().getResult()[0]);
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        List resultList;
        PopupMenu popup = this.createPopupMenu();
        if (popup == null) {
            return CommandResult.newErrorCommandResult((String)this.getLabel());
        }
        this.setPopupMenu(popup);
        CommandResult cmdResult = this.doExecuteWithResultPopupMenuCommand(progressMonitor);
        if (!cmdResult.getStatus().isOK()) {
            return cmdResult;
        }
        Object result = cmdResult.getReturnValue();
        if (result instanceof List && (resultList = (List)result).size() == 2) {
            this.connectionAdapter.setObject(resultList.get(0));
            Object targetResult = resultList.get(1);
            if (targetResult instanceof List) {
                targetResult = ((List)targetResult).get(((List)targetResult).size() - 1);
            }
            if (targetResult.equals(EXISTING_ELEMENT)) {
                Object object = targetResult = this.isDirectionReversed() ? ModelingAssistantService.getInstance().selectExistingElementForSource((IAdaptable)this.getKnownEnd(), (IElementType)resultList.get(0)) : ModelingAssistantService.getInstance().selectExistingElementForTarget((IAdaptable)this.getKnownEnd(), (IElementType)resultList.get(0));
                if (targetResult == null) {
                    return CommandResult.newCancelledCommandResult();
                }
            } else if (targetResult.equals(UNDERLYING_POOL)) {
                targetResult = ((IGraphicalEditPart)this.getPool(this.request.getTargetEditPart())).resolveSemanticElement();
            }
            this.endAdapter.setObject(targetResult);
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)this.getLabel());
    }

    private EditPart getKnownEnd() {
        return this.request.getSourceEditPart();
    }

    public ObjectAdapter getConnectionAdapter() {
        return this.connectionAdapter;
    }

    public IAdaptable getEndAdapter() {
        return this.endAdapter;
    }

    protected PopupMenu createPopupMenu() {
        final List connectionMenuContent = this.getConnectionMenuContent();
        if (connectionMenuContent == null || connectionMenuContent.isEmpty()) {
            return null;
        }
        if (connectionMenuContent.size() == 1) {
            List menuContent = this.getEndMenuContent(connectionMenuContent.get(0));
            if (menuContent == null || menuContent.isEmpty()) {
                return null;
            }
            ILabelProvider labelProvider = this.getConnectionAndEndLabelProvider(connectionMenuContent.get(0));
            return new PopupMenuWithDisableSupport(menuContent, labelProvider){

                public Object getResult() {
                    Object endResult = super.getResult();
                    if (endResult == null) {
                        return null;
                    }
                    ArrayList<Object> resultList = new ArrayList<Object>(2);
                    resultList.add(connectionMenuContent.get(0));
                    resultList.add(endResult);
                    return resultList;
                }
            };
        }
        ArrayList<PopupMenu.CascadingMenu> menuContent = new ArrayList<PopupMenu.CascadingMenu>();
        for (Object connectionItem : connectionMenuContent) {
            List subMenuContent = this.getEndMenuContent(connectionItem);
            if (subMenuContent.isEmpty()) continue;
            PopupMenuWithDisableSupport subMenu = new PopupMenuWithDisableSupport(subMenuContent, this.getEndLabelProvider());
            menuContent.add(new PopupMenu.CascadingMenu(connectionItem, (PopupMenu)subMenu));
        }
        if (!menuContent.isEmpty()) {
            return new PopupMenuWithDisableSupport(menuContent, this.getConnectionLabelProvider());
        }
        return null;
    }

    protected class ConnectionAndEndLabelProviderEx
    extends ElementTypeLabelProvider {
        private Object connectionItem;

        public void dispose() {
            super.dispose();
            if (EXISTING != null) {
                EXISTING.dispose();
                EXISTING = null;
            }
        }

        protected ConnectionAndEndLabelProviderEx(Object connectionItem) {
            this.connectionItem = connectionItem;
        }

        public Image getImage(Object object) {
            return super.getImage(object);
        }

        public String getText(Object element) {
            if (element instanceof String) {
                if (EXISTING_ELEMENT.equals(element)) {
                    return BpmnDiagramMessages.PromptForConnectionAndEndCommandEx_ConnectToExisting;
                }
                if (PromptForConnectionAndEndCommandEx.UNDERLYING_POOL.equals(element)) {
                    return BpmnDiagramMessages.PromptForConnectionAndEndCommandEx_underlying_pool_label;
                }
                return (String)element;
            }
            return super.getText(element);
        }

        protected Object getConnectionItem() {
            return this.connectionItem;
        }
    }
}

