/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.ui.action.ActionMenuManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.actions.FilterDecorationsAction;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.providers.BpmnDecorationFilterService;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class FilterDecorationsMenuManager
extends ActionMenuManager {
    public static final String ID = "FilterDecorationsMenuManager";

    public FilterDecorationsMenuManager(IWorkbenchPage page) {
        super(ID, (IAction)new FilterDecorationsAction(page), false);
        BpmnDecorationFilterService filterService = BpmnDecorationFilterService.getInstance();
        for (String filterId : filterService.getCurrentFilters()) {
            TriggerFilterAction action = new TriggerFilterAction();
            action.setId(filterId);
            ImageDescriptor imageDesc = filterService.getFilterImageDescriptor(filterId);
            action.setImageDescriptor(imageDesc);
            String name = filterService.getFilterName(filterId);
            action.setText(name);
            action.setToolTipText(name);
            action.setChecked(filterService.isFilterActive(filterId));
            this.add((IAction)action);
        }
    }

    private static class FilterDecorationsMenuManagerAction
    extends Action {
        public FilterDecorationsMenuManagerAction() {
            this.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/showDecorations.gif"));
            this.setToolTipText(BpmnDiagramMessages.FilterDecorationsMenuManager_tooltip);
            this.setId(FilterDecorationsMenuManager.ID);
        }
    }

    private class TriggerFilterAction
    extends Action {
        private TriggerFilterAction() {
        }

        public void run() {
            BpmnDecorationFilterService.getInstance().filterChanged(this.getId());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                IEditorPart part = page.getActiveEditor();
                EditPart ep = (EditPart)part.getAdapter(EditPart.class);
                ep.refresh();
                this.recursiveRefresh(ep);
            }
        }

        private void recursiveRefresh(EditPart part) {
            for (Object child : part.getChildren()) {
                ((EditPart)child).refresh();
                this.recursiveRefresh((EditPart)child);
            }
        }
    }
}

