/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions.activitytypes;

import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.provider.ActivityItemProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class ChangeActivityTypeAction
extends AbstractActionHandler {
    public static final String ABSTRACT_ID = "setActivityTypeTo";
    private ActivityType _type;

    public ChangeActivityTypeAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    public ChangeActivityTypeAction(IWorkbenchPage workbenchPage, String name) {
        super(workbenchPage);
        this._type = ActivityType.get((String)name.substring(ABSTRACT_ID.length()));
    }

    public void init() {
        super.init();
        this.setId(ABSTRACT_ID + this.getActivityType().getLiteral());
        this.setText(this.getActivityType().getName());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)((URL)new ActivityItemProvider(null).getImage((Object)this.getActivityType()))));
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        IGraphicalEditPart part = this.getGraphicalEditPart();
        Command co = this.getCommand();
        if (part == null || co == null) {
            return;
        }
        DiagramCommandStack stack = part.getDiagramEditDomain().getDiagramCommandStack();
        stack.execute(co, progressMonitor);
    }

    private IGraphicalEditPart getGraphicalEditPart() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (selection.getFirstElement() instanceof IGraphicalEditPart) {
            IGraphicalEditPart part = (IGraphicalEditPart)selection.getFirstElement();
            return part;
        }
        return null;
    }

    private Command getCommand() {
        IGraphicalEditPart part = this.getGraphicalEditPart();
        if (part != null) {
            Request request = new Request((Object)"activity_type_change_request");
            request.getExtendedData().put(ActivityItemSemanticEditPolicy.ACTIVITY_TYPE_EXTENDED_DATA, this._type);
            Command co = part.getCommand(request);
            return co;
        }
        return null;
    }

    public void refresh() {
        boolean forbidEnablement = false;
        IGraphicalEditPart selected = this.getGraphicalEditPart();
        if (selected instanceof IGraphicalEditPart) {
            selected = selected.resolveSemanticElement();
        }
        if (!(selected instanceof Activity)) {
            forbidEnablement = true;
        }
        if (forbidEnablement) {
            this.setEnabled(false);
            return;
        }
        Command co = this.getCommand();
        this.setEnabled(co != null && co.canExecute());
    }

    public ActivityType getActivityType() {
        return this._type;
    }
}

