/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions.associationdirectiontypes;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.DataObject;
import org.eclipse.stp.bpmn.DirectionType;
import org.eclipse.stp.bpmn.Group;
import org.eclipse.stp.bpmn.TextAnnotation;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.ui.IWorkbenchPage;

public class ChangeAssociationDirectionTypeAction
extends AbstractActionHandler {
    public static final String ABSTRACT_ID = "setAssociationDirectionTypeTo";
    private DirectionType _type;

    public ChangeAssociationDirectionTypeAction(IWorkbenchPage workbenchPage, String name) {
        super(workbenchPage);
        this._type = DirectionType.get((String)name.substring(ABSTRACT_ID.length()));
        if (this._type == null) {
            this._type = DirectionType.NONE_LITERAL;
        }
    }

    public void init() {
        super.init();
        if (this.getDirectionType() == null) {
            return;
        }
        this.setId(ABSTRACT_ID + this.getDirectionType().getLiteral());
        Association assoc = this.getAssociationSelected();
        if (assoc == null || this.getDirectionType().getValue() == 0) {
            this.setText(this.getDirectionType().getName());
        } else if (this.getDirectionType().getValue() == 3) {
            this.setText(BpmnDiagramMessages.ChangeAssociationDirectionTypeAction_both_directions);
        } else {
            String sourceL = BpmnDiagramMessages.ChangeAssociationDirectionTypeAction_artifact;
            if (assoc.getSource() instanceof DataObject) {
                sourceL = BpmnDiagramMessages.ChangeAssociationDirectionTypeAction_data_object;
            } else if (assoc.getSource() instanceof TextAnnotation) {
                sourceL = BpmnDiagramMessages.ChangeAssociationDirectionTypeAction_text_annotation;
            } else if (assoc.getSource() instanceof Group) {
                sourceL = BpmnDiagramMessages.ChangeAssociationDirectionTypeAction_group;
            }
            String targetL = BpmnDiagramMessages.ChangeAssociationDirectionTypeAction_shape;
            if (assoc.getTarget() instanceof Activity) {
                targetL = ((Activity)assoc.getTarget()).getActivityType().getName();
            }
            if (this.getDirectionType().getValue() == 2) {
                this.setText(BpmnDiagramMessages.bind((String)BpmnDiagramMessages.ChangeAssociationDirectionTypeAction_from_to, (Object)sourceL, (Object)targetL));
            } else {
                this.setText(BpmnDiagramMessages.bind((String)BpmnDiagramMessages.ChangeAssociationDirectionTypeAction_from_to, (Object)targetL, (Object)sourceL));
            }
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        final Association assoc = this.getAssociationSelected();
        if (assoc == null) {
            return;
        }
        TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)assoc);
        RecordingCommand myCmd = new RecordingCommand(domain){

            protected void doExecute() {
                assoc.setDirection(ChangeAssociationDirectionTypeAction.this.getDirectionType());
                ConnectionEditPart gp = ChangeAssociationDirectionTypeAction.this.getGraphicalPartSelected();
                if (gp != null) {
                    gp.refresh();
                }
            }
        };
        domain.getCommandStack().execute((Command)myCmd);
    }

    protected Association getAssociationSelected() {
        EObject object;
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (selection.getFirstElement() instanceof IGraphicalEditPart && (object = ((IGraphicalEditPart)selection.getFirstElement()).resolveSemanticElement()) instanceof Association) {
            return (Association)object;
        }
        return null;
    }

    protected ConnectionEditPart getGraphicalPartSelected() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (selection.getFirstElement() instanceof ConnectionEditPart) {
            return (ConnectionEditPart)selection.getFirstElement();
        }
        return null;
    }

    public void refresh() {
        boolean forbidEnablement = false;
        if (this.getSelection() == null || this.getSelection().isEmpty()) {
            forbidEnablement = true;
        }
        if (!(this.getSelection() instanceof IStructuredSelection)) {
            forbidEnablement = true;
        }
        if (forbidEnablement) {
            this.setEnabled(false);
            return;
        }
        Object selected = ((IStructuredSelection)this.getSelection()).getFirstElement();
        if (selected instanceof IGraphicalEditPart) {
            selected = ((IGraphicalEditPart)selected).getNotationView().getElement();
        }
        if (!(selected instanceof Association)) {
            forbidEnablement = true;
        }
        if (forbidEnablement) {
            this.setEnabled(false);
            return;
        }
        Association assoc = (Association)selected;
        if (assoc.getDirection() == this.getDirectionType()) {
            forbidEnablement = true;
        }
        this.setEnabled(!forbidEnablement);
    }

    public DirectionType getDirectionType() {
        return this._type;
    }
}

