/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.common.ui.action.ActionMenuManager;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.stp.bpmn.Identifiable;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.providers.BpmnValidationDecoratorProvider;
import org.eclipse.stp.bpmn.diagram.providers.ImageDescriptorForImage;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.MarkerResolutionSelectionDialog;
import org.eclipse.ui.ide.IDE;

public class QuickfixResolutionMenuManager
implements IMenuListener {
    public static final String ID = "Quickfixes";
    private static final String IMG_ELCL_QUICK_FIX_ENABLED = "IMG_ELCL_QUICK_FIX_ENABLED";
    private final GraphicalViewer _graphicalViewer;
    private IFile _diagramFile;

    public QuickfixResolutionMenuManager(GraphicalViewer graphicalViewer) {
        this._graphicalViewer = graphicalViewer;
    }

    private IFile getFile() {
        if (this._diagramFile != null && this._diagramFile.exists()) {
            return this._diagramFile;
        }
        this._diagramFile = WorkspaceSynchronizer.getFile((Resource)((EObject)this._graphicalViewer.getRootEditPart().getContents().getModel()).eResource());
        return this._diagramFile;
    }

    public void menuAboutToShow(IMenuManager manager) {
        HashMap<String, Identifiable> selectedBPmnIDs = null;
        HashMap<String, View> selectedViewIDs = null;
        for (Object ep : this._graphicalViewer.getSelectedEditParts()) {
            View view;
            if (!(ep instanceof GraphicalEditPart)) continue;
            GraphicalEditPart gep = (GraphicalEditPart)ep;
            Identifiable identifiable = (Identifiable)gep.getAdapter(Identifiable.class);
            if (identifiable != null) {
                if (selectedBPmnIDs == null) {
                    selectedBPmnIDs = new HashMap<String, Identifiable>();
                }
                selectedBPmnIDs.put(identifiable.getID(), identifiable);
            }
            if ((view = (View)gep.getAdapter(View.class)) == null) continue;
            if (selectedViewIDs == null) {
                selectedViewIDs = new HashMap<String, View>();
            }
            selectedViewIDs.put(ViewUtil.getIdStr((View)view), view);
        }
        if (selectedBPmnIDs == null && selectedViewIDs == null) {
            return;
        }
        HashMap<String, ArrayList<IMarker>> markerIndex = null;
        LinkedHashSet<IMarker> allMarkers = null;
        try {
            IMarker[] markers = this.getFile().findMarkers("org.eclipse.stp.bpmn.validation.diagnostic", true, 2);
            if (markers == null || markers.length == 0) {
                return;
            }
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int view = 0;
            while (view < n) {
                IMarker m = iMarkerArray[view];
                if (IDE.getMarkerHelpRegistry().hasResolutions(m)) {
                    ArrayList<IMarker> marks;
                    String elemId = (String)m.getAttribute("elementId");
                    String bpmnId = (String)m.getAttribute("bpmnId");
                    if (bpmnId != null && selectedBPmnIDs != null && selectedBPmnIDs.containsKey(bpmnId)) {
                        if (markerIndex == null) {
                            markerIndex = new HashMap<String, ArrayList<IMarker>>();
                        }
                        if (allMarkers == null) {
                            allMarkers = new LinkedHashSet<IMarker>();
                        }
                        if ((marks = (ArrayList<IMarker>)markerIndex.get(bpmnId)) == null) {
                            marks = new ArrayList<IMarker>();
                            markerIndex.put(bpmnId, marks);
                        }
                        marks.add(m);
                        allMarkers.add(m);
                    }
                    if (elemId != null && selectedViewIDs != null && selectedViewIDs.containsKey(elemId)) {
                        if (markerIndex == null) {
                            markerIndex = new HashMap();
                        }
                        if (allMarkers == null) {
                            allMarkers = new LinkedHashSet();
                        }
                        if ((marks = (List)markerIndex.get(elemId)) == null) {
                            marks = new ArrayList();
                            markerIndex.put(elemId, marks);
                        }
                        marks.add(m);
                        allMarkers.add(m);
                    }
                }
                ++view;
            }
            if (markerIndex == null) {
                return;
            }
        }
        catch (CoreException e) {
            BpmnDiagramEditorPlugin.getInstance().logError("Matching markers to shapes failure", e);
            return;
        }
        final LinkedHashSet<IMarker> allTheMarkers = allMarkers;
        Action quikcfixMenuAction = new Action(BpmnDiagramMessages.QuickfixResolutionMenuManager_menuTitle, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(IMG_ELCL_QUICK_FIX_ENABLED)){

            public void run() {
                ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
                for (IMarker marker : allTheMarkers) {
                    IMarkerResolution[] iMarkerResolutionArray = IDE.getMarkerHelpRegistry().getResolutions(marker);
                    int n = iMarkerResolutionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarkerResolution r = iMarkerResolutionArray[n2];
                        resolutions.add(r);
                        ++n2;
                    }
                }
                MarkerResolutionSelectionDialog resolutionDialog = new MarkerResolutionSelectionDialog(QuickfixResolutionMenuManager.this._graphicalViewer.getControl().getShell(), resolutions.toArray(new IMarkerResolution[resolutions.size()]));
                resolutionDialog.open();
            }
        };
        ActionMenuManager subMenu = new ActionMenuManager(ID, (IAction)quikcfixMenuAction, true);
        subMenu.setParent((IContributionManager)manager);
        manager.insertBefore("formatMenu", (IContributionItem)subMenu);
        for (final IMarker marker : allMarkers) {
            IMarkerResolution[] resolutions;
            IMarkerResolution[] iMarkerResolutionArray = resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
            int n = resolutions.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerResolution2 resol2;
                final IMarkerResolution resol = iMarkerResolutionArray[n2];
                ImageDescriptorForImage desc = null;
                if (resol instanceof IMarkerResolution2 && (resol2 = (IMarkerResolution2)resol).getImage() != null) {
                    desc = new ImageDescriptorForImage(resol2.getImage());
                }
                if (desc == null) {
                    desc = new ImageDescriptorForImage(BpmnValidationDecoratorProvider.getProblemImage(marker.getAttribute("severity", 0), true));
                }
                Action resolve = new Action(resol.getLabel(), desc){

                    public void run() {
                        resol.run(marker);
                    }
                };
                subMenu.add((IAction)resolve);
                ++n2;
            }
        }
    }
}

