/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.stp.bpmn.diagram.ui.IMenuItemWithDisableSupport;
import org.eclipse.stp.bpmn.diagram.ui.TooltipManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopupMenuWithDisableSupport
extends PopupMenu {
    private TooltipManager _tooltip;
    private org.eclipse.swt.graphics.Point _locationInTheDisplay;
    private Control _parent;
    Menu _rootMenu;

    public PopupMenuWithDisableSupport(List aContent, ILabelProvider aLabelProvider) {
        super(aContent, aLabelProvider);
    }

    public PopupMenuWithDisableSupport(List<?> aContent, ILabelProvider aLabelProvider, Point location, EditPartViewer viewer) {
        super(aContent, aLabelProvider);
        this._locationInTheDisplay = viewer.getControl().toDisplay(location.x, location.y);
    }

    public boolean show(Control parent) {
        this._parent = parent;
        boolean res = super.show(parent);
        if (this._tooltip != null) {
            this._tooltip.dispose();
        }
        return res;
    }

    protected org.eclipse.swt.graphics.Point getLocationInTheDisplay() {
        return this._locationInTheDisplay;
    }

    protected void createMenuItems(Menu parentMenu, PopupMenu root, final List resultThusFar) {
        if (this._rootMenu == null) {
            this._rootMenu = parentMenu;
        }
        final PopupMenuWithDisableSupport rootMenu = (PopupMenuWithDisableSupport)root;
        Assert.isNotNull((Object)this.getContent());
        Assert.isNotNull((Object)this.getLabelProvider());
        if (this._locationInTheDisplay != null) {
            this._tooltip = new TooltipManager(rootMenu, this._parent);
        }
        for (Object contentObject : this.getContent()) {
            MenuItem menuItem;
            if (contentObject instanceof CascadingMenuWithDisableSupport) {
                PopupMenuWithDisableSupport subMenu = ((CascadingMenuWithDisableSupport)((Object)contentObject)).getSubMenu();
                contentObject = ((PopupMenu.CascadingMenu)contentObject).getParentMenuItem();
                if (subMenu.getContent().isEmpty()) {
                    menuItem = new MenuItem(parentMenu, 0);
                    menuItem.setEnabled(false);
                } else {
                    ArrayList thisResult = new ArrayList(resultThusFar);
                    thisResult.add(contentObject);
                    menuItem = new MenuItem(parentMenu, 64);
                    menuItem.setMenu(new Menu(parentMenu));
                    subMenu.createMenuItems(menuItem.getMenu(), rootMenu, thisResult);
                }
            } else {
                menuItem = new MenuItem(parentMenu, 0);
            }
            final Object fContentObject = contentObject;
            String text = this.getLabelProvider().getText(contentObject);
            menuItem.setText(text == null ? "" : text);
            menuItem.setImage(this.getLabelProvider().getImage(contentObject));
            if (contentObject instanceof IMenuItemWithDisableSupport) {
                menuItem.setEnabled(((IMenuItemWithDisableSupport)contentObject).isEnabled());
            }
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    resultThusFar.add(fContentObject);
                    rootMenu.setResult(resultThusFar);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    resultThusFar.add(fContentObject);
                    rootMenu.setResult(resultThusFar);
                }
            });
            if (this._tooltip == null) continue;
            menuItem.addListener(30, new Listener(){

                public void handleEvent(Event event) {
                    PopupMenuWithDisableSupport.this._tooltip.showTooltip(event, menuItem, (IMenuItemWithDisableSupport)fContentObject);
                }
            });
        }
    }

    public static class CascadingMenuWithDisableSupport
    extends PopupMenu.CascadingMenu {
        private PopupMenuWithDisableSupport subMenu;

        public CascadingMenuWithDisableSupport(Object aParentMenuItem, PopupMenuWithDisableSupport aSubMenu) {
            super(aParentMenuItem, (PopupMenu)aSubMenu);
            this.subMenu = aSubMenu;
        }

        public PopupMenuWithDisableSupport getSubMenu() {
            return this.subMenu;
        }
    }
}

