/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures.splitviewsupport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.CaretInfo;
import org.eclipse.gef.editparts.GuideLayer;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.stp.bpmn.figures.splitviewsupport.GuideLayerWithSplitters;

public class FreeFormViewPortWithSplitters
extends FreeformViewport {
    private List<Rectangle> _visibleAreas;
    private static final Point PRIVATE_POINT = new Point();

    protected void paintClientArea(Graphics graphics) {
        if (this._visibleAreas == null) {
            super.paintClientArea(graphics);
            return;
        }
        Rectangle oriBounds = new Rectangle(this.bounds);
        Point oriViewLocation = this.getViewLocation();
        int prevRight = 0;
        int sumDeltas = 0;
        for (Rectangle visibleArea : this._visibleAreas) {
            if (!oriBounds.intersects(visibleArea)) continue;
            Rectangle clientVisibleArea = new Rectangle(oriBounds).intersect(visibleArea);
            sumDeltas += clientVisibleArea.x - prevRight;
            prevRight = clientVisibleArea.x + clientVisibleArea.width;
            if (this.getChildren().isEmpty()) {
                return;
            }
            graphics.clipRect(clientVisibleArea.translate(-sumDeltas, 0));
            graphics.translate(this.getBounds().x + this.getInsets().left - 2 - oriViewLocation.x - sumDeltas, this.getBounds().y + this.getInsets().top - oriViewLocation.y);
            graphics.pushState();
            this.paintChildren(graphics);
            graphics.popState();
            graphics.restoreState();
        }
    }

    public void computeVisibleAreas() {
        FreeformLayeredPane content = (FreeformLayeredPane)this.getContents();
        GuideLayer guides = (GuideLayer)content.getLayer((Object)"Guide Layer");
        if (guides.getConstraints().size() < 2) {
            this._visibleAreas = null;
            return;
        }
        TreeSet<Integer> ordered = new TreeSet<Integer>();
        ordered.add(0);
        for (Map.Entry entry : guides.getConstraints().entrySet()) {
            Map.Entry e = entry;
            if (((Boolean)e.getValue()).booleanValue()) continue;
            IFigure guide = (IFigure)e.getKey();
            ordered.add(guide.getBounds().x);
        }
        if (ordered.size() < 2) {
            this._visibleAreas = null;
            return;
        }
        ArrayList<Rectangle> areas = new ArrayList<Rectangle>();
        Iterator it = ordered.iterator();
        int right = 0;
        while (it.hasNext()) {
            int left = (Integer)it.next();
            int n = right = it.hasNext() ? (Integer)it.next() : 300000;
            if (!it.hasNext()) {
                right = 300000;
            }
            Rectangle r = new Rectangle(left, 0, right - left, 300000);
            areas.add(r);
        }
        this._visibleAreas = areas;
    }

    public void setContents(IFigure figure) {
        FreeformLayeredPane pane = (FreeformLayeredPane)figure;
        pane.removeLayer((Object)"Guide Layer");
        GuideLayerWithSplitters guide = new GuideLayerWithSplitters(this);
        pane.add((IFigure)guide, (Object)"Guide Layer");
        super.setContents(figure);
    }

    public void translateFromParent(Translatable t) {
        if (this._visibleAreas == null) {
            super.translateFromParent(t);
        } else {
            this.translateFromParent(t, false);
        }
    }

    private void translateFromParent(Translatable t, boolean forMouse) {
        if (this._visibleAreas != null) {
            if (t instanceof Rectangle) {
                Rectangle r = (Rectangle)t;
                int right = r.x + r.width;
                right += this.getDxFromParent(right, forMouse);
                r.performTranslate(this.getDxFromParent(r.x, forMouse), 0);
                r.setSize(right - r.x, r.height);
            } else if (t instanceof Point) {
                Point p = (Point)t;
                p.performTranslate(this.getDxFromParent(p.x, forMouse), 0);
            } else if (t instanceof LineSeg) {
                LineSeg ls = (LineSeg)t;
                Point ori = ls.getOrigin();
                ori.performTranslate(this.getDxFromParent(ori.x, forMouse), 0);
                Point terminus = ls.getTerminus();
                terminus.x += this.getDxFromParent(terminus.x, forMouse);
                ls.setTerminus(terminus);
            } else if (t instanceof CaretInfo) {
                CaretInfo ci = (CaretInfo)t;
                ci.performTranslate(this.getDxFromParent(ci.getX(), forMouse), 0);
            }
        }
        super.translateFromParent(t);
    }

    protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
        PRIVATE_POINT.setLocation(x, y);
        this.translateFromParent((Translatable)PRIVATE_POINT, false);
        if (!this.getClientArea(Rectangle.SINGLETON).contains(PRIVATE_POINT)) {
            return null;
        }
        x = FreeFormViewPortWithSplitters.PRIVATE_POINT.x;
        y = FreeFormViewPortWithSplitters.PRIVATE_POINT.y;
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.isVisible() || (fig = fig.findFigureAt(x, y, search)) == null) continue;
            return fig;
        }
        return null;
    }

    protected IFigure findMouseEventTargetInDescendantsAt(int x, int y) {
        PRIVATE_POINT.setLocation(x, y);
        this.translateFromParent((Translatable)PRIVATE_POINT, true);
        if (!this.getClientArea(Rectangle.SINGLETON).contains(PRIVATE_POINT)) {
            return null;
        }
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.isVisible() || !fig.isEnabled() || !fig.containsPoint(FreeFormViewPortWithSplitters.PRIVATE_POINT.x, FreeFormViewPortWithSplitters.PRIVATE_POINT.y)) continue;
            fig = fig.findMouseEventTargetAt(FreeFormViewPortWithSplitters.PRIVATE_POINT.x, FreeFormViewPortWithSplitters.PRIVATE_POINT.y);
            return fig;
        }
        return null;
    }

    public void translateToParent(Translatable t) {
        super.translateToParent(t);
        if (this._visibleAreas != null) {
            if (t instanceof Rectangle) {
                Rectangle r = (Rectangle)t;
                r.x -= this.getDxFromParent(r.x, true);
                r.width -= this.getDxFromParent(r.x + r.width, false) - r.x;
            } else if (t instanceof Point) {
                Point p = (Point)t;
                p.x -= this.getDxFromParent(p.x, true);
            } else if (t instanceof LineSeg) {
                LineSeg ls = (LineSeg)t;
                Point ori = ls.getOrigin();
                ori.x -= this.getDxFromParent(ori.x, true);
                Point terminus = ls.getTerminus();
                terminus.x -= this.getDxFromParent(terminus.x, true);
                ls.setTerminus(terminus);
            } else if (t instanceof CaretInfo) {
                CaretInfo ci = (CaretInfo)t;
                ci.performTranslate(-this.getDxFromParent(ci.getX(), true), 0);
            }
        }
    }

    private static int getX(Translatable t) {
        if (t instanceof Rectangle) {
            return ((Rectangle)t).x;
        }
        if (t instanceof Point) {
            return ((Point)t).x;
        }
        if (t instanceof Point) {
            return ((Point)t).x;
        }
        if (t instanceof LineSeg) {
            return ((LineSeg)t).getOrigin().x;
        }
        if (t instanceof CaretInfo) {
            return ((CaretInfo)t).getX();
        }
        return -1;
    }

    private int getDxFromParent(int x, boolean forMouse) {
        if (this._visibleAreas != null && x >= 0) {
            int sum = 0;
            int prevRight = 0;
            boolean dosumonnext = false;
            for (Rectangle r : this._visibleAreas) {
                if (x < r.x) {
                    if (!dosumonnext) break;
                    sum += r.x - prevRight;
                    break;
                }
                sum += r.x - prevRight;
                prevRight = r.x + r.width;
                boolean bl = dosumonnext = forMouse && x > prevRight;
            }
            return sum;
        }
        return 0;
    }
}

