/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.tools.ActivityResizeTracker;
import org.eclipse.swt.SWT;

public class SubProcessResizeTracker
extends ActivityResizeTracker {
    public SubProcessResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
    }

    protected void updateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        Dimension resizeDelta = new Dimension(0, 0);
        SubProcessEditPart owner = (SubProcessEditPart)this.getOwner();
        PrecisionRectangle sourceRect = this.getSourceRectangle();
        SnapToHelper snapToHelper = this.getSnapToHelper();
        if (this.getCurrentInput().isShiftKeyDown() && owner != null) {
            request.setConstrainedResize(true);
            int origHeight = owner.getFigure().getBounds().height;
            int origWidth = owner.getFigure().getBounds().width;
            float ratio = 1.0f;
            if (origWidth != 0 && origHeight != 0) {
                ratio = (float)origHeight / (float)origWidth;
            }
            if (this.getResizeDirection() == 20) {
                if ((float)d.height > (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (this.getResizeDirection() == 9) {
                if ((float)d.height < (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (this.getResizeDirection() == 17) {
                if ((float)(-d.height) > (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            } else if (this.getResizeDirection() == 12) {
                if ((float)(-d.height) < (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            }
        } else {
            request.setConstrainedResize(false);
        }
        request.setCenteredResize(this.getCurrentInput().isModKeyDown(SWT.MOD1));
        SubProcessSubProcessBodyCompartmentEditPart bodyEditPart = (SubProcessSubProcessBodyCompartmentEditPart)owner.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5002));
        boolean isCollapsed = (Boolean)bodyEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed());
        double zoom = owner.getZoom();
        if ((this.getResizeDirection() & 1) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.height -= d.height;
            }
            moveDelta.y += d.height;
            resizeDelta.height -= d.height;
        }
        if ((this.getResizeDirection() & 4) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.y -= d.height;
                resizeDelta.height += d.height;
            }
            resizeDelta.height += d.height;
        }
        if ((this.getResizeDirection() & 8) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.width -= d.width;
            }
            moveDelta.x += d.width;
            resizeDelta.width -= d.width;
        }
        if ((this.getResizeDirection() & 0x10) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.x -= d.width;
                resizeDelta.width += d.width;
            }
            resizeDelta.width += d.width;
        }
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(resizeDelta);
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
        request.getExtendedData().clear();
        if (!this.getCurrentInput().isAltKeyDown() && snapToHelper != null) {
            PrecisionRectangle rect = sourceRect.getPreciseCopy();
            rect.translate(moveDelta);
            rect.resize(resizeDelta);
            PrecisionRectangle result = new PrecisionRectangle();
            snapToHelper.snapRectangle((Request)request, request.getResizeDirection(), rect, result);
            if (request.isCenteredResize()) {
                if (result.preciseX != 0.0) {
                    result.preciseWidth += -result.preciseX;
                } else if (result.preciseWidth != 0.0) {
                    result.preciseX = -result.preciseWidth;
                }
                if (result.preciseY != 0.0) {
                    result.preciseHeight += -result.preciseY;
                } else if (result.preciseHeight != 0.0) {
                    result.preciseY = -result.preciseHeight;
                }
                result.updateInts();
            }
            PrecisionPoint preciseMove = new PrecisionPoint(result.x + moveDelta.x, result.y + moveDelta.y);
            PrecisionDimension preciseResize = new PrecisionDimension((double)(result.width + resizeDelta.width), (double)(result.height + resizeDelta.height));
            request.setMoveDelta((Point)preciseMove);
            request.setSizeDelta((Dimension)preciseResize);
        }
    }
}

