/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.file;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.validation.BpmnValidationPlugin;
import org.eclipse.stp.bpmn.validation.IConstraintStatusEx;
import org.eclipse.stp.bpmn.validation.builder.BatchValidationBuilder;
import org.eclipse.stp.bpmn.validation.file.FileExistenceContraintQuickfixProvider;
import org.eclipse.stp.bpmn.validation.quickfixes.IBpmnFileExistenceConstraintCustomizer;
import org.eclipse.stp.bpmn.validation.quickfixes.internal.FileExistenceCustomizerHelper;

public class FileExistenceConstraint
extends AbstractModelConstraint {
    private static final NullProgressMonitor monitor = new NullProgressMonitor();
    public static String GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID = BatchValidationBuilder.GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID;

    public IStatus validate(IValidationContext ctx) {
        if (ctx.getTarget() instanceof EModelElement) {
            EModelElement elt = (EModelElement)ctx.getTarget();
            if (elt instanceof BpmnDiagram && elt.eResource() != null) {
                IFile file = WorkspaceSynchronizer.getFile((Resource)elt.eResource());
                BpmnValidationPlugin.getResourceImportersRegistry(file.getProject(), GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID, (IProgressMonitor)monitor).clearImports((IResource)file);
            }
            if (elt != null && elt.eResource() != null && elt.getEAnnotation("genericFile") != null) {
                EAnnotation ea = elt.getEAnnotation("genericFile");
                String str = (String)ea.getDetails().get((Object)"projectRelativePath");
                IFile file = WorkspaceSynchronizer.getFile((Resource)elt.eResource());
                if (file != null) {
                    IFolder targetFile = file.getProject().getFolder(str);
                    if (targetFile == null || !targetFile.exists()) {
                        targetFile = file.getProject().getFile(str);
                    }
                    BpmnValidationPlugin.getResourceImportersRegistry(file.getProject(), GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID, (IProgressMonitor)monitor).addImport((IResource)file, (IResource)targetFile);
                    if (targetFile == null || !targetFile.exists()) {
                        IStatus st = ctx.createFailureStatus((Object[])new String[]{targetFile.getProjectRelativePath().toString()});
                        IConstraintStatusEx consSt = BpmnValidationPlugin.asConstraintStatusEx(st, FileExistenceContraintQuickfixProvider.ID);
                        if (consSt != null) {
                            boolean setupTheStandardQuikcfix = true;
                            List<IBpmnFileExistenceConstraintCustomizer> custs = FileExistenceCustomizerHelper.getFileExistenceCustomizers();
                            if (custs != null) {
                                for (IBpmnFileExistenceConstraintCustomizer cu : custs) {
                                    if (!cu.validates(elt, (IResource)targetFile, consSt)) continue;
                                    setupTheStandardQuikcfix = false;
                                    break;
                                }
                            }
                            if (setupTheStandardQuikcfix) {
                                consSt.addMarkerAttribute(FileExistenceContraintQuickfixProvider.MISSING_FILE_PROJ_RELATIVE_PATH_ATTRIBUTE, targetFile.getProjectRelativePath().toString());
                            }
                            return consSt;
                        }
                        return st;
                    }
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

