/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.Identifiable;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditor;
import org.eclipse.stp.bpmn.validation.providers.HeadlessBpmnValidationProvider;
import org.eclipse.stp.bpmn.validation.quickfixes.internal.BpmnQuickfixes;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public abstract class AbstractBpmnMarkerResolution
extends WorkbenchMarkerResolution {
    public abstract String getDescription();

    public abstract Image getImage();

    public abstract String getLabel();

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        int i = 0;
        while (i < markers.length) {
            monitor.subTask(markers[i].getAttribute("message", ""));
            this.run(markers[i], monitor);
            ++i;
        }
    }

    public void run(IMarker marker) {
        this.run(marker, (IProgressMonitor)new NullProgressMonitor());
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return BpmnQuickfixes.findOtherMarkers(markers, (IMarkerResolution)this);
    }

    protected String getBpmnId(IMarker marker) {
        return marker.getAttribute("bpmnId", null);
    }

    protected String getElementId(IMarker marker) {
        return marker.getAttribute(HeadlessBpmnValidationProvider.ELEMENT_ID, null);
    }

    public abstract void run(IMarker var1, IProgressMonitor var2);

    public BpmnDiagramEditor openEditor(IMarker marker, IProgressMonitor monitor) throws PartInitException {
        if (marker.getResource() == null || marker.getResource().getType() != 1) {
            return null;
        }
        String fileExt = marker.getResource().getFileExtension();
        if (fileExt == null || !fileExt.endsWith("_diagram")) {
            return null;
        }
        IEditorPart ep = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)marker.getResource()));
        if (ep == null || !(ep instanceof BpmnDiagramEditor)) {
            return null;
        }
        BpmnDiagramEditor ed = (BpmnDiagramEditor)ep;
        return ed;
    }

    protected Identifiable navigateToBpmnShape(BpmnDiagramEditor ed, IMarker marker, IProgressMonitor monitor) throws PartInitException {
        Object selected;
        ISelection sel;
        if (ed.navigateTo(this.getElementId(marker), this.getBpmnId(marker)) && (sel = ed.getEditorSite().getSelectionProvider().getSelection()) != null && sel instanceof IStructuredSelection && !sel.isEmpty() && (selected = ((IStructuredSelection)sel).getFirstElement()) instanceof IAdaptable) {
            return (Identifiable)((IAdaptable)selected).getAdapter(Identifiable.class);
        }
        return null;
    }
}

