/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.base;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.stp.common.validator.core.IMessage;
import org.eclipse.stp.common.validator.core.IReporter;

public class SimpleFileReporter
implements IReporter {
    private int index = 0;
    private int errorCount = 0;
    private int warnCount = 0;
    private FileOutputStream outputFile = null;

    public SimpleFileReporter(String reportFile) throws FileNotFoundException {
        this.outputFile = new FileOutputStream(reportFile);
    }

    public int getErrorsCount() {
        return this.errorCount;
    }

    public int getWarningsCount() {
        return this.warnCount;
    }

    public void addMessage(IMessage message) {
        try {
            MessageFormat msgFmt = new MessageFormat("#{0} {4} {1} at line {2}: {3}\n");
            String msgType = "Unknown";
            if (1 == message.getSeverity()) {
                ++this.errorCount;
                msgType = "ERROR";
            } else if (2 == message.getSeverity()) {
                ++this.warnCount;
                msgType = "WARNING";
            }
            ++this.index;
            String sourceIDName = "";
            QName sourceID = (QName)message.getAttribute("source");
            if (sourceID != null) {
                sourceIDName = sourceID.toString();
            }
            String formattedMsg = msgFmt.format(new Object[]{this.index, msgType, message.getLineNumber(), message.getMessageText(), sourceIDName});
            this.outputFile.write(formattedMsg.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
    }

    public List getWarningList() {
        return null;
    }

    public List getErrorList() {
        return null;
    }

    public List getMessages() {
        return null;
    }

    public boolean isCanceled() {
        return false;
    }

    public void removeAllMessages() {
        this.errorCount = 0;
        this.warnCount = 0;
    }
}

