/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.base;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.eclipse.stp.common.validator.core.IMessage;
import org.eclipse.stp.common.validator.core.MessageTypeEnum;

public class ValidationMessage
implements IMessage {
    private static final Logger LOG = Logger.getLogger(ValidationMessage.class);
    private int nSeverity = 1;
    private int nOffset = -1;
    private int nLength = -1;
    private int nLineNo = -1;
    private String nBundleName = null;
    private HashMap nAttributes = new HashMap();
    private MessageTypeEnum hType = null;
    private String[] sFmtParams = null;

    public ValidationMessage(String bundleName, int severity, MessageTypeEnum msgID, String[] params) {
        this.nBundleName = bundleName;
        this.nSeverity = severity;
        this.hType = msgID;
        this.sFmtParams = params;
    }

    public String getBundleName() {
        return this.nBundleName;
    }

    public Object getAttribute(String attributeName) {
        return attributeName != null ? this.nAttributes.get(attributeName) : attributeName;
    }

    public void setAttribute(String attributeName, Object object) {
        if (attributeName != null) {
            this.nAttributes.put(attributeName, object);
        }
    }

    public Map getAttributes() {
        return this.nAttributes;
    }

    public Object[] getParams() {
        return this.sFmtParams;
    }

    public int getLength() {
        return this.nLength;
    }

    public int getLineNumber() {
        return this.nLineNo;
    }

    public String getMessageText() {
        return this.getMessageText(null, Locale.getDefault());
    }

    public String getMessageText(Locale locale) {
        return this.getMessageText(null, locale);
    }

    public String getMessageText(ClassLoader classLoader) {
        return this.getMessageText(classLoader, Locale.getDefault());
    }

    public ResourceBundle getBundle(Locale locale, ClassLoader classLoader) {
        ResourceBundle bundle = null;
        try {
            bundle = classLoader == null ? ResourceBundle.getBundle(this.getBundleName(), locale) : ResourceBundle.getBundle(this.getBundleName(), locale, classLoader);
        }
        catch (MissingResourceException e) {
            try {
                bundle = ResourceBundle.getBundle(this.getBundleName(), locale, this.getClass().getClassLoader());
            }
            catch (MissingResourceException e2) {
                LOG.error((Object)("The resource bundle [" + this.getBundleName() + "] is missing: " + e2.getMessage()), (Throwable)e);
            }
        }
        return bundle;
    }

    public String getMessageText(ClassLoader classLoader, Locale locale) {
        String message = "";
        ResourceBundle bundle = null;
        if (locale != null) {
            bundle = this.getBundle(locale, classLoader);
        }
        if (bundle != null) {
            try {
                String msgID = this.getMessageType().getID();
                if (msgID != null) {
                    message = bundle.getString(this.getMessageType().getID());
                    if (this.getParams() != null) {
                        message = MessageFormat.format(message, this.getParams());
                    }
                } else {
                    LOG.error((Object)"Lookup failed. The message has no identifier!");
                }
            }
            catch (MissingResourceException e) {
                LOG.error((Object)("The resource [" + this.getMessageType().getID() + "] is missing in bundle [" + this.getBundleName() + "] : " + e.getMessage()), (Throwable)e);
            }
        }
        return message;
    }

    public MessageTypeEnum getMessageType() {
        return this.hType;
    }

    public int getOffset() {
        return this.nOffset;
    }

    public int getSeverity() {
        return this.nSeverity;
    }

    public void setLineNo(int lineNo) {
        this.nLineNo = lineNo;
    }

    public String toString() {
        return this.getMessageText();
    }
}

