/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core;

import java.util.HashMap;
import java.util.Map;

public class ValidationObjectTypeEnum {
    public static final String SDX_NAME = "SDX";
    public static final String SPDX_NAME = "SPDX";
    public static final String WSDL_NAME = "WSDL";
    public static final String PPDX_NAME = "PPDX";
    public static final String OPX_NAME = "OPDX";
    public static final String XSD_NAME = "XSD";
    public static final String UNKNOWN_NAME = "UNKNOWN";
    public static final ValidationObjectTypeEnum SDX_TYPE = new ValidationObjectTypeEnum("SDX");
    public static final ValidationObjectTypeEnum SPDX_TYPE = new ValidationObjectTypeEnum("SPDX");
    public static final ValidationObjectTypeEnum WSDL_TYPE = new ValidationObjectTypeEnum("WSDL");
    public static final ValidationObjectTypeEnum PPDX_TYPE = new ValidationObjectTypeEnum("PPDX");
    public static final ValidationObjectTypeEnum OPX_TYPE = new ValidationObjectTypeEnum("OPDX");
    public static final ValidationObjectTypeEnum XSD_TYPE = new ValidationObjectTypeEnum("XSD");
    public static final ValidationObjectTypeEnum UNKNOWN_TYPE = new ValidationObjectTypeEnum("UNKNOWN");
    private static Map mapping = new HashMap();
    private final String mName;

    static {
        mapping.put(SDX_NAME, SDX_TYPE);
        mapping.put(SPDX_NAME, SPDX_TYPE);
        mapping.put(WSDL_NAME, WSDL_TYPE);
        mapping.put(PPDX_NAME, PPDX_TYPE);
        mapping.put(OPX_NAME, OPX_TYPE);
        mapping.put(XSD_NAME, XSD_TYPE);
        mapping.put(UNKNOWN_NAME, UNKNOWN_TYPE);
    }

    private ValidationObjectTypeEnum(String pName) {
        this.mName = pName;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return "";
    }

    public static ValidationObjectTypeEnum lookup(String typeString) {
        ValidationObjectTypeEnum validationObjectTypeEnum = (ValidationObjectTypeEnum)mapping.get(typeString.toUpperCase());
        if (validationObjectTypeEnum == null) {
            validationObjectTypeEnum = UNKNOWN_TYPE;
        }
        return validationObjectTypeEnum;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ValidationObjectTypeEnum) {
            ValidationObjectTypeEnum other = (ValidationObjectTypeEnum)obj;
            return this.mName.equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return "ValidationObjectTypeEnum {'" + this.mName + "'}";
    }
}

