/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.stp.common.validator.core.impl.SchemaDocumentFactoryImpl;
import org.eclipse.stp.common.validator.core.impl.service.InlineSchemaHelper;
import org.eclipse.stp.common.validator.exception.SOPValidationException;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;

public class SchemaTypeValidator
implements DOMErrorHandler {
    private static final Logger LOG = Logger.getLogger(SchemaTypeValidator.class);
    private static SchemaTypeValidator instance = null;
    private static XSLoader xsLoader = null;
    private Map grammars = new HashMap();

    static {
        xsLoader = InlineSchemaHelper.getXSLoaderInstance();
    }

    private SchemaTypeValidator() {
    }

    public static SchemaTypeValidator getInstance() {
        if (instance == null) {
            instance = new SchemaTypeValidator();
        }
        return instance;
    }

    public boolean handleError(DOMError err) {
        LOG.error((Object)("The DOM Error catched: " + err.getMessage()));
        return true;
    }

    private XSModel getGrammar(String schemaURI) throws SOPValidationException {
        DOMConfiguration config = xsLoader.getConfig();
        config.setParameter("error-handler", this);
        config.setParameter("validate", Boolean.TRUE);
        XSModel grammar = null;
        grammar = (XSModel)this.grammars.get(schemaURI);
        if (grammar == null) {
            URL urlSchema = SchemaDocumentFactoryImpl.getInstance().lookupCatalog(schemaURI);
            if (urlSchema != null) {
                grammar = xsLoader.loadURI(urlSchema.toString());
                this.grammars.put(schemaURI, grammar);
            } else {
                throw new SOPValidationException("Unable to resolve the data type schema in catalog: [" + schemaURI + "]");
            }
        }
        return grammar;
    }

    private ValidationContext getValidationContext() {
        ValidationState validationState = null;
        validationState = new ValidationState();
        return validationState;
    }

    public String validateSimpleType(String schemaURI, String simpleTypeName, String inputValue) throws SOPValidationException {
        String errMsg = null;
        XSTypeDefinition typeDef = null;
        if (schemaURI.compareTo("http://www.w3.org/2001/XMLSchema") == 0) {
            XSModel emptyGrammar = this.getGrammar("EMPTY_SCHEMA");
            if (emptyGrammar != null) {
                typeDef = emptyGrammar.getTypeDefinition(simpleTypeName, "http://www.w3.org/2001/XMLSchema");
            }
        } else {
            XSModel grammar = this.getGrammar(schemaURI);
            if (grammar == null) {
                throw new SOPValidationException("Unable to retrieve XML Schema object for [" + schemaURI + "]");
            }
            typeDef = grammar.getTypeDefinition(simpleTypeName, schemaURI);
        }
        if (typeDef != null) {
            try {
                if (typeDef.getTypeCategory() != 16) {
                    throw new SOPValidationException("The [" + simpleTypeName + "] is not a simple type");
                }
                XSSimpleType simpleTypeDef = (XSSimpleType)typeDef;
                LOG.debug((Object)("Simple Type definition [ " + simpleTypeDef + " ]"));
                ValidatedInfo validatedInfo = new ValidatedInfo();
                ValidationContext validationContext = this.getValidationContext();
                simpleTypeDef.validate(inputValue, validationContext, validatedInfo);
                errMsg = null;
            }
            catch (InvalidDatatypeValueException e) {
                errMsg = e.getMessage();
                LOG.error((Object)("Invalid datatype value: " + e.toString()));
            }
        } else {
            throw new SOPValidationException("Simple Type definition [" + schemaURI + "][" + simpleTypeName + "] cannot be found");
        }
        return errMsg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String validateAttrib(String schemaURI, String attribName, String inputValue) throws SOPValidationException {
        String errMsg = null;
        XSModel grammar = this.getGrammar(schemaURI);
        if (grammar == null) {
            throw new SOPValidationException("Unable to retrieve XML Schema object for [" + schemaURI + "]");
        }
        XSAttributeDeclaration attribDecl = grammar.getAttributeDeclaration(attribName, schemaURI);
        if (attribDecl == null) throw new SOPValidationException("Attribute definition [" + schemaURI + "][" + attribName + "] cannot be found");
        XSSimpleTypeDefinition typeDef = attribDecl.getTypeDefinition();
        if (typeDef.getTypeCategory() != 16) throw new SOPValidationException("Attribute type definition [" + schemaURI + "][" + attribName + "] is not a simple type");
        try {
            XSSimpleType simpleTypeDef = (XSSimpleType)typeDef;
            ValidatedInfo validatedInfo = new ValidatedInfo();
            ValidationContext validationContext = this.getValidationContext();
            simpleTypeDef.validate(inputValue, validationContext, validatedInfo);
            return errMsg;
        }
        catch (InvalidDatatypeValueException e) {
            errMsg = e.getMessage();
            LOG.error((Object)("Invalid datatype value: " + e.toString()));
        }
        return errMsg;
    }
}

