/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core.impl;

import org.eclipse.stp.common.validator.core.IValidator;
import org.eclipse.stp.common.validator.core.ValidatorFactory;
import org.eclipse.stp.common.validator.core.ValidatorTypeEnum;
import org.eclipse.stp.common.validator.core.impl.service.CompatibilityValidator;
import org.eclipse.stp.common.validator.core.impl.service.ConsistencyValidator;
import org.eclipse.stp.common.validator.core.impl.service.GenericValidator;
import org.eclipse.stp.common.validator.core.impl.service.MultiSchemaValidator;
import org.eclipse.stp.common.validator.exception.ConfigurationException;

public class ValidatorFactoryDefImpl
implements ValidatorFactory {
    private static ValidatorFactory validatorFactory;

    private ValidatorFactoryDefImpl() {
    }

    public static ValidatorFactory getInstance() {
        if (validatorFactory == null) {
            validatorFactory = new ValidatorFactoryDefImpl();
        }
        return validatorFactory;
    }

    public IValidator getValidator(ValidatorTypeEnum pType) throws ConfigurationException {
        if (pType.getName().compareTo(ValidatorTypeEnum.GENERIC_VALIDATOR.getName()) == 0) {
            GenericValidator val = new GenericValidator();
            return val;
        }
        if (pType.getName().compareTo(ValidatorTypeEnum.MULTISCHEMA_VALIDATOR.getName()) == 0) {
            MultiSchemaValidator msvVal = new MultiSchemaValidator();
            return msvVal;
        }
        if (pType.getName().compareTo(ValidatorTypeEnum.COMPATIBILITY_VALIDATOR.getName()) == 0) {
            CompatibilityValidator compVal = new CompatibilityValidator();
            return compVal;
        }
        if (pType.getName().compareTo(ValidatorTypeEnum.CONSISTENCY_VALIDATOR.getName()) == 0) {
            ConsistencyValidator consistencyVal = new ConsistencyValidator();
            return consistencyVal;
        }
        throw new ConfigurationException("Unknown validator type requested");
    }
}

