/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core.impl.service;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.eclipse.stp.common.validator.core.IReporter;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.core.IValidationObject;
import org.eclipse.stp.common.validator.core.IValidator;
import org.eclipse.stp.common.validator.core.MessageTypeEnum;
import org.eclipse.stp.common.validator.core.ValidationObjectID;
import org.eclipse.stp.common.validator.core.ValidationObjectTypeEnum;
import org.eclipse.stp.common.validator.core.impl.service.MessageHelper;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;
import org.eclipse.stp.common.validator.exception.SOPValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConsistencyValidator
implements IValidator {
    private static final Logger LOG = Logger.getLogger(ConsistencyValidator.class);
    private static final String PPDX_ATTRIB_NAME_SERVICE = "service";
    private static final String PPDX_ATTRIB_NAME_SERVICE_LOCATION = "serviceLocation";
    private static final String PPDX_ATTRIB_OPERATION_NAME = "name";
    private static final String PPDX_ELEMENT_NAME_DEFAULT_OPERATION = "DefaultOperation";
    private static final String PPDX_ELEMENT_NAME_OPERATION = "Operation";
    private static final String PPDX_ELEMENT_NAME_POLICY_REFERENCE = "PolicyReference";
    private static final String PPDX_ELEMENT_NAME_UNUSED = "unused";
    private static final String PPDX_ATTRIB_NAME_URI = "URI";
    private static final String PPDX_ATTRIB_NAME_LOCATION = "location";
    private static final String OPDX_ELEMENT_NAME_JMS_TRANSPORT = "JmsTransport";
    private static final String OPDX_ELEMENT_NAME_SBB2_TRANSPORT = "Sbb2Transport";
    private MessageHelper messageHelper = new MessageHelper();

    public Definition openWSDLDefinition(Document inputDoc) throws SOPValidationException {
        Definition spdxDefinition = null;
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", true);
            reader.setFeature("javax.wsdl.importDocuments", false);
            spdxDefinition = reader.readWSDL(null, inputDoc);
        }
        catch (WSDLException e) {
            String errMsg = "Unable to reload the WSDL Definition";
            LOG.error((Object)(String.valueOf(errMsg) + " : " + e.getMessage()), (Throwable)e);
            throw new SOPValidationException(errMsg, (Exception)((Object)e));
        }
        return spdxDefinition;
    }

    public void checkServiceConsistency(Definition spdxDefinition, Definition sdxDefinition, IReporter pReporter) {
        Map bindings = spdxDefinition.getBindings();
        for (Binding objBinding : bindings.values()) {
            PortType portType = objBinding.getPortType();
            LOG.debug((Object)("\t" + objBinding.getQName() + "]"));
            if (objBinding.getPortType() != null) {
                LOG.debug((Object)("The port type is referenced: [" + objBinding.getPortType().getQName() + "]"));
                PortType refPortType = sdxDefinition.getPortType(portType.getQName());
                if (refPortType == null) {
                    LOG.debug((Object)"The port type isn't located in the referenced document");
                    this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_BINDING_WRONG_PORTTYPE_REFERENCE, pReporter, new String[]{objBinding.getQName().getLocalPart(), portType.getQName().getNamespaceURI(), portType.getQName().getLocalPart()}, null);
                    continue;
                }
                LOG.debug((Object)"The referenced port type located");
                List bindOpList = objBinding.getBindingOperations();
                for (BindingOperation bindOp : bindOpList) {
                    String opName = bindOp.getName();
                    Operation opObj = refPortType.getOperation(opName, null, null);
                    if (opObj == null) {
                        this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_BINDING_WRONG_OPERATION_REFERENCE, pReporter, new String[]{objBinding.getQName().getLocalPart(), opName}, null);
                        continue;
                    }
                    if (opObj.getInput() != null && bindOp.getBindingInput() == null) {
                        this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_BINDING_WRONG_OPERATION_ENDPOINT_MISSING, pReporter, new String[]{objBinding.getQName().getLocalPart(), opName, "input"}, null);
                    }
                    if (opObj.getOutput() != null && bindOp.getBindingOutput() == null) {
                        this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_BINDING_WRONG_OPERATION_ENDPOINT_MISSING, pReporter, new String[]{objBinding.getQName().getLocalPart(), opName, "output"}, null);
                    }
                    Map faultsMap = opObj.getFaults();
                    for (Fault faultObj : faultsMap.values()) {
                        if (bindOp.getBindingFault(faultObj.getName()) != null) continue;
                        this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_BINDING_WRONG_OPERATION_FAULT_MISSING, pReporter, new String[]{objBinding.getQName().getLocalPart(), opName, faultObj.getName()}, null);
                    }
                    if (opObj.getInput() == null && bindOp.getBindingInput() != null) {
                        this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_BINDING_WRONG_OPERATION_ENDPOINT_EXTRA, pReporter, new String[]{objBinding.getQName().getLocalPart(), opName, "input"}, null);
                    }
                    if (opObj.getOutput() == null && bindOp.getBindingOutput() != null) {
                        this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_BINDING_WRONG_OPERATION_ENDPOINT_EXTRA, pReporter, new String[]{objBinding.getQName().getLocalPart(), opName, "output"}, null);
                    }
                    faultsMap = bindOp.getBindingFaults();
                    for (Fault faultObj : faultsMap.values()) {
                        if (opObj.getFault(faultObj.getName()) != null) continue;
                        this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_BINDING_WRONG_OPERATION_FAULT_EXTRA, pReporter, new String[]{objBinding.getQName().getLocalPart(), opName, faultObj.getName()}, null);
                    }
                }
                continue;
            }
            this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_BINDING_WRONG_PORTTYPE_REFERENCE, pReporter, new String[]{objBinding.getQName().getLocalPart(), "", ""}, null);
        }
    }

    private Definition getRefServiceDescription(Definition spdxDefinition, IValidationContext context, IReporter reporter) throws SOPValidationException {
        Definition sdxDefinition = null;
        IValidationContext sdxContext = null;
        Map bindings = spdxDefinition.getBindings();
        Iterator bindMapIt = bindings.values().iterator();
        while (bindMapIt.hasNext() && sdxDefinition == null) {
            Binding objBinding = (Binding)bindMapIt.next();
            PortType portType = objBinding.getPortType();
            LOG.debug((Object)("Scanning [" + objBinding.getQName() + "]"));
            LOG.debug((Object)("The port type is referenced: [" + objBinding.getPortType().getQName() + "]"));
            String nsURI = objBinding.getPortType().getQName().getNamespaceURI();
            List uriImports = spdxDefinition.getImports(objBinding.getPortType().getQName().getNamespaceURI());
            if (uriImports != null && uriImports.size() > 0) {
                LOG.warn((Object)("The import directive for [" + nsURI + "] located and external document will be requested"));
                Import objImport = (Import)uriImports.get(0);
                URI locationURI = null;
                try {
                    if (objImport.getLocationURI() != null) {
                        String location = objImport.getLocationURI().replace('\\', '/');
                        locationURI = new URI(null, null, location, null);
                    } else {
                        LOG.warn((Object)"The import location is empty");
                    }
                }
                catch (URISyntaxException e) {
                    LOG.warn((Object)("Unable to construct URI on import location : " + e.getMessage()), (Throwable)e);
                }
                QName serviceQName = portType.getQName();
                ValidationObjectID importID = new ValidationObjectID(objImport.getNamespaceURI(), serviceQName, locationURI, ValidationObjectTypeEnum.SDX_TYPE);
                sdxContext = context.getNestedValidationContext(importID);
                LOG.debug((Object)("The nested context for Service Description obtained [" + sdxContext + "]"));
                if (sdxContext != null) {
                    Document sdxDocument = null;
                    try {
                        sdxDocument = sdxContext.getObject().getInput();
                        sdxDefinition = this.openWSDLDefinition(sdxDocument);
                    }
                    catch (ContextInitializationException e) {
                        LOG.error((Object)"Unable to obtain the referenced Service Description document", (Throwable)e);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Unable to obtain the referenced Service Description document", (Throwable)e);
                    }
                }
                if (sdxDefinition != null) {
                    LOG.debug((Object)"The referenced Service Description reloaded");
                    continue;
                }
                this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_SPDX_WRONG_PORTTYPE_REFERENCE, reporter, new String[]{serviceQName.getNamespaceURI(), serviceQName.getLocalPart()}, null);
                continue;
            }
            LOG.warn((Object)("The is no import directive for [" + nsURI + "]"));
        }
        return sdxDefinition;
    }

    private void checkParticipantPolicyConsistency(IValidationContext pValidationContext, Element rootElement, String serviceIdentifier, Definition sdxDefinition, IReporter reporter) {
        QName serviceQName = QName.valueOf(serviceIdentifier);
        String serviceURI = serviceQName.getNamespaceURI();
        String servicePortType = serviceQName.getLocalPart();
        if (serviceURI != null && servicePortType != null && serviceURI.length() != 0 && servicePortType.length() != 0) {
            QName qnamePortType = new QName(serviceURI, servicePortType);
            LOG.debug((Object)("Looking for [" + qnamePortType + "] Port Type in the Service Description"));
            PortType portType = sdxDefinition.getPortType(qnamePortType);
            if (portType == null) {
                this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_PPDX_WRONG_PORTTYPE_REFERENCE, reporter, new String[]{qnamePortType.getNamespaceURI(), qnamePortType.getLocalPart()}, null);
                return;
            }
            List portTypeOps = portType.getOperations();
            ArrayList<String> portTypeOperations = new ArrayList<String>(portTypeOps.size());
            for (Object opObj : portTypeOps) {
                portTypeOperations.add(((Operation)opObj).getName());
            }
            ArrayList<String> declaredOperations = new ArrayList<String>();
            NodeList operationList = rootElement.getElementsByTagNameNS("http://types.sopware.org/qos/ParticipantPolicy/1.1", PPDX_ELEMENT_NAME_OPERATION);
            int i = 0;
            while (i < operationList.getLength()) {
                Element opNode = (Element)operationList.item(i);
                String opName = opNode.getAttribute(PPDX_ATTRIB_OPERATION_NAME);
                NodeList referenceList = opNode.getElementsByTagNameNS("*", PPDX_ELEMENT_NAME_POLICY_REFERENCE);
                if (referenceList.getLength() > 0) {
                    Element reference = (Element)referenceList.item(0);
                    String opdxUri = reference.getAttribute(PPDX_ATTRIB_NAME_URI);
                    URI locationURI = null;
                    try {
                        String location = reference.getAttribute(PPDX_ATTRIB_NAME_LOCATION).replace('\\', '/');
                        locationURI = new URI(null, null, location, null);
                    }
                    catch (URISyntaxException e) {
                        LOG.info((Object)("Reference to OPDX with URI: " + opdxUri + " via location in PPDX document is incorrect" + " (or does not present at all)"));
                    }
                    ValidationObjectID opdxID = new ValidationObjectID(opdxUri, null, locationURI, ValidationObjectTypeEnum.OPX_TYPE);
                    IValidationContext opdxContext = pValidationContext.getNestedValidationContext(opdxID);
                    if (opdxContext == null) {
                        LOG.error((Object)("Unable to load the OPDX document [URI: " + opdxUri + ", location: " + locationURI + "] for validation"));
                        this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_PPDX_UNRESOLVABLE_OPDX_REFERENCE, reporter, new String[]{opdxUri, locationURI.toString()}, null);
                    } else {
                        try {
                            Operation noteOp;
                            Document inputDoc = opdxContext.getObject().getInput();
                            String opdxName = inputDoc.getDocumentElement().getAttribute("Name");
                            if (!opdxUri.equals(opdxName)) {
                                this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_PPDX_INVALID_OPDX_REFERENCE, reporter, new String[]{opName, opdxUri, opdxName, locationURI.toString()}, null);
                            }
                            if ((noteOp = portType.getOperation(opName, null, null)) != null && noteOp.getStyle().equals(OperationType.NOTIFICATION)) {
                                LOG.debug((Object)("Checking [" + opName + "] notification operation for non HTTP based transport binding"));
                                NodeList msgList = inputDoc.getDocumentElement().getElementsByTagNameNS("*", OPDX_ELEMENT_NAME_JMS_TRANSPORT);
                                if (msgList.getLength() < 1 && (msgList = inputDoc.getDocumentElement().getElementsByTagNameNS("*", OPDX_ELEMENT_NAME_SBB2_TRANSPORT)).getLength() < 1) {
                                    this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_PPDX_NOT_JMS_OR_SBB2_NOTIFICATION_OPERATION, reporter, new String[]{opName}, null);
                                }
                            }
                        }
                        catch (ContextInitializationException e) {
                            String message = "Unable to load the OPDX document [URI: " + opdxContext.getObject().getID().getURI() + "]: " + e.getMessage();
                            LOG.error((Object)message, (Throwable)e);
                            this.messageHelper.reportError(MessageTypeEnum.OTHER_ERROR, reporter, new String[]{message}, e);
                        }
                    }
                }
                LOG.debug((Object)("Checking [" + opName + "] operation for duplicating"));
                if (declaredOperations.contains(opName)) {
                    this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_PPDX_DUPLICATE_OPERATION, reporter, new String[]{opName}, null);
                }
                declaredOperations.add(opName);
                LOG.debug((Object)("Checking [" + opName + "] operation declared in Participant Policy"));
                if (!portTypeOperations.contains(opName)) {
                    this.messageHelper.reportWarning(MessageTypeEnum.CONSISTENCY_PPDX_GHOST_OPERATION, reporter, new String[]{opName}, null);
                }
                ++i;
            }
            boolean hasDefaultOperation = false;
            NodeList defOperationList = rootElement.getElementsByTagNameNS("http://types.sopware.org/qos/ParticipantPolicy/1.1", PPDX_ELEMENT_NAME_DEFAULT_OPERATION);
            if (defOperationList.getLength() == 0) {
                hasDefaultOperation = false;
                LOG.debug((Object)"The Participant Policy has no DefaultOperation declared");
            } else {
                hasDefaultOperation = true;
                LOG.debug((Object)"The Participant Policy has DefaultOperation");
            }
            for (String opName : portTypeOperations) {
                LOG.debug((Object)("Checking [" + opName + "] operation declared in Service Description"));
                if (!declaredOperations.contains(opName)) {
                    if (hasDefaultOperation) {
                        LOG.debug((Object)("Operation [" + opName + "] is not declared explicitly, but Participant Policy declares the DefaultOperation"));
                        continue;
                    }
                    this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_PPDX_MISSING_OPERATION, reporter, new String[]{opName}, null);
                    continue;
                }
                LOG.debug((Object)("Matching for [" + opName + "] operation approved"));
            }
        }
    }

    public void validate(IValidationContext pValidationContext, IReporter pReporter) throws SOPValidationException {
        LOG.debug((Object)"The consistency validation invoked");
        IValidationObject valObj = pValidationContext.getObject();
        LOG.debug((Object)("The object type: " + valObj.getID().getType().getName()));
        this.messageHelper.setCurrentObject(valObj.getID().getQName());
        Document inputDoc = null;
        try {
            inputDoc = valObj.getInput();
        }
        catch (ContextInitializationException e) {
            LOG.error((Object)("Unable to load the object document for validation: " + e.getMessage()), (Throwable)e);
            throw new SOPValidationException("Unable to load the object document for validation", e);
        }
        ValidationObjectTypeEnum docType = valObj.getID().getType();
        Definition sdxDefinition = null;
        if (docType.equals(ValidationObjectTypeEnum.SPDX_TYPE)) {
            Definition spdxDefinition = this.openWSDLDefinition(inputDoc);
            sdxDefinition = this.getRefServiceDescription(spdxDefinition, pValidationContext, pReporter);
            if (sdxDefinition != null) {
                this.checkServiceConsistency(spdxDefinition, sdxDefinition, pReporter);
            }
        } else if (docType.equals(ValidationObjectTypeEnum.PPDX_TYPE)) {
            Element rootElement = inputDoc.getDocumentElement();
            QName serviceQName = null;
            String service = rootElement.getAttribute(PPDX_ATTRIB_NAME_SERVICE);
            String serviceLocation = rootElement.getAttribute(PPDX_ATTRIB_NAME_SERVICE_LOCATION);
            LOG.debug((Object)("service = [" + service + "]"));
            LOG.debug((Object)("service location = [" + serviceLocation + "]"));
            serviceLocation = serviceLocation.replace('\\', '/');
            LOG.debug((Object)("normalized service location = [" + serviceLocation + "]"));
            URI locationURI = null;
            IValidationContext sdxContext = null;
            Document sdxInputDoc = null;
            if (service != null && service.length() != 0) {
                try {
                    if (serviceLocation != null) {
                        locationURI = new URI(null, null, serviceLocation, null);
                    } else {
                        LOG.warn((Object)"The service location attribute is absent");
                    }
                }
                catch (URISyntaxException e) {
                    LOG.warn((Object)("Unable to construct URI on service location : " + e.getMessage()), (Throwable)e);
                }
                serviceQName = QName.valueOf(service);
            } else {
                Object objProperty = pValidationContext.getProperty("serviceQName");
                if (objProperty != null && objProperty instanceof QName) {
                    serviceQName = (QName)objProperty;
                }
                if (serviceQName != null) {
                    LOG.debug((Object)"The service is not explicitly declared in Participant Policy document, but is specified in the context");
                    service = serviceQName.toString();
                } else {
                    LOG.debug((Object)"The service is neither declared in Participant Policy document, nor specified in the context");
                }
            }
            if (serviceQName != null) {
                ValidationObjectID importID = new ValidationObjectID(service, serviceQName, locationURI, ValidationObjectTypeEnum.SDX_TYPE);
                sdxContext = pValidationContext.getNestedValidationContext(importID);
                if (sdxContext != null) {
                    try {
                        sdxInputDoc = sdxContext.getObject().getInput();
                    }
                    catch (ContextInitializationException e) {
                        LOG.error((Object)("Unable to obtain the content of the Service Description: " + e.getMessage()), (Throwable)e);
                    }
                } else {
                    LOG.warn((Object)"The dependent Service Description cannot be obtained");
                }
                if (sdxInputDoc != null) {
                    sdxDefinition = this.openWSDLDefinition(sdxInputDoc);
                    LOG.debug((Object)"SDX Definition successfully reloaded");
                    this.checkParticipantPolicyConsistency(pValidationContext, rootElement, service, sdxDefinition, pReporter);
                } else {
                    this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_PPDX_WRONG_SERVICE_REFERENCE, pReporter, new String[0], null);
                }
            } else {
                LOG.debug((Object)"The validator is not able to resolve the Service document for the Participant Policy, no consistency check performed");
                NodeList defOperationList = rootElement.getElementsByTagNameNS("http://types.sopware.org/qos/ParticipantPolicy/1.1", PPDX_ELEMENT_NAME_DEFAULT_OPERATION);
                NodeList operationList = rootElement.getElementsByTagNameNS("http://types.sopware.org/qos/ParticipantPolicy/1.1", PPDX_ELEMENT_NAME_OPERATION);
                if (defOperationList.getLength() == 0 || operationList.getLength() != 0) {
                    this.messageHelper.reportError(MessageTypeEnum.CONSISTENCY_PPDX_WRONG_SERVICE_REFERENCE, pReporter, new String[0], null);
                }
            }
        } else {
            throw new SOPValidationException("Unsupported document type for consistency validation", new IllegalArgumentException());
        }
    }
}

