/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core.impl.service;

import javax.xml.namespace.QName;
import org.eclipse.stp.common.validator.base.ValidationMessage;
import org.eclipse.stp.common.validator.core.IReporter;
import org.eclipse.stp.common.validator.core.MessageTypeEnum;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MessageHelper
implements ErrorHandler {
    private static final String MSG_BUNDLE_NAME = "messages";
    private IReporter iReporter = null;
    private QName currentObject = null;

    public void setReporter(IReporter reporter) {
        this.iReporter = reporter;
    }

    public void setCurrentObject(QName objectQName) {
        this.currentObject = objectQName;
    }

    public void reportError(MessageTypeEnum msgID, IReporter pReporter, String[] params, Object cause) {
        if (pReporter != null) {
            this.reportMessage(1, msgID, pReporter, params, cause, null);
        }
    }

    public void reportError(MessageTypeEnum msgID, IReporter pReporter, String[] params, QName objQName) {
        if (pReporter != null) {
            this.reportMessage(1, msgID, pReporter, params, null, objQName);
        }
    }

    public void reportWarning(MessageTypeEnum msgID, IReporter pReporter, String[] params, Object cause) {
        if (pReporter != null) {
            this.reportMessage(2, msgID, pReporter, params, cause, null);
        }
    }

    public void reportInfo(MessageTypeEnum msgID, IReporter pReporter, String[] params) {
        if (pReporter != null) {
            this.reportMessage(4, msgID, pReporter, params, null, null);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.iReporter != null) {
            ValidationMessage msg = new ValidationMessage(MSG_BUNDLE_NAME, 1, MessageTypeEnum.XML_SCHEMA_CONSTRAINT, new String[]{exception.toString()});
            msg.setLineNo(exception.getLineNumber());
            if (this.currentObject != null) {
                msg.setAttribute("source", this.currentObject);
            }
            this.iReporter.addMessage(msg);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.iReporter != null) {
            ValidationMessage msg = new ValidationMessage(MSG_BUNDLE_NAME, 1, MessageTypeEnum.XML_SCHEMA_CONSTRAINT, new String[]{exception.getMessage()});
            msg.setLineNo(exception.getLineNumber());
            if (this.currentObject != null) {
                msg.setAttribute("source", this.currentObject);
            }
            this.iReporter.addMessage(msg);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.iReporter != null) {
            ValidationMessage msg = new ValidationMessage(MSG_BUNDLE_NAME, 2, MessageTypeEnum.XML_SCHEMA_CONSTRAINT, new String[]{exception.toString()});
            msg.setLineNo(exception.getLineNumber());
            if (this.currentObject != null) {
                msg.setAttribute("source", this.currentObject);
            }
            this.iReporter.addMessage(msg);
        }
    }

    private void reportMessage(int severity, MessageTypeEnum msgID, IReporter pReporter, String[] params, Object cause, QName objQName) {
        if (pReporter != null) {
            ValidationMessage msg = new ValidationMessage(MSG_BUNDLE_NAME, severity, msgID, params);
            if (cause != null) {
                msg.setAttribute("cause", cause);
            }
            if (objQName != null) {
                msg.setAttribute("source", objQName);
            } else if (this.currentObject != null) {
                msg.setAttribute("source", this.currentObject);
            }
            pReporter.addMessage(msg);
        }
    }
}

