/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.in.bpmn2im;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.im.in.bpmn2im.IBPMNProcessor;
import org.eclipse.stp.im.util.ImLogger;

public class BPMNProcessorProxy {
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_CLASS = "class";
    private final IConfigurationElement configElement;
    private final String id;
    private final String name;

    public BPMNProcessorProxy(IConfigurationElement configElement) {
        this.configElement = configElement;
        this.id = BPMNProcessorProxy.getAttribute(configElement, ATT_ID, null);
        this.name = BPMNProcessorProxy.getAttribute(configElement, ATT_NAME, this.id);
        BPMNProcessorProxy.getAttribute(configElement, ATT_CLASS, null);
    }

    private static String getAttribute(IConfigurationElement configElem, String name, String defaultValue) {
        String value = configElem.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException("Missing " + name + " attribute");
    }

    public IBPMNProcessor getBPMNProcessor() {
        try {
            IBPMNProcessor runtime = (IBPMNProcessor)this.configElement.createExecutableExtension(ATT_CLASS);
            return runtime;
        }
        catch (Exception e) {
            ImLogger.error((String)"org.eclipse.stp.im.in.bpmn", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

