/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.in.bpmn2im;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.im.in.bpmn2im.BPMNProcessorProxy;
import org.eclipse.stp.im.in.bpmn2im.IBPMNProcessor;
import org.eclipse.stp.im.util.ImLogger;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bpmn2ImActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.stp.im.in.bpmn";
    private static Bpmn2ImActivator plugin;
    private static List<IBPMNProcessor> bpmnProcessors;
    public static final String BPMN_PROCESSOR_TAG = "bpmn-processor";

    static {
        bpmnProcessors = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Bpmn2ImActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Bpmn2ImActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void initBPMNProcessors() {
        try {
            IExtensionRegistry extensionPointRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionPointRegistry.getExtensionPoint(PLUGIN_ID, "bpmnprocessor");
            IExtension[] extensions = extensionPoint.getExtensions();
            bpmnProcessors = new ArrayList<IBPMNProcessor>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    BPMNProcessorProxy proxy = Bpmn2ImActivator.parseBPMNDescriptorProxy(configElements[j]);
                    if (proxy != null) {
                        bpmnProcessors.add(proxy.getBPMNProcessor());
                    }
                    ++j;
                }
                ++i;
            }
            return;
        }
        catch (Throwable t) {
            ImLogger.error((String)"org.eclipse.stp.im.runtime", (String)t.getMessage(), (Throwable)t);
            bpmnProcessors = null;
            return;
        }
    }

    private static BPMNProcessorProxy parseBPMNDescriptorProxy(IConfigurationElement configElement) {
        if (!configElement.getName().equals(BPMN_PROCESSOR_TAG)) {
            return null;
        }
        try {
            return new BPMNProcessorProxy(configElement);
        }
        catch (Exception e) {
            ImLogger.error((String)PLUGIN_ID, (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<IBPMNProcessor> getBPMNProcessors() {
        if (bpmnProcessors == null) {
            Bpmn2ImActivator.initBPMNProcessors();
        }
        return bpmnProcessors;
    }
}

