/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.in.bpmn2im;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.AssociationTarget;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.DataObject;
import org.eclipse.stp.bpmn.Lane;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.im.BasicProperty;
import org.eclipse.stp.im.Condition;
import org.eclipse.stp.im.ExpressionCondition;
import org.eclipse.stp.im.ExtractDataRule;
import org.eclipse.stp.im.ImFactory;
import org.eclipse.stp.im.MapProperty;
import org.eclipse.stp.im.ObservableAttribute;
import org.eclipse.stp.im.Process;
import org.eclipse.stp.im.ProcessCollection;
import org.eclipse.stp.im.PropertyCondition;
import org.eclipse.stp.im.Service;
import org.eclipse.stp.im.ServiceBinding;
import org.eclipse.stp.im.ServiceCollection;
import org.eclipse.stp.im.Step;
import org.eclipse.stp.im.StpIntermediateModel;
import org.eclipse.stp.im.Transition;
import org.eclipse.stp.im.TransitionUnderCondition;
import org.eclipse.stp.im.Variable;
import org.eclipse.stp.im.in.bpmn2im.Bpmn2ImActivator;
import org.eclipse.stp.im.in.bpmn2im.BpmnDiagramUtils;
import org.eclipse.stp.im.in.bpmn2im.IBPMNProcessor;
import org.eclipse.stp.im.runtime.IRuntime;
import org.eclipse.stp.im.runtime.IService;
import org.eclipse.stp.im.runtime.IServiceBinding;
import org.eclipse.stp.im.runtime.ImRuntimeActivator;
import org.eclipse.stp.im.util.ImLogger;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bpmn2ImWorkspaceOperation
extends WorkspaceModifyOperation {
    private static String IS_STEP_INTERMEDIATE_EVENT = "im.isStepIntermediateEvent";
    private IFile bpmnFile = null;
    List<String> selectedPools = null;
    private List<IFile> generatedFiles = null;
    private boolean separateImForEachPool = false;

    public List<IFile> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public void setGeneratedFiles(List<IFile> generatedFiles) {
        this.generatedFiles = generatedFiles;
    }

    public boolean isSeparateImForEachPool() {
        return this.separateImForEachPool;
    }

    public void setSeparateImForEachPool(boolean separateImForEachPool) {
        this.separateImForEachPool = separateImForEachPool;
    }

    public Bpmn2ImWorkspaceOperation(IFile bpmnFile) {
        this.bpmnFile = bpmnFile;
        this.generatedFiles = new ArrayList<IFile>();
    }

    public Bpmn2ImWorkspaceOperation(IFile bpmnFile, List<String> selectedPools) {
        this.bpmnFile = bpmnFile;
        this.selectedPools = selectedPools;
        this.generatedFiles = new ArrayList<IFile>();
    }

    protected void execute(IProgressMonitor monitor) {
        try {
            try {
                Resource resourceBpmn = BpmnDiagramUtils.getResourceFromIFile(this.bpmnFile);
                BpmnDiagram bpmnDiagram = BpmnDiagramUtils.getBpmnDiagramFromResource(resourceBpmn);
                List<IBPMNProcessor> processors = Bpmn2ImActivator.getBPMNProcessors();
                if (processors != null) {
                    for (IBPMNProcessor processor : processors) {
                        List<String> addToSelection;
                        if (processor.isApplicable(bpmnDiagram)) {
                            bpmnDiagram = processor.process(bpmnDiagram);
                        }
                        if ((addToSelection = processor.selectPools(bpmnDiagram)) == null) continue;
                        this.selectedPools.addAll(addToSelection);
                    }
                }
                int workingUnits = 10 * this.selectedPools.size() + 20;
                monitor.beginTask(" Creating Intermediate Model", workingUnits);
                if (this.separateImForEachPool) {
                    for (String poolID : this.selectedPools) {
                        ArrayList<String> toUsePoolIDs = new ArrayList<String>();
                        toUsePoolIDs.add(poolID);
                        StpIntermediateModel stpIm = this.createIntermediateModelFromBpmn(bpmnDiagram, toUsePoolIDs, monitor);
                        this.writeStpIntermediateModel(stpIm, monitor, this.retrievePoolName(bpmnDiagram, poolID));
                    }
                } else {
                    StpIntermediateModel stpIm = this.createIntermediateModelFromBpmn(bpmnDiagram, this.selectedPools, monitor);
                    this.writeStpIntermediateModel(stpIm, monitor, null);
                }
            }
            catch (Throwable x) {
                ImLogger.error((String)x.getMessage(), (Throwable)x);
                throw new RuntimeException(" Error Generating IM From BPMN", x);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public String retrievePoolName(BpmnDiagram bpmn, String poolID) {
        for (Pool p : bpmn.getPools()) {
            if (!p.getID().equals(poolID)) continue;
            return p.getName();
        }
        return "pool";
    }

    private void createProcessParameters(Pool aPool, Process process, ImFactory stpModelfactory) {
        EAnnotation poolParametersAnnotation = aPool.getEAnnotation("parameters");
        if (poolParametersAnnotation != null) {
            EMap details = poolParametersAnnotation.getDetails();
            EMap propertyMap = null;
            MapProperty processParametersMapProperty = stpModelfactory.createMapProperty();
            processParametersMapProperty.setKey("im.process.parameters");
            propertyMap = processParametersMapProperty.getValue();
            process.getProperties().put((Object)"im.process.parameters", (Object)processParametersMapProperty);
            BasicProperty processParameterBasicProperty = null;
            for (String key : details.keySet()) {
                String propertyValue = (String)details.get((Object)key);
                processParameterBasicProperty = stpModelfactory.createBasicProperty();
                processParameterBasicProperty.setKey(key);
                processParameterBasicProperty.setValue(propertyValue);
                propertyMap.put((Object)key, (Object)processParameterBasicProperty);
            }
        }
    }

    public StpIntermediateModel createIntermediateModelFromBpmn(BpmnDiagram bpmnDiagram, List<String> selectedPools, IProgressMonitor monitor) {
        ImFactory stpModelfactory = ImFactory.eINSTANCE;
        StpIntermediateModel stpIm = stpModelfactory.createStpIntermediateModel();
        String currentVersion = "0";
        EAnnotation versionAnnotation = bpmnDiagram.getEAnnotation("im.version");
        if (versionAnnotation != null) {
            currentVersion = (String)versionAnnotation.getDetails().get((Object)"im.process.version");
        }
        BasicProperty iterVersionBasicProperty = stpModelfactory.createBasicProperty();
        iterVersionBasicProperty.setKey("im.iter.version");
        iterVersionBasicProperty.setValue(currentVersion);
        stpIm.getProperties().put((Object)"im.iter.version", (Object)iterVersionBasicProperty);
        monitor.subTask("Generating Intermediate Model");
        BasicProperty bp = null;
        MapProperty mp = null;
        monitor.subTask("Iter Configuration");
        if (bpmnDiagram.getEAnnotation("im.iter") != null) {
            EAnnotation iterAnnotation = bpmnDiagram.getEAnnotation("im.iter");
            EMap iterAnnotationDetails = iterAnnotation.getDetails();
            bp = stpModelfactory.createBasicProperty();
            bp.setKey("im.iter.name");
            bp.setValue((String)iterAnnotationDetails.get((Object)"im.iter.name"));
            stpIm.getProperties().put((Object)bp.getKey(), (Object)bp);
            bp = stpModelfactory.createBasicProperty();
            bp.setKey("im.iter.firstprocess.name");
            bp.setValue((String)iterAnnotationDetails.get((Object)"im.iter.firstprocess.name"));
            stpIm.getProperties().put((Object)bp.getKey(), (Object)bp);
            String ruleExpr = "";
            ruleExpr = (String)iterAnnotationDetails.get((Object)"im.iter.rule");
            if (ruleExpr != null && ruleExpr.trim().length() > 0) {
                bp = stpModelfactory.createBasicProperty();
                bp.setKey("im.iter.rule");
                bp.setValue((String)iterAnnotationDetails.get((Object)"im.iter.rule"));
                stpIm.getProperties().put((Object)bp.getKey(), (Object)bp);
                bp = stpModelfactory.createBasicProperty();
                bp.setKey("im.iter.rule.language");
                bp.setValue((String)iterAnnotationDetails.get((Object)"im.iter.rule.language"));
                stpIm.getProperties().put((Object)bp.getKey(), (Object)bp);
            }
            bp = stpModelfactory.createBasicProperty();
            bp.setKey("im.iter.obsattribute.list.size");
            bp.setValue((String)iterAnnotationDetails.get((Object)"im.iter.obsattribute.list.size"));
            stpIm.getProperties().put((Object)bp.getKey(), (Object)bp);
            Integer size = Integer.valueOf((String)iterAnnotationDetails.get((Object)"im.iter.obsattribute.list.size"));
            mp = stpModelfactory.createMapProperty();
            mp.setKey("im.iter.observableattribute.map");
            int j = 0;
            while (j < size) {
                bp = stpModelfactory.createBasicProperty();
                bp.setKey(MessageFormat.format("im.iter.obsattribute[{0}].id", j));
                bp.setValue((String)iterAnnotationDetails.get((Object)MessageFormat.format("im.iter.obsattribute[{0}].id", j)));
                mp.getValue().put((Object)bp.getKey(), (Object)bp);
                bp = stpModelfactory.createBasicProperty();
                bp.setKey(MessageFormat.format("im.iter.obsattribute[{0}].name", j));
                bp.setValue((String)iterAnnotationDetails.get((Object)MessageFormat.format("im.iter.obsattribute[{0}].name", j)));
                mp.getValue().put((Object)bp.getKey(), (Object)bp);
                ++j;
            }
            stpIm.getProperties().put((Object)mp.getKey(), (Object)mp);
        }
        monitor.worked(10);
        ProcessCollection processCollection = stpModelfactory.createProcessCollection();
        ServiceCollection serviceCollection = stpModelfactory.createServiceCollection();
        HashMap<String, Service> imServicesMap = new HashMap<String, Service>();
        HashMap<String, ServiceBinding> imServiceBindingsMap = new HashMap<String, ServiceBinding>();
        ArrayList<IRuntime> usedRuntimes = new ArrayList<IRuntime>();
        EAnnotation technologyAnnotation = null;
        String runtimeId = null;
        for (Pool aPool : bpmnDiagram.getPools()) {
            if (selectedPools != null && !selectedPools.contains(aPool.getID()) || (technologyAnnotation = aPool.getEAnnotation("technology")) == null || (runtimeId = (String)technologyAnnotation.getDetails().get((Object)"im.pool.runtimeID")) == null) continue;
            usedRuntimes.add(ImRuntimeActivator.getRuntime((String)runtimeId));
        }
        monitor.subTask("Generating Services And Service Bindings ");
        BasicProperty runtimeIdProperty = null;
        for (IRuntime aRuntime : usedRuntimes) {
            Map runtimeServiceBinding = aRuntime.getServiceBindings();
            ServiceBinding aServiceBinding = null;
            runtimeId = aRuntime.getId();
            for (IServiceBinding serviceBinding : runtimeServiceBinding.values()) {
                if (!imServiceBindingsMap.containsKey(serviceBinding.getName())) {
                    aServiceBinding = stpModelfactory.createServiceBinding();
                    aServiceBinding.setName(serviceBinding.getName());
                    runtimeIdProperty = stpModelfactory.createBasicProperty();
                    runtimeIdProperty.setKey("im.stepbinding.runtimeID");
                    runtimeIdProperty.setValue(runtimeId);
                    aServiceBinding.getProperties().put((Object)runtimeIdProperty.getKey(), (Object)runtimeIdProperty);
                    stpIm.getServicebindings().add((Object)aServiceBinding);
                    imServiceBindingsMap.put(serviceBinding.getName(), aServiceBinding);
                    continue;
                }
                ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)(" ServiceBinding  [ " + serviceBinding.getName() + "] already Created in IM"));
            }
            Object service = null;
            String serviceEntity = null;
            for (IService aService : aRuntime.getServices()) {
                if (!imServicesMap.containsKey(aService.getName())) {
                    serviceEntity = aService.getEmfServiceEntity();
                    service = serviceEntity == null ? stpModelfactory.createService() : (serviceEntity.equalsIgnoreCase("SplitControl") ? stpModelfactory.createSplitControl() : (serviceEntity.equalsIgnoreCase("JoinControl") ? stpModelfactory.createJoinControl() : (serviceEntity.equalsIgnoreCase("RouterControl") ? stpModelfactory.createRouterControl() : (serviceEntity.equalsIgnoreCase("IterationControl") ? stpModelfactory.createIterationControl() : stpModelfactory.createService()))));
                    service.setServiceName(aService.getName());
                    service.setServiceType("BPMN-Service");
                    for (String bindingNameForService : aService.getServiceBindingsName()) {
                        service.getBindings().add((Object)((ServiceBinding)imServiceBindingsMap.get(bindingNameForService)));
                    }
                    serviceCollection.getServices().add(service);
                    imServicesMap.put(aService.getName(), (Service)service);
                    continue;
                }
                ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)(" Service [ " + aService.getName() + "] already Created in IM"));
            }
        }
        monitor.worked(10);
        Process process = null;
        HashMap<String, Step> stepMapForPool = new HashMap<String, Step>();
        for (Pool aPool : bpmnDiagram.getPools()) {
            Object filepath;
            if (selectedPools != null && !selectedPools.contains(aPool.getID())) continue;
            aPool.setName(aPool.getName());
            monitor.subTask("Generating IM Process for Pool " + aPool.getName());
            stepMapForPool.clear();
            process = stpModelfactory.createProcess();
            process.setName(aPool.getName());
            BasicProperty processProperty = null;
            EList laneList = aPool.getLanes();
            for (Lane lane : laneList) {
                String laneName = lane.getName();
                String prop = "swimlane";
                if (process.getProperties().containsKey((Object)prop)) {
                    processProperty = (BasicProperty)process.getProperties().get((Object)prop);
                    laneName = String.valueOf(processProperty.getValue()) + "#" + laneName;
                } else {
                    processProperty = stpModelfactory.createBasicProperty();
                    processProperty.setKey(prop);
                }
                processProperty.setValue(laneName);
                process.getProperties().put((Object)prop, (Object)processProperty);
            }
            process.setDescription(aPool.getDocumentation());
            BasicProperty versionBasicProperty = stpModelfactory.createBasicProperty();
            versionBasicProperty.setKey("im.process.version");
            versionBasicProperty.setValue(currentVersion);
            process.getProperties().put((Object)"im.process.version", (Object)versionBasicProperty);
            technologyAnnotation = aPool.getEAnnotation("technology");
            if (technologyAnnotation != null) {
                EMap details = technologyAnnotation.getDetails();
                BasicProperty processParameterBasicProperty = null;
                for (String key : details.keySet()) {
                    String propertyValue = (String)details.get((Object)key);
                    processParameterBasicProperty = stpModelfactory.createBasicProperty();
                    processParameterBasicProperty.setKey(key);
                    processParameterBasicProperty.setValue(propertyValue);
                    process.getProperties().put((Object)key, (Object)processParameterBasicProperty);
                }
            }
            this.createProcessParameters(aPool, process, stpModelfactory);
            EList vertices = aPool.getVertices();
            Variable var = null;
            for (Artifact anArtifact : aPool.getArtifacts()) {
                EList associations;
                if (!(anArtifact instanceof DataObject) || anArtifact.getEAnnotations().size() != 0 || (associations = anArtifact.getAssociations()) != null && associations.size() != 0) continue;
                var = stpModelfactory.createVariable();
                var.setName(anArtifact.getName());
                process.getProcessVariables().add((Object)var);
            }
            for (Vertex v : vertices) {
                if (v instanceof Activity) {
                    Activity a = (Activity)v;
                    Step aStep = this.createStepForActivity(a, stpModelfactory, imServicesMap, imServiceBindingsMap);
                    process.getSteps().add((Object)aStep);
                    stepMapForPool.put(aStep.getName(), aStep);
                    if ((a.isLooping() || a.isSetLooping()) && a instanceof SubProcess) {
                        for (Vertex vertexSubProcess : ((SubProcess)a).getVertices()) {
                            aStep = this.createStepForActivity((Activity)vertexSubProcess, stpModelfactory, imServicesMap, imServiceBindingsMap);
                            process.getSteps().add((Object)aStep);
                            stepMapForPool.put(aStep.getName(), aStep);
                        }
                        Step endLoopStep = stpModelfactory.createStep();
                        endLoopStep.setName("End." + this.getStepNameForActivity(a));
                        endLoopStep.setDescription(" Description for " + a.getName());
                        process.getSteps().add((Object)endLoopStep);
                        stepMapForPool.put(endLoopStep.getName(), endLoopStep);
                    }
                    for (EAnnotation annotation : a.getEAnnotations()) {
                        EMap details;
                        if (annotation.getSource().equals("genericFile") && (details = annotation.getDetails()) != null && (filepath = (String)details.get((Object)"projectRelativePath")) != null && ((String)filepath).trim().length() > 0) {
                            BasicProperty property = ImFactory.eINSTANCE.createBasicProperty();
                            property.setKey("documentationRelativePath");
                            property.setValue((String)filepath);
                            aStep.getProperties().put((Object)property.getKey(), (Object)property);
                        }
                        this.createTaskConfigProp(annotation, aStep, stpModelfactory);
                    }
                    continue;
                }
                ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)(" Not Recognized v [" + v.getID() + "] as Activity"));
            }
            Vertex sourceVertex = null;
            Vertex targetVertex = null;
            for (SequenceEdge seqEdge : aPool.getSequenceEdges()) {
                sourceVertex = seqEdge.getSource();
                targetVertex = seqEdge.getTarget();
                if (sourceVertex instanceof Activity && targetVertex instanceof Activity) {
                    Activity sourceActivity = (Activity)sourceVertex;
                    Activity targetActivity = (Activity)targetVertex;
                    if (sourceActivity.isLooping() && sourceActivity.isSetLooping()) {
                        if (!(sourceActivity instanceof SubProcess)) continue;
                        filepath = ((SubProcess)sourceActivity).getSequenceEdges().iterator();
                        while (filepath.hasNext()) {
                            Activity targetActivitySubProcess;
                            Activity sourceActivitySubProcess;
                            Transition aTransition;
                            SequenceEdge seqEdgeSubPool = (SequenceEdge)filepath.next();
                            Iterator sourceVertexSubProcess = seqEdgeSubPool.getSource();
                            Vertex targetVertexSubProcess = seqEdgeSubPool.getTarget();
                            if (!(sourceVertexSubProcess instanceof Activity) || !(sourceVertexSubProcess instanceof Activity) || (aTransition = this.createTransition(sourceActivitySubProcess = (Activity)sourceVertexSubProcess, targetActivitySubProcess = (Activity)targetVertexSubProcess, seqEdge, stpModelfactory, stepMapForPool)) == null) continue;
                            process.getTransitions().add((Object)aTransition);
                        }
                        Activity firstLoopActivity = null;
                        for (Vertex vertexSubProcess : ((SubProcess)sourceActivity).getVertices()) {
                            if (!(vertexSubProcess instanceof Activity) || vertexSubProcess.getIncomingEdges().size() != 0) continue;
                            firstLoopActivity = (Activity)vertexSubProcess;
                        }
                        Transition firstLoopTransition = stpModelfactory.createTransition();
                        firstLoopTransition.setSource((Step)stepMapForPool.get(this.getStepNameForActivity(sourceActivity)));
                        firstLoopTransition.setTarget((Step)stepMapForPool.get(this.getStepNameForActivity(firstLoopActivity)));
                        process.getTransitions().add((Object)firstLoopTransition);
                        Step endLoopStep = (Step)stepMapForPool.get("End." + this.getStepNameForActivity(sourceActivity));
                        for (Vertex vertexSubProcess : ((SubProcess)sourceActivity).getVertices()) {
                            if (!(vertexSubProcess instanceof Activity) || vertexSubProcess.getOutgoingEdges().size() != 0) continue;
                            Transition endLoopTransition = stpModelfactory.createTransition();
                            endLoopTransition.setSource((Step)stepMapForPool.get(this.getStepNameForActivity((Activity)vertexSubProcess)));
                            endLoopTransition.setTarget(endLoopStep);
                            process.getTransitions().add((Object)endLoopTransition);
                        }
                        Transition endLoopOriginalTargetTransition = stpModelfactory.createTransition();
                        endLoopOriginalTargetTransition.setSource(endLoopStep);
                        endLoopOriginalTargetTransition.setTarget((Step)stepMapForPool.get(this.getStepNameForActivity(targetActivity)));
                        process.getTransitions().add((Object)endLoopOriginalTargetTransition);
                        continue;
                    }
                    Transition aTransition = this.createTransition(sourceActivity, targetActivity, seqEdge, stpModelfactory, stepMapForPool);
                    if (aTransition == null) continue;
                    process.getTransitions().add((Object)aTransition);
                    continue;
                }
                ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)" Not Recognized Activity in Edge Analysis");
            }
            processCollection.getProcesses().add((Object)process);
            monitor.worked(10);
            this.createTaskVariables(process, aPool, stpModelfactory);
        }
        stpIm.setServiceCollection(serviceCollection);
        stpIm.setProcessCollection(processCollection);
        return stpIm;
    }

    public Transition createTransition(Activity sourceActivity, Activity targetActivity, SequenceEdge seqEdge, ImFactory stpModelfactory, Map<String, Step> stepMapForPool) {
        String sourceStepName = null;
        String targetStepName = null;
        TransitionUnderCondition aTransition = null;
        boolean isConditioned = false;
        Condition condition = null;
        sourceStepName = this.getStepNameForActivity(sourceActivity);
        targetStepName = this.getStepNameForActivity(targetActivity);
        isConditioned = this.isEdgeConditioned(seqEdge);
        if (isConditioned) {
            aTransition = stpModelfactory.createTransitionUnderCondition();
        } else {
            aTransition = stpModelfactory.createTransition();
            if (seqEdge.getName() != null && seqEdge.getName().trim().length() > 0) {
                BasicProperty transitionProperty = stpModelfactory.createBasicProperty();
                transitionProperty.setKey("TransitionLabel");
                transitionProperty.setValue(seqEdge.getName());
                aTransition.getProperties().put((Object)transitionProperty.getKey(), (Object)transitionProperty);
            }
        }
        aTransition.setSource(stepMapForPool.get(sourceStepName));
        aTransition.setTarget(stepMapForPool.get(targetStepName));
        if (isConditioned && (condition = this.createConditionForTransition(stpModelfactory, seqEdge, (Transition)aTransition)) != null) {
            aTransition.setCondition(condition);
        }
        return aTransition;
    }

    public Step createStepForActivity(Activity a, ImFactory stpModelfactory, Map<String, Service> imServicesMap, Map<String, ServiceBinding> imServiceBindingsMap) {
        Step aStep = stpModelfactory.createStep();
        String stepServiceName = null;
        String stepServiceBindingName = null;
        String stepRuntimeID = null;
        EAnnotation imAnnotation = null;
        BasicProperty stepProperty = null;
        aStep.setName(this.getStepNameForActivity(a));
        aStep.setDescription(" Description for " + a.getName());
        EList laneList = a.getLanes();
        for (Lane lane : laneList) {
            String laneName = lane.getName();
            String prop = "swimlane";
            if (aStep.getProperties().containsKey((Object)prop)) {
                stepProperty = (BasicProperty)aStep.getProperties().get((Object)prop);
                laneName = String.valueOf(stepProperty.getValue()) + "#" + laneName;
            } else {
                stepProperty = stpModelfactory.createBasicProperty();
                stepProperty.setKey(prop);
            }
            stepProperty.setValue(laneName);
            aStep.getProperties().put((Object)prop, (Object)stepProperty);
        }
        this.checkStartEndEvent(aStep, a, stpModelfactory);
        this.checkGatewayElement(aStep, a, stpModelfactory);
        this.checkIntermediateEvent(aStep, a, stpModelfactory);
        imAnnotation = a.getEAnnotation("im");
        if (imAnnotation != null) {
            stepServiceName = (String)imAnnotation.getDetails().get((Object)"im.servicename");
            stepServiceBindingName = (String)imAnnotation.getDetails().get((Object)"im.servicebindingname");
            for (String prop : imAnnotation.getDetails().keySet()) {
                if (prop.equalsIgnoreCase("im.servicename")) {
                    stepServiceName = (String)imAnnotation.getDetails().get((Object)prop);
                    continue;
                }
                if (prop.equalsIgnoreCase("im.servicebindingname")) {
                    stepServiceBindingName = (String)imAnnotation.getDetails().get((Object)prop);
                    continue;
                }
                if (prop.equalsIgnoreCase("im.pool.runtimeID")) {
                    stepRuntimeID = (String)imAnnotation.getDetails().get((Object)prop);
                    continue;
                }
                stepProperty = stpModelfactory.createBasicProperty();
                stepProperty.setKey(prop);
                stepProperty.setValue((String)imAnnotation.getDetails().get((Object)prop));
                aStep.getProperties().put((Object)stepProperty.getKey(), (Object)stepProperty);
            }
            ImLogger.info((String)"org.eclipse.stp.im.in.bpmn", (String)("Setting service [" + stepServiceName + "] as Service on this step"));
            ImLogger.info((String)"org.eclipse.stp.im.in.bpmn", (String)("Setting serviceBinding [" + stepServiceBindingName + "] as Service on this step"));
            Service stepService = imServicesMap.get(stepServiceName);
            ServiceBinding stepServiceBinding = imServiceBindingsMap.get(stepServiceBindingName);
            aStep.setServiceModel(stepService);
            if (stepServiceBinding != null) {
                aStep.getStepbindings().add((Object)stepServiceBinding);
            } else {
                ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)"stepServiceBinding is null ");
            }
            Artifact anArtifact = null;
            EAnnotation relDataAnnotation = null;
            for (Association anAssociation : a.getAssociations()) {
                anArtifact = anAssociation.getSource();
                relDataAnnotation = anArtifact.getEAnnotation("imobsattribute");
                if (relDataAnnotation == null) continue;
                EMap relDataDetails = relDataAnnotation.getDetails();
                Integer size = Integer.valueOf((String)relDataDetails.get((Object)"im.obsattribute.list.size"));
                String attributeId = null;
                String attributeName = null;
                String ruleId = null;
                String ruleName = null;
                String ruleExpression = null;
                String ruleLanguage = null;
                String ruleSubjectToCondition = null;
                String conditionExpression = null;
                String conditionExpressionLanguage = null;
                ObservableAttribute obsAttribute = null;
                ExtractDataRule extractDataRule = null;
                int i = 1;
                while (i <= size) {
                    attributeId = (String)relDataDetails.get((Object)MessageFormat.format("im.obsattribute[{0}].id", i));
                    attributeName = (String)relDataDetails.get((Object)MessageFormat.format("im.obsattribute[{0}].name", i));
                    ruleId = (String)relDataDetails.get((Object)MessageFormat.format("im.obsattribute[{0}].ruleid", i));
                    ruleName = (String)relDataDetails.get((Object)MessageFormat.format("im.obsattribute[{0}].rulename", i));
                    ruleExpression = (String)relDataDetails.get((Object)MessageFormat.format("im.obsattribute[{0}].ruleexpression", i));
                    ruleLanguage = (String)relDataDetails.get((Object)MessageFormat.format("im.obsattribute[{0}].rulelanguage", i));
                    ruleSubjectToCondition = (String)relDataDetails.get((Object)MessageFormat.format("im.obsattribute[{0}].flagrulesubjecttocondition", i));
                    conditionExpression = (String)relDataDetails.get((Object)MessageFormat.format("im.obsattribute[{0}].conditionruleexpression", i));
                    conditionExpressionLanguage = (String)relDataDetails.get((Object)MessageFormat.format("im.obsattribute[{0}].conditionrulelanguage", i));
                    extractDataRule = stpModelfactory.createExtractDataRule();
                    extractDataRule.setIdRule(ruleId);
                    extractDataRule.setName(ruleName);
                    extractDataRule.setExpression(ruleExpression);
                    extractDataRule.setExpressionLanguage(ruleLanguage);
                    if (Boolean.valueOf(ruleSubjectToCondition).booleanValue()) {
                        ExpressionCondition exprCondition = stpModelfactory.createExpressionCondition();
                        exprCondition.setExpression(conditionExpression);
                        exprCondition.setExpressionLanguage(conditionExpressionLanguage);
                        extractDataRule.setCondition(exprCondition);
                    }
                    obsAttribute = stpModelfactory.createObservableAttribute();
                    obsAttribute.setIdAttribute(attributeId);
                    obsAttribute.setName(attributeName);
                    obsAttribute.setObservableAttributeExtractRule(extractDataRule);
                    aStep.getObservableAttributes().add((Object)obsAttribute);
                    ++i;
                }
            }
        } else {
            ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)("Activity [" + a.getName() + "] does not have annotation"));
        }
        return aStep;
    }

    public String normalizeName(String s) {
        return s.replace(' ', '_');
    }

    public String getStepNameForActivity(Activity a) {
        String name = a.getName();
        if (name == null) {
            ImLogger.info((String)"org.eclipse.stp.im.in.bpmn", (String)("Activity [" + a.getID() + "] has no name id is used"));
            name = a.getID();
        }
        return name;
    }

    public boolean isEdgeConditioned(SequenceEdge seqEdge) {
        return seqEdge.getEAnnotation("imtransition") != null;
    }

    public Condition createConditionForTransition(ImFactory stpModelFactory, SequenceEdge seqEdge, Transition aTransition) {
        EAnnotation transitionAnnotation = seqEdge.getEAnnotation("imtransition");
        EMap transitionAnnotationDetails = transitionAnnotation.getDetails();
        ExpressionCondition condition = null;
        String transitionType = (String)transitionAnnotationDetails.get((Object)"im.transition.type");
        if (transitionType.equalsIgnoreCase("ExpressionCondition")) {
            condition = stpModelFactory.createExpressionCondition();
            condition.setExpressionLanguage("XPath");
            condition.setExpression((String)transitionAnnotationDetails.get((Object)"Expression"));
        } else if (transitionType.equalsIgnoreCase("PropertyCondition")) {
            condition = stpModelFactory.createPropertyCondition();
            ((PropertyCondition)condition).setOperator((String)transitionAnnotationDetails.get((Object)"Operator"));
            ((PropertyCondition)condition).setPropertyName((String)transitionAnnotationDetails.get((Object)"PropertyName"));
            ((PropertyCondition)condition).setPropertyValue((String)transitionAnnotationDetails.get((Object)"PropertyValue"));
        } else {
            for (String prop : transitionAnnotationDetails.keySet()) {
                BasicProperty transitionProperty = stpModelFactory.createBasicProperty();
                transitionProperty.setKey(prop);
                transitionProperty.setValue((String)transitionAnnotationDetails.get((Object)prop));
                aTransition.getProperties().put((Object)transitionProperty.getKey(), (Object)transitionProperty);
            }
        }
        return condition;
    }

    public boolean isValidString(String name) {
        return name != null && name.trim().length() > 0;
    }

    public void writeStpIntermediateModel(StpIntermediateModel aStpIntermediateModel, IProgressMonitor monitor, String forcedImFileName) throws Exception {
        IContainer container = this.bpmnFile.getParent();
        ResourceSetImpl resourceSetStpIm = new ResourceSetImpl();
        String destinationStpFileName = this.bpmnFile.getName();
        if (forcedImFileName == null) {
            destinationStpFileName = destinationStpFileName.substring(0, destinationStpFileName.indexOf("."));
            destinationStpFileName = String.valueOf(destinationStpFileName) + ".im";
        } else {
            destinationStpFileName = String.valueOf(forcedImFileName) + ".im";
        }
        IFile destinationStpFile = container.getFile((IPath)new Path(destinationStpFileName));
        URI destinationStpFileURI = URI.createPlatformResourceURI((String)destinationStpFile.getFullPath().toString(), (boolean)true);
        Resource resourceStpIm = resourceSetStpIm.createResource(destinationStpFileURI);
        resourceStpIm.getContents().add((Object)aStpIntermediateModel);
        resourceStpIm.save(Collections.EMPTY_MAP);
        this.generatedFiles.add(destinationStpFile);
    }

    private void checkIntermediateEvent(Step aStep, Activity a, ImFactory stpModelFactory) {
        ActivityType at = a.getActivityType();
        switch (at.getValue()) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                BasicProperty isIntermediateEventProperty = stpModelFactory.createBasicProperty();
                isIntermediateEventProperty.setKey(IS_STEP_INTERMEDIATE_EVENT);
                isIntermediateEventProperty.setValue("true");
                aStep.getProperties().put((Object)IS_STEP_INTERMEDIATE_EVENT, (Object)isIntermediateEventProperty);
                break;
            }
        }
    }

    private void checkStartEndEvent(Step aStep, Activity a, ImFactory stpModelFactory) {
        ActivityType at = a.getActivityType();
        switch (at.getValue()) {
            case 2: {
                BasicProperty isStartEventProperty = stpModelFactory.createBasicProperty();
                isStartEventProperty.setKey("im.isStepStartEvent");
                isStartEventProperty.setValue("true");
                aStep.getProperties().put((Object)"im.isStepStartEvent", (Object)isStartEventProperty);
                break;
            }
            case 17: {
                BasicProperty isEndEventProperty = stpModelFactory.createBasicProperty();
                isEndEventProperty.setKey("im.isStepEndEvent");
                isEndEventProperty.setValue("true");
                aStep.getProperties().put((Object)"im.isStepEndEvent", (Object)isEndEventProperty);
                break;
            }
        }
    }

    private void checkGatewayElement(Step aStep, Activity a, ImFactory stpModelFactory) {
        ActivityType at = a.getActivityType();
        switch (at.getValue()) {
            case 26: {
                BasicProperty isExclusiveGateway = stpModelFactory.createBasicProperty();
                isExclusiveGateway.setKey("im.isExclusiveGateway");
                isExclusiveGateway.setValue("true");
                aStep.getProperties().put((Object)"im.isExclusiveGateway", (Object)isExclusiveGateway);
                break;
            }
            case 25: {
                BasicProperty isExclusiveGateway1 = stpModelFactory.createBasicProperty();
                isExclusiveGateway1.setKey("im.isExclusiveGateway");
                isExclusiveGateway1.setValue("true");
                aStep.getProperties().put((Object)"im.isExclusiveGateway", (Object)isExclusiveGateway1);
                break;
            }
            case 28: {
                BasicProperty isParallelGateway = stpModelFactory.createBasicProperty();
                isParallelGateway.setKey("im.isParallelGateway");
                isParallelGateway.setValue("true");
                aStep.getProperties().put((Object)"im.isParallelGateway", (Object)isParallelGateway);
                break;
            }
        }
    }

    protected void createTaskConfigProp(EAnnotation annotation, Step step, ImFactory stpModelfactory) {
    }

    private void createTaskVariables(Process process, Pool aPool, ImFactory stpModelfactory) {
        EList steps = process.getSteps();
        for (Artifact anArtifact : aPool.getArtifacts()) {
            DataObject dataObject;
            EList associations;
            if (!(anArtifact instanceof DataObject) || anArtifact.getEAnnotations().size() != 0 || (associations = (dataObject = (DataObject)anArtifact).getAssociations()) == null || associations.size() <= 0) continue;
            for (Association association : associations) {
                AssociationTarget associationTarget = association.getTarget();
                if (!(associationTarget instanceof Activity)) continue;
                Activity target = (Activity)associationTarget;
                String stepName = target.getName();
                Step step = null;
                if (stepName != null && stepName.trim().length() > 0) {
                    for (Step astep : steps) {
                        if (!astep.getName().equals(stepName)) continue;
                        step = astep;
                        break;
                    }
                }
                if (step == null) continue;
                EMap props = step.getProperties();
                MapProperty variables = (MapProperty)props.get((Object)"taskVariables");
                if (variables == null) {
                    variables = stpModelfactory.createMapProperty();
                }
                BasicProperty variable = stpModelfactory.createBasicProperty();
                String varName = dataObject.getName();
                variable.setKey(varName);
                variable.setValue(varName);
                variables.getValue().put((Object)varName, (Object)variable);
                props.put((Object)"taskVariables", (Object)variables);
            }
        }
    }
}

