/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.in.bpmn2im;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.im.in.bpmn2im.BpmnDiagramUtils;
import org.eclipse.stp.im.in.bpmn2im.BpmnImValidationException;
import org.eclipse.stp.im.util.ImLogger;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixBpmnDiagramAction
extends WorkspaceModifyOperation {
    private String basicPoolName = "Process";
    private int poolNamesCounter = 0;
    private String basicStepName = "Step";
    private int stepNamesCounter = 0;
    private String basicStartStep = "Start";
    private int startStepNamesCounter = 0;
    private String basicEndStep = "End";
    private int endStepNamesCounter = 0;
    private String basicExclusiveStepName = "Router";
    private int exclusiveStepNamesCounter = 0;
    private String basicParallelStepName = "Parallel";
    private int parallelStepNamesCounter = 0;
    private String basicLoopStepName = "Loop";
    private int loopStepNamesCounter = 0;
    private String basicSubProcessName = "SubProcess";
    private int subPocessNamesCounter = 0;
    private IFile bpmnFile = null;
    private int numberOfFixedError = 0;
    List<String> selectedPools = null;

    public FixBpmnDiagramAction(IFile bpmnFile) {
        this.bpmnFile = bpmnFile;
        this.numberOfFixedError = 0;
    }

    public FixBpmnDiagramAction(IFile bpmnFile, List<String> selectedPools) {
        this.bpmnFile = bpmnFile;
        this.numberOfFixedError = 0;
        this.selectedPools = selectedPools;
    }

    public void resetCounter() {
        this.poolNamesCounter = 0;
        this.stepNamesCounter = 0;
        this.startStepNamesCounter = 0;
        this.endStepNamesCounter = 0;
        this.exclusiveStepNamesCounter = 0;
        this.parallelStepNamesCounter = 0;
        this.loopStepNamesCounter = 0;
        this.subPocessNamesCounter = 0;
    }

    protected void execute(IProgressMonitor monitor) {
        try {
            this.resetCounter();
            Resource resourceBpmn = BpmnDiagramUtils.getResourceFromIFile(this.bpmnFile);
            BpmnDiagram bpmnDiagram = BpmnDiagramUtils.getBpmnDiagramFromResource(resourceBpmn);
            int workingUnits = 10 * this.selectedPools.size() + 20;
            monitor.beginTask(" Validate Fix/Bpmn Diagram", workingUnits);
            try {
                this.numberOfFixedError = this.validateFixBpmnDiagramForIntermediateModel(bpmnDiagram, this.selectedPools, monitor);
            }
            catch (BpmnImValidationException e) {
                ImLogger.error((String)"org.eclipse.stp.im.in.bpmn", (String)"BPM-IM-GenerationException", (Throwable)e);
                if (monitor != null) {
                    monitor.done();
                }
                return;
            }
            try {
                if (this.numberOfFixedError > 0) {
                    resourceBpmn.save(Collections.EMPTY_MAP);
                }
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public int validateFixBpmnDiagramForIntermediateModel(BpmnDiagram bpmnDiagram, List<String> selectedPools, IProgressMonitor monitor) throws BpmnImValidationException {
        int numberOfFixedErrors = 0;
        monitor.subTask(" Validating/Fixing BPMN Diagram ");
        EAnnotation technologyAnnotation = null;
        for (Pool aPool : bpmnDiagram.getPools()) {
            if (selectedPools != null && !selectedPools.contains(aPool.getID())) continue;
            if (!this.isValidString(aPool.getName())) {
                ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)(" Pool with ID [" + aPool.getID() + "] do not have a Name "));
                ++this.poolNamesCounter;
                ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)(" Fixing error setting name [" + this.basicPoolName + this.poolNamesCounter + "] on  Pool with ID [" + aPool.getID() + "] do not have a Name "));
                aPool.setName(String.valueOf(this.basicPoolName) + this.poolNamesCounter);
                ++numberOfFixedErrors;
            }
            if (aPool.getEAnnotation("technology") == null) {
                ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)(" Pool with ID [" + aPool.getID() + "] and Name [" + aPool.getName() + "] is not bund to any technology it will result in abstract IM Process"));
            }
            technologyAnnotation = null;
            technologyAnnotation = aPool.getEAnnotation("technology");
            if (technologyAnnotation == null) {
                ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)(" Pool with ID [" + aPool.getID() + "] and Name [" + aPool.getName() + "] do not have a technology annotation it will result in an abtsract im model  "));
                continue;
            }
            String runtimeId = (String)technologyAnnotation.getDetails().get((Object)"im.pool.runtimeID");
            if (runtimeId == null || !runtimeId.equalsIgnoreCase("AbstractModel")) continue;
            ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)(" Pool with ID [" + aPool.getID() + "] and Name [" + aPool.getName() + "] have AbstractModel result in an abtsract im model  "));
        }
        for (Pool aPool : bpmnDiagram.getPools()) {
            if (selectedPools != null && !selectedPools.contains(aPool.getID())) continue;
            monitor.subTask(" Validating/Fixing Pool " + aPool.getName());
            EList vertices = aPool.getVertices();
            for (Vertex v : vertices) {
                if (!(v instanceof Activity) || this.isValidString(((Activity)v).getName())) continue;
                ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)(" Activity with ID [" + v.getID() + "] do not have a Name "));
                this.setAutomaticActivityName((Activity)v);
                ++numberOfFixedErrors;
            }
            for (Vertex v : vertices) {
                if (!(v instanceof Activity) || !((Activity)v).isLooping() || !((Activity)v instanceof SubProcess)) continue;
                for (Vertex subVertex : ((SubProcess)v).getVertices()) {
                    if (this.isValidString(((Activity)subVertex).getName())) continue;
                    this.setAutomaticActivityName((Activity)subVertex);
                    ++numberOfFixedErrors;
                }
            }
            Vertex sourceVertex = null;
            Vertex targetVertex = null;
            for (SequenceEdge seqEdge : aPool.getSequenceEdges()) {
                sourceVertex = seqEdge.getSource();
                targetVertex = seqEdge.getTarget();
                if (sourceVertex == null) {
                    throw new BpmnImValidationException(" Transition with ID [" + seqEdge.getID() + "] has no source");
                }
                if (targetVertex == null) {
                    throw new BpmnImValidationException(" Transition with ID [" + seqEdge.getID() + "] has no target");
                }
                if (!(sourceVertex instanceof Activity)) continue;
                ActivityType at = ((Activity)sourceVertex).getActivityType();
                if ((at.equals((Object)ActivityType.GATEWAY_DATA_BASED_EXCLUSIVE_LITERAL) || at.equals((Object)at.equals((Object)ActivityType.GATEWAY_EVENT_BASED_EXCLUSIVE_LITERAL))) && !this.isEdgeConditioned(seqEdge)) {
                    ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)(" Transition form exclusive based gateway [" + sourceVertex.getID() + "] must be conditioned"));
                }
                if (!at.equals((Object)28) || !this.isEdgeConditioned(seqEdge)) continue;
                ImLogger.warning((String)"org.eclipse.stp.im.in.bpmn", (String)(" Transition form parallel gateway [" + sourceVertex.getID() + "] must not be conditioned"));
            }
            monitor.worked(10);
        }
        return numberOfFixedErrors;
    }

    public IFile getBpmnFile() {
        return this.bpmnFile;
    }

    public void setBpmnFile(IFile bpmnFile) {
        this.bpmnFile = bpmnFile;
    }

    public String normalizeStepName(String s) {
        return s.replace(' ', '_');
    }

    public String getStepNameForActivity(Activity a) {
        String name = a.getName();
        if (name == null) {
            ImLogger.info((String)"org.eclipse.stp.im.in.bpmn", (String)("Activity [" + a.getID() + "] has no name id is used"));
            name = a.getID();
        }
        return this.normalizeStepName(name);
    }

    public boolean isEdgeConditioned(SequenceEdge seqEdge) {
        return seqEdge.getEAnnotation("imtransition") != null;
    }

    public boolean isValidString(String name) {
        return name != null && name.trim().length() > 0;
    }

    public void setAutomaticActivityName(Activity a) {
        ActivityType at = a.getActivityType();
        String name = null;
        switch (at.getValue()) {
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                ++this.startStepNamesCounter;
                name = String.valueOf(this.basicStartStep) + this.startStepNamesCounter;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                ++this.endStepNamesCounter;
                name = String.valueOf(this.basicEndStep) + this.endStepNamesCounter;
                break;
            }
            case 25: 
            case 26: {
                ++this.exclusiveStepNamesCounter;
                name = String.valueOf(this.basicExclusiveStepName) + this.exclusiveStepNamesCounter;
                break;
            }
            case 28: {
                ++this.parallelStepNamesCounter;
                name = String.valueOf(this.basicParallelStepName) + this.parallelStepNamesCounter;
                break;
            }
            case 1: {
                if (a.isLooping()) {
                    ++this.loopStepNamesCounter;
                    name = String.valueOf(this.basicLoopStepName) + this.loopStepNamesCounter;
                    break;
                }
                ++this.subPocessNamesCounter;
                name = String.valueOf(this.basicSubProcessName) + this.subPocessNamesCounter;
                break;
            }
            default: {
                ++this.stepNamesCounter;
                name = String.valueOf(this.basicStepName) + this.stepNamesCounter;
            }
        }
        a.setName(name);
    }

    public int getNumberOfFixedError() {
        return this.numberOfFixedError;
    }

    public void setNumberOfFixedError(int numberOfFixedError) {
        this.numberOfFixedError = numberOfFixedError;
    }
}

