/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.out.sca.transform;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.stp.im.Process;
import org.eclipse.stp.im.Service;
import org.eclipse.stp.im.Step;
import org.eclipse.stp.im.StpIntermediateModel;
import org.eclipse.stp.im.out.sca.transform.IMReader;
import org.eclipse.stp.im.out.sca.transform.SCAHandler;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.swt.widgets.Shell;

public class IM2SCATransformer {
    private IMReader imReader = new IMReader();
    private Shell shell;

    public IM2SCATransformer(Shell shell) {
        this.shell = shell;
    }

    public synchronized void createSCAfromIM(URI uri, IContainer container) {
        StpIntermediateModel im = null;
        try {
            im = this.imReader.loadIM(uri);
        }
        catch (Throwable t) {
            this.displayIMError("Could not obtain the IM instance contents", t);
            return;
        }
        SCAHandler scaHandler = new SCAHandler();
        Composite composite = scaHandler.getComposite();
        for (Process proc : im.getProcessCollection().getProcesses()) {
            org.eclipse.stp.sca.Service compositeService = scaHandler.createCompositeService(proc.getName());
            Component orchestrComponent = scaHandler.createComponent(String.valueOf(proc.getName()) + "_orchestrationComponent");
            ComponentService orchestrService = scaHandler.createComponentService(orchestrComponent, proc.getName());
            compositeService.setPromote(orchestrService);
            for (Step step : proc.getSteps()) {
                Service procService = step.getServiceModel();
                String pServiceName = null;
                pServiceName = procService == null ? String.valueOf(step.getName()) + "_genService" : procService.getServiceName();
                Component scaComponent = scaHandler.createComponent(String.valueOf(step.getName()) + "_component");
                ComponentService scaService = scaHandler.createComponentService(scaComponent, pServiceName);
                ComponentReference scaRef = scaHandler.createComponentRef(orchestrComponent, String.valueOf(pServiceName) + "_ref");
                scaRef.getTarget().add((Object)scaService);
            }
        }
        try {
            URI scaURI = uri.trimFileExtension().appendFileExtension("composite");
            scaHandler.persistSCA(scaURI);
            container.refreshLocal(2, null);
        }
        catch (IOException e) {
            this.displayIMError("Could not save the SCA Composite file", e);
        }
        catch (CoreException e) {
            this.displayIMError("Could not refresh the workspace", e);
        }
    }

    private void displayIMError(String msg, Throwable t) {
        Status iStatus = null;
        iStatus = t != null ? new Status(4, "org.eclipse.stp.im.out.sca", t.getLocalizedMessage(), t) : new Status(4, "org.eclipse.stp.im.out.sca", msg);
        ErrorDialog.openError((Shell)this.shell, (String)"Intermediate Model Generation Error", (String)msg, (IStatus)iStatus);
    }
}

