/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.im.resources.IImResource;
import org.eclipse.stp.im.resources.IImResourceConfigurator;
import org.eclipse.stp.im.resources.IImResourceConfiguratorProxy;
import org.eclipse.stp.im.resources.IImResourceImporter;
import org.eclipse.stp.im.resources.IImResourceImporterProxy;
import org.eclipse.stp.im.resources.datasources.DataSourceImResource;
import org.eclipse.stp.im.util.ImLogger;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImResourcesActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.stp.im.resources";
    private static ImResourcesActivator plugin;
    private static Properties resourceProperties;
    private static Map<String, IImResourceImporterProxy> imResourceImportersProxies;
    private static List<String> imResourceImportersNames;
    private static Map<String, IImResourceImporter> imResourceImportersInstantiated;
    private static Map<String, IImResourceConfiguratorProxy> imResourceConfiguratorsProxies;
    private static List<String> imResourceConfiguratorsNames;
    private static Map<String, IImResourceConfigurator> imResourceConfiguratorsInstantiated;
    public static final String IM_RESOURCE_IMPORTER_TAG = "im-resource-importer";
    public static final String IM_RESOURCE_CONFIGURATOR_TAG = "im-resource-configurator";

    static {
        resourceProperties = null;
        imResourceImportersProxies = null;
        imResourceImportersNames = null;
        imResourceImportersInstantiated = null;
        imResourceConfiguratorsProxies = null;
        imResourceConfiguratorsNames = null;
        imResourceConfiguratorsInstantiated = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ImResourcesActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ImResourcesActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private static File getImResourcePropertiesFile() {
        IPath path = ImResourcesActivator.getDefault().getStateLocation();
        String imResourcesFileName = String.valueOf(path.toOSString()) + File.separator + "imresources.properties";
        File imResourcesFile = new File(imResourcesFileName);
        return imResourcesFile;
    }

    public static void loadResourceProperties() {
        block13: {
            File imResourcesFile = ImResourcesActivator.getImResourcePropertiesFile();
            resourceProperties = new Properties();
            if (!imResourcesFile.exists()) {
                return;
            }
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(imResourcesFile);
                    resourceProperties.load(fis);
                }
                catch (Exception e) {
                    ImLogger.error((String)PLUGIN_ID, (String)e.getMessage(), (Throwable)e);
                    if (fis == null) break block13;
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {
                        ImLogger.error((String)PLUGIN_ID, (String)ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {
                        ImLogger.error((String)PLUGIN_ID, (String)ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
        }
    }

    public static Properties getResourceProperties() {
        if (resourceProperties == null) {
            ImResourcesActivator.loadResourceProperties();
        }
        return resourceProperties;
    }

    public static void saveResourceProperties() {
        block13: {
            File imResourcesFile = ImResourcesActivator.getImResourcePropertiesFile();
            if (imResourcesFile.exists()) {
                imResourcesFile.delete();
            }
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(imResourcesFile);
                    resourceProperties.store(fos, "Andrea");
                }
                catch (Exception e) {
                    ImLogger.error((String)PLUGIN_ID, (String)e.getMessage(), (Throwable)e);
                    if (fos == null) break block13;
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {
                        ImLogger.error((String)PLUGIN_ID, (String)ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {
                        ImLogger.error((String)PLUGIN_ID, (String)ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
        }
    }

    public static void initImResourcesImportersProxy() {
        if (imResourceImportersProxies != null && imResourceImportersNames != null) {
            return;
        }
        try {
            IExtensionRegistry extensionPointRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionPointRegistry.getExtensionPoint(PLUGIN_ID, "imresourceimporter");
            IExtension[] extensions = extensionPoint.getExtensions();
            imResourceImportersProxies = new HashMap<String, IImResourceImporterProxy>();
            imResourceImportersNames = new ArrayList<String>();
            imResourceImportersInstantiated = new HashMap<String, IImResourceImporter>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IImResourceImporterProxy proxy = ImResourcesActivator.parseIImResourceImporterProxy(configElements[j]);
                    if (proxy != null) {
                        imResourceImportersProxies.put(proxy.getName(), proxy);
                        imResourceImportersNames.add(proxy.getName());
                    }
                    ++j;
                }
                ++i;
            }
            return;
        }
        catch (Throwable t) {
            ImLogger.error((String)PLUGIN_ID, (String)t.getMessage(), (Throwable)t);
            imResourceImportersProxies = null;
            imResourceImportersNames = null;
            return;
        }
    }

    public static void initImResourceConfiguratorsProxy() {
        if (imResourceConfiguratorsProxies != null && imResourceConfiguratorsNames != null) {
            return;
        }
        try {
            IExtensionRegistry extensionPointRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionPointRegistry.getExtensionPoint(PLUGIN_ID, "imresourceconfigurator");
            IExtension[] extensions = extensionPoint.getExtensions();
            imResourceConfiguratorsProxies = new HashMap<String, IImResourceConfiguratorProxy>();
            imResourceConfiguratorsNames = new ArrayList<String>();
            imResourceConfiguratorsInstantiated = new HashMap<String, IImResourceConfigurator>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IImResourceConfiguratorProxy proxy = ImResourcesActivator.parseIImResourceConfiguratorProxy(configElements[j]);
                    if (proxy != null) {
                        imResourceConfiguratorsProxies.put(proxy.getName(), proxy);
                        imResourceConfiguratorsNames.add(proxy.getName());
                    }
                    ++j;
                }
                ++i;
            }
            return;
        }
        catch (Throwable t) {
            ImLogger.error((String)PLUGIN_ID, (String)t.getMessage(), (Throwable)t);
            imResourceImportersProxies = null;
            imResourceImportersNames = null;
            return;
        }
    }

    private static IImResourceImporterProxy parseIImResourceImporterProxy(IConfigurationElement configElement) {
        if (!configElement.getName().equals(IM_RESOURCE_IMPORTER_TAG)) {
            return null;
        }
        try {
            return new IImResourceImporterProxy(configElement);
        }
        catch (Exception e) {
            ImLogger.error((String)PLUGIN_ID, (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static IImResourceConfiguratorProxy parseIImResourceConfiguratorProxy(IConfigurationElement configElement) {
        if (!configElement.getName().equals(IM_RESOURCE_CONFIGURATOR_TAG)) {
            return null;
        }
        try {
            return new IImResourceConfiguratorProxy(configElement);
        }
        catch (Exception e) {
            ImLogger.error((String)PLUGIN_ID, (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String[] getIImResourceImportersNames() {
        ImResourcesActivator.initImResourcesImportersProxy();
        String[] names = new String[imResourceImportersNames.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = imResourceImportersNames.get(i);
            ++i;
        }
        return names;
    }

    public static String[] getIImResourceConfiguratorsNames() {
        ImResourcesActivator.initImResourceConfiguratorsProxy();
        String[] names = new String[imResourceConfiguratorsNames.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = imResourceConfiguratorsNames.get(i);
            ++i;
        }
        return names;
    }

    public static IImResourceImporter getIImResourceImporterByName(String importerName) {
        ImResourcesActivator.initImResourcesImportersProxy();
        IImResourceImporter importer = imResourceImportersInstantiated.get(importerName);
        if (importer == null) {
            IImResourceImporterProxy proxy = imResourceImportersProxies.get(importerName);
            importer = proxy.getIImResourceImporter();
            imResourceImportersInstantiated.put(importerName, importer);
        }
        return importer;
    }

    public static IImResourceConfigurator getIImResourceConfiguratorByName(String configuratorName) {
        ImResourcesActivator.initImResourceConfiguratorsProxy();
        IImResourceConfigurator configurator = imResourceConfiguratorsInstantiated.get(configuratorName);
        if (configurator == null) {
            IImResourceConfiguratorProxy proxy = imResourceConfiguratorsProxies.get(configuratorName);
            configurator = proxy.getIImResourceConfigurator();
            imResourceConfiguratorsInstantiated.put(configuratorName, configurator);
        }
        return configurator;
    }

    public static void addDataSource(IImResource dsBean) {
        Properties props = ImResourcesActivator.getResourceProperties();
        String name = "im.datasource." + dsBean.getId();
        props.setProperty(name, dsBean.getId());
        props.setProperty(String.valueOf(name) + ".property.jdbcDriver", dsBean.getProperty(DataSourceImResource.DATASOURCE_DRIVER));
        props.setProperty(String.valueOf(name) + ".property.jdbcUrl", dsBean.getProperty(DataSourceImResource.DATASOURCE_URL));
        props.setProperty(String.valueOf(name) + ".property.jdbcUser", dsBean.getProperty(DataSourceImResource.DATASOURCE_USER));
        props.setProperty(String.valueOf(name) + ".property.jdbcPassword", dsBean.getProperty(DataSourceImResource.DATASOURCE_PASSWORD));
        ImResourcesActivator.saveResourceProperties();
    }

    public static void deleteDatasource(IImResource dsBean) {
        Properties props = ImResourcesActivator.getResourceProperties();
        String name = "im.datasource." + dsBean.getId();
        props.remove(name);
        props.remove(String.valueOf(name) + ".property.jdbcDriver");
        props.remove(String.valueOf(name) + ".property.jdbcUrl");
        props.remove(String.valueOf(name) + ".property.jdbcUser");
        props.remove(String.valueOf(name) + ".property.jdbcPassword");
        ImResourcesActivator.saveResourceProperties();
    }

    public static List<IImResource> getDataSources() {
        return ImResourcesActivator.getImResourcesWithType("datasource");
    }

    public static IImResource getImResourceByIdAndType(String resourceID, String resourceType) {
        Properties props = ImResourcesActivator.getResourceProperties();
        DataSourceImResource dsBean = null;
        String idDs = null;
        for (Object key : props.keySet()) {
            String name = (String)key;
            if (!name.startsWith("im." + resourceType + ".") || name.contains("property") || !(idDs = props.getProperty(name)).equals(resourceID)) continue;
            dsBean = new DataSourceImResource(props.getProperty(name));
            dsBean.setProperty(DataSourceImResource.DATASOURCE_DRIVER, props.getProperty(String.valueOf(name) + ".property.jdbcDriver"));
            dsBean.setProperty(DataSourceImResource.DATASOURCE_URL, props.getProperty(String.valueOf(name) + ".property.jdbcUrl"));
            dsBean.setProperty(DataSourceImResource.DATASOURCE_USER, props.getProperty(String.valueOf(name) + ".property.jdbcUser"));
            dsBean.setProperty(DataSourceImResource.DATASOURCE_PASSWORD, props.getProperty(String.valueOf(name) + ".property.jdbcPassword"));
            return dsBean;
        }
        return null;
    }

    public static List<IImResource> getImResourcesWithType(String resourceType) {
        Properties props = ImResourcesActivator.getResourceProperties();
        ArrayList<IImResource> resources = new ArrayList<IImResource>();
        DataSourceImResource dsBean = null;
        String idDs = null;
        for (Object key : props.keySet()) {
            String name = (String)key;
            if (!name.startsWith("im." + resourceType + ".") || name.contains("property")) continue;
            idDs = props.getProperty(name);
            if (!resourceType.equalsIgnoreCase("datasource")) continue;
            dsBean = new DataSourceImResource(props.getProperty(name));
            dsBean.setProperty(DataSourceImResource.DATASOURCE_DRIVER, props.getProperty(String.valueOf(name) + ".property.jdbcDriver"));
            dsBean.setProperty(DataSourceImResource.DATASOURCE_URL, props.getProperty(String.valueOf(name) + ".property.jdbcUrl"));
            dsBean.setProperty(DataSourceImResource.DATASOURCE_USER, props.getProperty(String.valueOf(name) + ".property.jdbcUser"));
            dsBean.setProperty(DataSourceImResource.DATASOURCE_PASSWORD, props.getProperty(String.valueOf(name) + ".property.jdbcPassword"));
            resources.add(dsBean);
        }
        return resources;
    }
}

