/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.runtime;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stp.im.BasicProperty;
import org.eclipse.stp.im.ImFactory;
import org.eclipse.stp.im.ImPackage;
import org.eclipse.stp.im.Process;
import org.eclipse.stp.im.Property;
import org.eclipse.stp.im.StpIntermediateModel;
import org.eclipse.stp.im.util.ImLogger;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class VersionImWorkspaceOperationAction
extends WorkspaceModifyOperation {
    private IFile imFile = null;
    private String newVersion = null;

    public IFile getImFile() {
        return this.imFile;
    }

    public void setImFile(IFile imFile) {
        this.imFile = imFile;
    }

    public VersionImWorkspaceOperationAction(IFile imFile, String newVersion) {
        this.imFile = imFile;
        this.newVersion = newVersion;
    }

    protected void execute(IProgressMonitor monitor) {
        try {
            ResourceSetImpl resourceSetIM = new ResourceSetImpl();
            ImFactory stpModelfactory = ImFactory.eINSTANCE;
            URI uri = URI.createPlatformResourceURI((String)this.imFile.getFullPath().toString(), (boolean)true);
            ImPackage imPackage = ImPackage.eINSTANCE;
            Resource resourceIM = resourceSetIM.getResource(uri, true);
            StpIntermediateModel im = (StpIntermediateModel)resourceIM.getContents().get(0);
            for (Process p : im.getProcessCollection().getProcesses()) {
                Property propertyVersion = (Property)p.getProperties().get((Object)"im.process.version");
                if (propertyVersion != null) {
                    ((BasicProperty)propertyVersion).setValue(this.newVersion);
                    continue;
                }
                propertyVersion = stpModelfactory.createBasicProperty();
                propertyVersion.setKey("im.process.version");
                ((BasicProperty)propertyVersion).setValue(this.newVersion);
                p.getProperties().put((Object)"im.process.version", (Object)propertyVersion);
            }
            resourceIM.save(Collections.EMPTY_MAP);
        }
        catch (Throwable e) {
            ImLogger.error((String)"Exception Versioning IM ", (Throwable)e);
            throw new RuntimeException("Exception Versioning IM", e);
        }
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(String newVersion) {
        this.newVersion = newVersion;
    }
}

