/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.tool.in.bpmneditor.dnd.handler;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.DataObject;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.NamedBpmnObject;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.TextAnnotation;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.dnd.AbstractEAnnotationDnDHandler;
import org.eclipse.stp.im.tool.in.bpmneditor.BpmnEditorExtensionActivator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RubberDndHandler
extends AbstractEAnnotationDnDHandler {
    public Command getDropCommand(IGraphicalEditPart hoverPart, int index, Point dropLocation) {
        EModelElement eModelElement = (EModelElement)hoverPart.resolveSemanticElement();
        EAnnotation ea = null;
        if (eModelElement.getEAnnotations().size() > 0) {
            ea = (EAnnotation)eModelElement.getEAnnotations().get(0);
        }
        CompoundCommand co = new CompoundCommand("Drop Annotation Command");
        if (ea != null) {
            if (eModelElement instanceof Pool && this.checkIMAnnotationsOnPoolContent((Pool)eModelElement)) {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Intermediate Model", (String)"Cannot Delete Pool Annotaion");
                return co;
            }
            if (eModelElement.getEAnnotation(ea.getSource()) != null) {
                co.add((Command)new ICommandProxy(this.deleteAnnotation(eModelElement, ea)));
            }
        }
        return co;
    }

    private ICommand deleteAnnotation(EModelElement selectedElt, EAnnotation ea) {
        if (selectedElt.getEAnnotation(ea.getSource()) != null) {
            DestroyElementRequest request = new DestroyElementRequest((EObject)selectedElt.getEAnnotation(ea.getSource()), true);
            DestroyElementCommand command = new DestroyElementCommand(request);
            return command;
        }
        return null;
    }

    public int getItemCount() {
        return 1;
    }

    public Image getMenuItemImage(IGraphicalEditPart hoverPart, int index) {
        return BpmnEditorExtensionActivator.getImageDescriptor("icons/ico_condition.gif").createImage();
    }

    public String getMenuItemLabel(IGraphicalEditPart hoverPart, int index) {
        EObject element = hoverPart.resolveSemanticElement();
        String suffix = " on " + this.getShapeLabel((NamedBpmnObject)element);
        return "Delete Annotation on " + suffix;
    }

    public int getPriority() {
        return 0;
    }

    protected String getShapeLabel(NamedBpmnObject namedElement) {
        String name;
        String string = name = namedElement.getName() != null && namedElement.getName().length() > 0 ? namedElement.getName() : "";
        if (name.length() > 18) {
            name = String.valueOf(name.substring(0, 12)) + "...";
        }
        if (namedElement instanceof Pool) {
            if (name.indexOf("pool") == -1) {
                return "pool " + name;
            }
            return name;
        }
        if (namedElement instanceof Activity) {
            String shape = ((Activity)namedElement).getActivityType().getLiteral();
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof MessagingEdge) {
            String shape = "message";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof SequenceEdge) {
            String shape = "sequence";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof Diagram) {
            String shape = "diagram";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof TextAnnotation) {
            String shape = "annotation";
            if (name.indexOf(shape) == -1) {
                return "text " + shape + " " + name;
            }
            return name;
        }
        if (namedElement instanceof DataObject) {
            String shape = "object";
            if (name.indexOf(shape) == -1) {
                return "data " + shape + " " + name;
            }
            return name;
        }
        return name;
    }

    public boolean isEnabled(IGraphicalEditPart hoverPart, int index) {
        EModelElement emodelElement = (EModelElement)hoverPart.resolveSemanticElement();
        return emodelElement instanceof SequenceEdge || emodelElement instanceof MessagingEdge || emodelElement instanceof Activity || emodelElement instanceof Pool;
    }

    public boolean checkIMAnnotationsOnPoolContent(Pool aPool) {
        for (Vertex aVertex : aPool.getVertices()) {
            if (aVertex.getEAnnotation("im") == null && aVertex.getEAnnotation("imtransition") == null && aVertex.getEAnnotation("imobsattribute") == null) continue;
            return true;
        }
        for (SequenceEdge seqEdge : aPool.getSequenceEdges()) {
            if (seqEdge.getEAnnotation("im") == null && seqEdge.getEAnnotation("imtransition") == null && seqEdge.getEAnnotation("imobsattribute") == null) continue;
            return true;
        }
        for (Artifact artifact : aPool.getArtifacts()) {
            if (artifact.getEAnnotation("im") == null && artifact.getEAnnotation("imtransition") == null && artifact.getEAnnotation("imobsattribute") == null) continue;
            return true;
        }
        return false;
    }
}

