/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.tool.in.bpmneditor.dnd.handler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.stp.bpmn.dnd.file.FileDnDHandler;
import org.eclipse.stp.bpmn.properties.ModifyBpmnEAnnotationCommand;
import org.eclipse.stp.im.runtime.IRuntime;
import org.eclipse.stp.im.runtime.ImRuntimeActivator;

public class WorkbenchFileDndHandler
extends FileDnDHandler {
    protected IResource myFile = null;

    public WorkbenchFileDndHandler(IResource f) {
        super(f);
        this.myFile = f;
    }

    public Command getDropCommand(IGraphicalEditPart hoverPart, int index, Point dropLocation) {
        HashMap details = new HashMap();
        CompoundCommand co = new CompoundCommand("Setting the pool to be executable");
        EModelElement eModelElement = (EModelElement)hoverPart.resolveSemanticElement();
        final String nameOfPropertyMatch = this.getNameOfPropertyMatch(eModelElement);
        if (nameOfPropertyMatch != null) {
            final EAnnotation ea = (EAnnotation)eModelElement.getEAnnotations().get(0);
            ModifyBpmnEAnnotationCommand modifyCommand = new ModifyBpmnEAnnotationCommand(ea, "Modifying BPMN property"){

                protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
                    ea.getDetails().put((Object)nameOfPropertyMatch, (Object)WorkbenchFileDndHandler.this.myFile.getProjectRelativePath().toString());
                    return CommandResult.newOKCommandResult();
                }
            };
            co.add((Command)new ICommandProxy((ICommand)modifyCommand));
        }
        return co;
    }

    public String getNameOfPropertyMatch(EModelElement eModelElement) {
        EAnnotation ea;
        if (eModelElement.getEAnnotations().size() > 0 && (ea = (EAnnotation)eModelElement.getEAnnotations().get(0)).getSource().equalsIgnoreCase("im")) {
            String runtimeId = (String)ea.getDetails().get((Object)"im.pool.runtimeID");
            IRuntime runtime = ImRuntimeActivator.getRuntime((String)runtimeId);
            Map matchingDnDProperties = runtime.getDnDMatchingProperties();
            String filePath = this.myFile.getProjectRelativePath().toString();
            String fileExt = filePath.substring(filePath.lastIndexOf(".") + 1);
            String destinationPropertyNameForFileExt = (String)matchingDnDProperties.get(fileExt);
            if (ea.getDetails().get((Object)destinationPropertyNameForFileExt) != null) {
                return destinationPropertyNameForFileExt;
            }
        }
        return null;
    }

    public String getMenuItemLabel(IGraphicalEditPart hoverPart, int index) {
        EModelElement eModelElement = (EModelElement)hoverPart.resolveSemanticElement();
        String path = this.myFile.getProjectRelativePath().lastSegment().toString();
        String nameOfPopertyMatch = this.getNameOfPropertyMatch(eModelElement);
        return nameOfPopertyMatch != null ? "Fill property (" + nameOfPopertyMatch + ") with this file (" + path + ") on Property " : "No Property Matching";
    }

    public int getPriority() {
        return 1;
    }

    public boolean isEnabled(IGraphicalEditPart hoverPart, int index) {
        EModelElement eModelElement = (EModelElement)hoverPart.resolveSemanticElement();
        String nameOfPopertyMatch = this.getNameOfPropertyMatch(eModelElement);
        return nameOfPopertyMatch != null;
    }
}

