/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.common.utils;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.stp.policy.wtp.common.utils.BaseException;
import org.eclipse.stp.policy.wtp.common.utils.NamespaceResolver;
import org.eclipse.stp.policy.wtp.common.utils.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class DOMProvider {
    private static final Logger log = Logger.getLogger(DOMProvider.class);
    public static final String ENCODING = "UTF-8";
    private static DocumentBuilder theDocumentBuilder = null;
    private static XPathFactory xPathFactory = null;
    private final Map mapCompiledXPath = new HashMap();
    private Document theDocument = null;
    private NamespaceResolver resolver = null;

    public DOMProvider() throws BaseException {
        this.theDocument = DOMProvider.getDocumentBuilder().newDocument();
        this.resolver = new NamespaceResolver(this.theDocument);
    }

    public DOMProvider(InputStream stream) throws BaseException {
        this.init(stream);
        this.resolver = new NamespaceResolver(this.theDocument);
    }

    public DOMProvider(File file) throws BaseException {
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(file);
                this.init(stream);
            }
            catch (FileNotFoundException e) {
                throw new BaseException(e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new BaseException(e);
                }
            }
        }
        this.resolver = new NamespaceResolver(this.theDocument);
    }

    public DOMProvider(Document document) {
        this.theDocument = document;
        this.resolver = new NamespaceResolver(this.theDocument);
    }

    public Document getDocument() throws DOMException {
        if (this.theDocument == null) {
            throw new DOMException(11, "Document not instantiated, aborting.");
        }
        return this.theDocument;
    }

    public void setDocument(Document newDocument) {
        this.theDocument = newDocument;
        this.resolver = new NamespaceResolver(this.theDocument);
    }

    private void init(InputStream stream) throws BaseException {
        try {
            this.theDocument = DOMProvider.getDocumentBuilder().parse(stream);
        }
        catch (Exception e) {
            String msg = "Could not instantiate DocumentBuilder.";
            log.fatal((Object)msg, (Throwable)e);
            msg = String.valueOf(msg) + " Reason:\n" + e.getMessage();
            throw new BaseException(msg, e);
        }
    }

    public void normalizeSchemaNamespaces(Element rootElement) throws IllegalArgumentException {
        if (!rootElement.getOwnerDocument().equals(this.theDocument)) {
            throw new IllegalArgumentException("The input context has different owner document");
        }
        log.debug((Object)("Performing normalization, the root element is: [" + rootElement + "]"));
        NamespaceResolver nsr = new NamespaceResolver(this.theDocument);
        nsr.setContext(rootElement);
        NodeList childNodes = rootElement.getChildNodes();
        int childNumber = childNodes.getLength();
        int i = 0;
        while (i < childNumber) {
            Node childNode = childNodes.item(i);
            if (1 == childNode.getNodeType()) {
                this.normalizeSchemaElementNamespaces((Element)childNode, nsr, new HashMap());
            }
            ++i;
        }
    }

    private void normalizeSchemaElementNamespaces(Element contextElement, NamespaceResolver nsr, Map replacementMap) {
        HashMap namespaces = new HashMap();
        NamespaceResolver.reloadMappings(namespaces, contextElement);
        Iterator mapIt = namespaces.entrySet().iterator();
        String elemPrefix = contextElement.getPrefix();
        if (elemPrefix == null) {
            elemPrefix = "";
        }
        while (mapIt.hasNext()) {
            Map.Entry entry = mapIt.next();
            String mappedPrefix = (String)entry.getKey();
            String mappedURI = (String)entry.getValue();
            String parentPrefix = nsr.getPrefix(mappedURI);
            if (parentPrefix != null) {
                if (parentPrefix.compareTo(mappedPrefix) == 0) continue;
                replacementMap.put(mappedPrefix, parentPrefix);
                continue;
            }
            String newPrefix = nsr.allocatePrefix(mappedURI);
            ((Element)nsr.getContext()).setAttribute("xmlns:" + newPrefix, mappedURI);
            replacementMap.put(mappedPrefix, newPrefix);
        }
        String remappedPrefix = null;
        remappedPrefix = (String)replacementMap.get(elemPrefix);
        if (remappedPrefix != null) {
            contextElement.setPrefix(remappedPrefix);
        }
        Vector<String> vecUnneededPrefixes = new Vector<String>();
        NamedNodeMap attrMap = contextElement.getAttributes();
        int attrCount = attrMap.getLength();
        int i = 0;
        while (i < attrCount) {
            Attr attrObj = (Attr)attrMap.item(i);
            String attrName = attrObj.getName();
            if (!attrName.startsWith("xmlns:") && attrName.compareTo("xmlns") != 0) {
                String attrPrefix = attrObj.getPrefix();
                remappedPrefix = (String)replacementMap.get(attrPrefix);
                if (remappedPrefix != null) {
                    attrObj.setPrefix(remappedPrefix);
                }
            } else {
                vecUnneededPrefixes.add(attrName);
            }
            if (attrName.compareTo("base") == 0 || attrName.compareTo("type") == 0 || attrName.compareTo("ref") == 0) {
                String refValue = attrObj.getValue();
                String refLocalName = StringUtils.getLocalForColonizedName(refValue);
                String refLocalPrefix = StringUtils.getPrefixForColonizedName(refValue);
                if (refLocalPrefix == null) {
                    refLocalPrefix = "";
                }
                if ((remappedPrefix = (String)replacementMap.get(refLocalPrefix)) != null) {
                    if (remappedPrefix.length() == 0) {
                        attrObj.setValue(refLocalName);
                    } else {
                        attrObj.setValue(String.valueOf(remappedPrefix) + ":" + refLocalName);
                    }
                }
            }
            ++i;
        }
        for (String prefixAttrName : vecUnneededPrefixes) {
            contextElement.removeAttribute(prefixAttrName);
        }
        NodeList childNodes = contextElement.getChildNodes();
        int childNumber = childNodes.getLength();
        int i2 = 0;
        while (i2 < childNumber) {
            Node childNode = childNodes.item(i2);
            if (1 == childNode.getNodeType()) {
                HashMap replacementMapCopy = new HashMap();
                replacementMapCopy.putAll(replacementMap);
                this.normalizeSchemaElementNamespaces((Element)childNode, nsr, replacementMapCopy);
            }
            ++i2;
        }
    }

    private static DocumentBuilder getDocumentBuilder() throws BaseException {
        if (theDocumentBuilder == null) {
            DOMProvider.initDocumentBuilder();
        }
        return theDocumentBuilder;
    }

    private static void initDocumentBuilder() throws BaseException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            theDocumentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.fatal((Object)"Could not instantiate DocumentBuilder");
            throw new BaseException("Could not instantiate DocumentBuilder", e);
        }
    }

    public void serialize(Writer writer) {
        try {
            DOMProvider.serialize(this.theDocument, writer);
        }
        catch (BaseException e) {
            log.error((Object)"Unexpected exception when serializing document", (Throwable)e);
        }
    }

    public void serialize(OutputStream stream) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(stream, ENCODING));
        try {
            DOMProvider.serialize(this.theDocument, out);
        }
        catch (BaseException e) {
            log.error((Object)"Unexpected exception when serializing document", (Throwable)e);
        }
    }

    public String toString() {
        String ret = super.toString();
        if (log.isDebugEnabled()) {
            ret = String.valueOf(ret) + "\nContents:\n" + this.getDocumentAsString();
        }
        return ret;
    }

    public String getDocumentAsString() {
        String ret = null;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            this.serialize(outStream);
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            ret = StringUtils.getStringFromStream(inStream);
        }
        catch (IOException e) {
            ret = "not available. Reason:\n" + e.getMessage();
        }
        return ret;
    }

    public String getTargetNamespace() {
        String targetNS = this.theDocument.getDocumentElement().getAttribute("targetNamespace");
        return targetNS;
    }

    public Attr createAttributeWithNamespace(String uri, String attrName, boolean createMappingIfNeeded) throws TransformerException {
        Attr attr = this.theDocument.createAttributeNS(uri, attrName);
        String prefix = this.resolver.getPrefix(uri);
        if (prefix == null && createMappingIfNeeded && (prefix = NamespaceResolver.getPrefixForDefaultNamespace(uri)) != null) {
            this.theDocument.getDocumentElement().setAttribute("xmlns:" + prefix, uri);
        }
        if (prefix == null) {
            throw new TransformerException("The URI [" + uri + "] has no available mapping");
        }
        if (prefix.compareTo("") != 0) {
            attr.setPrefix(prefix);
        }
        return attr;
    }

    public void renameNamespace(String namespaceURI, String updatedURI) throws TransformerException {
        try {
            NodeList itNSReferences = this.getMultiXPathResult("//namespace::*[string(.) = '" + namespaceURI + "']");
            int index = 0;
            while (index < itNSReferences.getLength()) {
                Node refNode = itNSReferences.item(index);
                refNode.setNodeValue(updatedURI);
                ++index;
            }
        }
        catch (TransformerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransformerException("Unexpected problem while patching all URI references: " + e.getMessage(), e);
        }
        this.resolver.setContext(this.theDocument.getDocumentElement());
    }

    public Element createElementWithNamespace(String uri, String elementName, boolean createMappingIfNeeded) throws TransformerException {
        Element elem = null;
        elem = this.theDocument.createElementNS(uri, elementName);
        String prefix = this.getPrefixForNamespace(uri);
        if (prefix == null && createMappingIfNeeded && (prefix = this.resolver.allocatePrefix(uri)) != null) {
            this.theDocument.getDocumentElement().setAttribute("xmlns:" + prefix, uri);
        }
        if (prefix == null) {
            throw new TransformerException("The URI [" + uri + "] has no available mapping");
        }
        if (prefix.compareTo("") != 0) {
            elem.setPrefix(prefix);
        }
        return elem;
    }

    public String getXPath(Node node) {
        StringBuffer buf = new StringBuffer("");
        while (node != null) {
            StringBuffer fragment = null;
            if (node instanceof Element) {
                fragment = this.computeXPathFragment((Element)node);
                node = node.getParentNode();
            } else if (node instanceof Attr) {
                fragment = this.computeXPathFragment((Attr)node);
                node = ((Attr)node).getOwnerElement();
            } else {
                node = node.getParentNode();
            }
            if (fragment == null) continue;
            buf.insert(0, fragment);
        }
        return new String(buf);
    }

    private StringBuffer computeXPathFragment(Attr at) {
        StringBuffer ret = new StringBuffer("/@").append(at.getNodeName());
        return ret;
    }

    private StringBuffer computeXPathFragment(Element el) {
        StringBuffer ret = new StringBuffer("");
        Node node = el;
        int num = 1;
        String localName = el.getLocalName();
        String prefixName = el.getPrefix();
        String namespaceURI = null;
        if (prefixName == null) {
            prefixName = "";
        }
        namespaceURI = this.resolver.getNamespaceURI(prefixName, el);
        while ((node = node.getPreviousSibling()) != null) {
            Node similarElem;
            if (!(node instanceof Element) || localName.compareTo((similarElem = node).getLocalName()) != 0) continue;
            String similarElemPrefix = similarElem.getPrefix();
            if (similarElemPrefix == null) {
                similarElemPrefix = "";
            }
            if (prefixName.compareTo(similarElemPrefix) != 0 && (namespaceURI == null || namespaceURI.compareTo(this.resolver.getNamespaceURI(similarElemPrefix, similarElem)) != 0)) continue;
            ++num;
        }
        ret.append("/");
        if (namespaceURI != null) {
            String resolvedPrefix = NamespaceResolver.getPrefixForDefaultNamespace(namespaceURI);
            ret.append(resolvedPrefix != null ? resolvedPrefix : prefixName);
            ret.append(":");
        }
        ret.append(localName);
        ret.append("[");
        ret.append(num);
        ret.append("]");
        return ret;
    }

    public boolean documentEquals(Document document) {
        boolean ret = true;
        if (this.theDocument != null && document != null) {
            this.theDocument.normalize();
            document.normalize();
            NodeIterator myIt = ((DocumentTraversal)((Object)this.theDocument)).createNodeIterator(this.theDocument, -1, null, true);
            NodeIterator hisIt = ((DocumentTraversal)((Object)this.theDocument)).createNodeIterator(document, -1, null, true);
            Node myNode = myIt.nextNode();
            Node hisNode = hisIt.nextNode();
            while (ret && myNode != null) {
                ret = false;
                if (hisNode != null && myNode.getNodeType() == hisNode.getNodeType()) {
                    if (myNode instanceof Element && !(ret = DOMProvider.compareAttributes((Element)myNode, (Element)hisNode))) break;
                    String myVal = myNode.getNodeValue();
                    String hisVal = hisNode.getNodeValue();
                    if (myVal != null && hisVal != null) {
                        ret = myVal.trim().equals(hisVal.trim());
                    } else {
                        boolean bl = ret = myVal == null && hisVal == null;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("equals : source : " + myNode.getNodeType() + ":" + myNode.getNodeName() + "? " + ret));
                    }
                }
                myNode = myIt.nextNode();
                hisNode = hisIt.nextNode();
            }
        } else {
            ret = this.theDocument == null && document == null;
            log.debug((Object)("equals : both docs null? " + ret));
        }
        return ret;
    }

    private static boolean compareAttributes(Element myNode, Element hisNode) {
        boolean ret = true;
        NamedNodeMap map = myNode.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Attr att = (Attr)map.item(i);
            ret = att.getValue().equals(hisNode.getAttribute(att.getName()));
            ++i;
        }
        ret = ret && map.getLength() == hisNode.getAttributes().getLength();
        return ret;
    }

    private static void serialize(Document doc, Writer out) throws BaseException {
        OutputFormat format = new OutputFormat(doc);
        format.setEncoding(ENCODING);
        format.setLineSeparator("\r\n");
        format.setLineWidth(65);
        format.setIndenting(true);
        format.setIndent(2);
        format.setPreserveSpace(false);
        XMLSerializer serializer = new XMLSerializer(out, format);
        try {
            serializer.asDOMSerializer();
            serializer.serialize(doc);
            out.close();
        }
        catch (IOException e) {
            String msg = "Could not serialize doc";
            log.debug((Object)msg, (Throwable)e);
            throw new BaseException(msg, e);
        }
    }

    public Node addNodeByXPath(String xpath, Element nextSibling) throws TransformerException {
        String head;
        Node parent;
        Node ret = null;
        if (!xpath.startsWith("/")) {
            throw new TransformerException("XPath must start at root element");
        }
        int split = xpath.lastIndexOf(47);
        String tail = xpath.substring(split + 1);
        if ("text()".equals(tail)) {
            xpath = xpath.substring(0, split);
            split = xpath.lastIndexOf(47);
            tail = xpath.substring(split + 1);
        }
        if ((parent = this.getSingleXPathResult(head = xpath.substring(0, split))) == null) {
            parent = this.addNodeByXPath(head, nextSibling);
        }
        if (parent == null || !(parent instanceof Element)) {
            throw new TransformerException("Could not create element for XPath " + head);
        }
        int paren = tail.lastIndexOf(91);
        String attDef = null;
        if (paren != -1) {
            attDef = tail.substring(paren + 1, tail.length() - 1);
            tail = tail.substring(0, paren);
        }
        ret = this.addSingleNode((Element)parent, nextSibling, tail);
        if (attDef != null) {
            this.addAttribute(ret, attDef);
        }
        return ret;
    }

    private void addAttribute(Node ret, String attDef) throws TransformerException {
        if (!(ret instanceof Element)) {
            throw new TransformerException("Cannot add attribute to non-element: " + attDef);
        }
        if (!attDef.matches("@\\w+=\"[A-Za-z0-9:_.]*\"") && !attDef.matches("\"[A-Za-z0-9:_.]*\"=@\\w+")) {
            throw new TransformerException("Malformed attribute definition: " + attDef);
        }
        String name = null;
        String val = null;
        String[] defs = attDef.split("=");
        if (defs[0].startsWith("\"")) {
            val = defs[0].substring(1, defs[0].length() - 1);
            name = defs[1];
        } else if (defs[1].startsWith("\"")) {
            val = defs[1].substring(1, defs[1].length() - 1);
            name = defs[0];
        } else {
            throw new TransformerException("Malformed attribute definition: " + attDef);
        }
        Node test = this.addSingleNode((Element)ret, null, name);
        if (!(test instanceof Attr)) {
            throw new TransformerException("Could not create attribute with name " + name + " for def " + attDef);
        }
        ((Attr)test).setValue(val);
    }

    public Node addNodeByXPath(String xpath) throws TransformerException {
        return this.addNodeByXPath(xpath, (Element)null);
    }

    public Node addNodeByXPath(String xpath, String nextSiblingPath) throws TransformerException {
        Node nextSibling = this.getSingleXPathResult(nextSiblingPath);
        if (!(nextSibling instanceof Element)) {
            throw new TransformerException("XPath result is not an Element: " + nextSiblingPath);
        }
        return this.addNodeByXPath(xpath, (Element)nextSibling);
    }

    private Node addSingleNode(Element parent, Element nextSibling, String tail) {
        Node ret = null;
        if (tail.startsWith("@")) {
            tail = tail.substring(1);
            ret = this.theDocument.createAttribute(tail);
            parent.setAttributeNode((Attr)ret);
        } else {
            ret = this.theDocument.createElement(tail);
            parent.insertBefore(ret, nextSibling);
        }
        return ret;
    }

    public String getNamespaceForPrefix(String prefix) {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.getNamespaceURI(prefix);
    }

    public String getPrefixForNamespace(String namespace) {
        if (this.resolver == null) {
            return null;
        }
        this.resolver.setContext(this.theDocument.getDocumentElement());
        return this.resolver.getPrefix(namespace);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.resolver;
    }

    public Node getSingleXPathResult(String xpath) throws TransformerException {
        Node node = this.getSingleXPathResult(this.theDocument.getDocumentElement(), xpath);
        return node;
    }

    public Node getSingleXPathResult(Node context, String xpath) throws TransformerException {
        Node node = null;
        XPathExpression xPathExpression = this.getXPathExpression(context, xpath);
        try {
            Object obj = xPathExpression.evaluate(context, XPathConstants.NODE);
            if (obj instanceof Node) {
                node = (Node)obj;
            } else if (obj != null) {
                throw new TransformerException("Wrong Object type returned as result of expression evaluation : " + obj.getClass().toString());
            }
        }
        catch (XPathExpressionException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new TransformerException(e);
        }
        return node;
    }

    public NodeList getMultiXPathResult(String xpath) throws TransformerException {
        return this.getMultiXPathResult(this.theDocument.getDocumentElement(), xpath);
    }

    public NodeList getMultiXPathResult(Node context, String xpath) throws TransformerException {
        NodeList nl = null;
        XPathExpression xPathExpression = this.getXPathExpression(context, xpath);
        try {
            Object obj = xPathExpression.evaluate(context, XPathConstants.NODESET);
            if (!(obj instanceof NodeList)) {
                throw new TransformerException("Wrong Object type returned as result of expression evaluation : " + obj.getClass().toString());
            }
            nl = (NodeList)obj;
        }
        catch (XPathExpressionException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new TransformerException(e);
        }
        return nl;
    }

    private static XPathFactory getXPathFactory() {
        if (xPathFactory == null) {
            xPathFactory = XPathFactory.newInstance();
        }
        return xPathFactory;
    }

    private static XPath getNewXPath() {
        XPath xPath = DOMProvider.getXPathFactory().newXPath();
        return xPath;
    }

    private Element getNodeContextElement(Node contextNode) {
        Element contextElem = null;
        contextElem = contextNode instanceof Element ? (Element)contextNode : (contextNode != null ? contextNode.getOwnerDocument().getDocumentElement() : this.theDocument.getDocumentElement());
        return contextElem;
    }

    private XPathExpression getXPathExpression(Node nodeContext, String xPath) throws TransformerException {
        XPathExpression xPathExpression = (XPathExpression)this.mapCompiledXPath.get(xPath);
        if (xPathExpression == null) {
            XPath xPathObj = DOMProvider.getNewXPath();
            Element contextElement = this.getNodeContextElement(nodeContext);
            this.resolver.setContext(contextElement);
            xPathObj.setNamespaceContext(this.resolver);
            try {
                xPathExpression = xPathObj.compile(xPath);
                this.mapCompiledXPath.put(xPath, xPathExpression);
            }
            catch (XPathExpressionException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new TransformerException(e);
            }
        }
        return xPathExpression;
    }
}

