/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.stp.policy.wtp.common.utils.BaseException;
import org.eclipse.stp.policy.wtp.common.utils.StringUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DOMProviderBase {
    public static final String ENCODING = "UTF-8";
    private static DocumentBuilder theDocumentBuilder = null;
    private Document theDocument = null;

    public DOMProviderBase() throws BaseException {
        this.theDocument = DOMProviderBase.getDocumentBuilder().newDocument();
    }

    public DOMProviderBase(InputStream stream) throws BaseException {
        this.init(stream);
    }

    public DOMProviderBase(Reader reader) throws BaseException {
        this.init(reader);
    }

    public DOMProviderBase(File file) throws BaseException {
        this.init(file);
    }

    public DOMProviderBase(Document document) {
        this.theDocument = document;
    }

    public Document getDocument() throws DOMException {
        if (this.theDocument == null) {
            throw new DOMException(11, "Document not instantiated, aborting.");
        }
        return this.theDocument;
    }

    private void init(Reader reader) throws BaseException {
        try {
            InputSource source = new InputSource(reader);
            this.theDocument = DOMProviderBase.getDocumentBuilder().parse(source);
            reader.close();
        }
        catch (Exception e) {
            this.throwBaseException(e);
        }
    }

    private void init(InputStream stream) throws BaseException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, ENCODING);
            this.init(reader);
        }
        catch (UnsupportedEncodingException e) {
            this.throwBaseException(e);
        }
    }

    private void init(File file) throws BaseException {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), ENCODING);
            this.init(reader);
        }
        catch (UnsupportedEncodingException e) {
            this.throwBaseException(e);
        }
        catch (FileNotFoundException e) {
            this.throwBaseException(e);
        }
    }

    private void throwBaseException(Exception e) throws BaseException {
        throw new BaseException("Could not instantiate DocumentBuilder. Reason:\n" + e.getMessage(), e);
    }

    private static DocumentBuilder getDocumentBuilder() throws BaseException {
        if (theDocumentBuilder == null) {
            DOMProviderBase.initDocumentBuilder();
        }
        return theDocumentBuilder;
    }

    private static void initDocumentBuilder() throws BaseException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            theDocumentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new BaseException("Could not instantiate DocumentBuilder", e);
        }
    }

    public void serialize(Writer writer) throws BaseException {
        DOMProviderBase.serialize(this.theDocument, writer);
    }

    public void serialize(OutputStream stream) throws BaseException {
        DOMProviderBase.serialize(this.theDocument, stream);
    }

    public InputStream serialize() throws BaseException {
        ByteArrayOutputStream streamOut = new ByteArrayOutputStream();
        DOMProviderBase.serialize(this.theDocument, streamOut);
        ByteArrayInputStream streamIn = new ByteArrayInputStream(streamOut.toByteArray());
        return streamIn;
    }

    public String toString() {
        String ret = super.toString();
        ret = String.valueOf(ret) + "\nContents:\n" + this.getDocumentAsString();
        return ret;
    }

    public String getDocumentAsString() {
        String ret = null;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            this.serialize(outStream);
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            ret = StringUtils.getStringFromStream(inStream);
        }
        catch (BaseException e) {
            ret = "not available. Reason:\n" + e.getMessage();
        }
        return ret;
    }

    private static void serialize(Document doc, Writer out) throws BaseException {
        XMLSerializer serializer = new XMLSerializer(out, DOMProviderBase.getOutputFormat(doc));
        try {
            serializer.asDOMSerializer();
            serializer.serialize(doc);
            out.close();
        }
        catch (IOException e) {
            throw new BaseException("Could not serialize doc", e);
        }
    }

    private static void serialize(Document doc, OutputStream out) throws BaseException {
        XMLSerializer serializer = new XMLSerializer(out, DOMProviderBase.getOutputFormat(doc));
        try {
            serializer.asDOMSerializer();
            serializer.serialize(doc);
            out.close();
        }
        catch (IOException e) {
            throw new BaseException("Could not serialize doc", e);
        }
    }

    private static OutputFormat getOutputFormat(Document doc) {
        OutputFormat format = new OutputFormat(doc);
        format.setEncoding(ENCODING);
        format.setLineSeparator("\r\n");
        format.setLineWidth(80);
        format.setIndenting(true);
        format.setIndent(2);
        format.setPreserveSpace(false);
        return format;
    }

    public Element createElement(Element parentElement, QName elementName) {
        Element element = this.getDocument().createElementNS(elementName.getNamespaceURI(), this.getDOMName(elementName, parentElement));
        if (parentElement != null) {
            parentElement.appendChild(element);
        } else {
            this.getDocument().appendChild(element);
        }
        return element;
    }

    public void setAttribute(Element element, QName attributeName, String attributeValue) {
        String domAttributeName = this.getDOMName(attributeName, element);
        if (attributeValue == null || attributeValue.equals("")) {
            element.removeAttribute(domAttributeName);
        } else {
            element.setAttribute(domAttributeName, attributeValue);
        }
    }

    private String getDOMName(QName name, Element contextElemet) {
        String domName;
        String namespace = name.getNamespaceURI();
        if (namespace != null) {
            String prefix = this.getPrefixForNamespace(contextElemet, namespace);
            if (prefix == null) {
                prefix = name.getPrefix();
                Element namespaceOwnerElement = this.getNamespaceOwnerElement(contextElemet);
                if (namespaceOwnerElement != null) {
                    namespaceOwnerElement.setAttribute("xmlns:" + prefix, namespace);
                }
            }
            domName = prefix.length() != 0 ? String.valueOf(prefix) + ':' + name.getLocalPart() : name.getLocalPart();
        } else {
            domName = name.getLocalPart();
        }
        return domName;
    }

    public Element getNamespaceOwnerElement(Element contextElemet) {
        Element namespaceOwnerElement = this.getDocument().getDocumentElement();
        return namespaceOwnerElement;
    }

    private String getPrefixForNamespace(Element contextElememt, String namespaceURI) {
        String prefix = null;
        if (contextElememt != null) {
            Node parentElement;
            NamedNodeMap attributes = contextElememt.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                if (namespaceURI.equals(attribute.getNodeValue())) {
                    String attributeName = attribute.getNodeName();
                    if (attributeName.startsWith("xmlns:")) {
                        prefix = attributeName.substring("xmlns:".length());
                    } else if (attributeName.equals("xmlns")) {
                        prefix = "";
                    }
                    if (prefix != null) break;
                }
                ++i;
            }
            if (prefix == null && (parentElement = contextElememt.getParentNode()) != null && parentElement.getNodeType() == 1) {
                prefix = this.getPrefixForNamespace((Element)parentElement, namespaceURI);
            }
        }
        return prefix;
    }
}

