/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.common.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.eclipse.stp.policy.wtp.common.utils.NamespaceResolver;
import org.eclipse.stp.policy.wtp.common.utils.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathHelper {
    private static final Logger log = Logger.getLogger(XPathHelper.class);
    private static XPathFactory xPathFactory = null;
    private final Map mapCompiledXPath = new HashMap();
    private NamespaceResolver resolver = null;
    private Document document;

    public XPathHelper(Document document) {
        this.document = document;
        this.resolver = new NamespaceResolver(document);
    }

    public void normalizeSchemaNamespaces(Element rootElement) throws IllegalArgumentException {
        if (!rootElement.getOwnerDocument().equals(this.document)) {
            throw new IllegalArgumentException("The input context has different owner document");
        }
        log.debug((Object)("Performing normalization, the root element is: [" + rootElement + "]"));
        NamespaceResolver nsr = new NamespaceResolver(this.document);
        nsr.setContext(rootElement);
        NodeList childNodes = rootElement.getChildNodes();
        int childNumber = childNodes.getLength();
        int i = 0;
        while (i < childNumber) {
            Node childNode = childNodes.item(i);
            if (1 == childNode.getNodeType()) {
                this.normalizeSchemaElementNamespaces((Element)childNode, nsr, new HashMap());
            }
            ++i;
        }
    }

    private void normalizeSchemaElementNamespaces(Element contextElement, NamespaceResolver nsr, Map replacementMap) {
        HashMap namespaces = new HashMap();
        NamespaceResolver.reloadMappings(namespaces, contextElement);
        Iterator mapIt = namespaces.entrySet().iterator();
        String elemPrefix = contextElement.getPrefix();
        if (elemPrefix == null) {
            elemPrefix = "";
        }
        while (mapIt.hasNext()) {
            Map.Entry entry = mapIt.next();
            String mappedPrefix = (String)entry.getKey();
            String mappedURI = (String)entry.getValue();
            String parentPrefix = nsr.getPrefix(mappedURI);
            if (parentPrefix != null) {
                if (parentPrefix.compareTo(mappedPrefix) == 0) continue;
                replacementMap.put(mappedPrefix, parentPrefix);
                continue;
            }
            String newPrefix = nsr.allocatePrefix(mappedURI);
            ((Element)nsr.getContext()).setAttribute("xmlns:" + newPrefix, mappedURI);
            replacementMap.put(mappedPrefix, newPrefix);
        }
        String remappedPrefix = null;
        remappedPrefix = (String)replacementMap.get(elemPrefix);
        if (remappedPrefix != null) {
            contextElement.setPrefix(remappedPrefix);
        }
        Vector<String> vecUnneededPrefixes = new Vector<String>();
        NamedNodeMap attrMap = contextElement.getAttributes();
        int attrCount = attrMap.getLength();
        int i = 0;
        while (i < attrCount) {
            Attr attrObj = (Attr)attrMap.item(i);
            String attrName = attrObj.getName();
            if (!attrName.startsWith("xmlns:") && attrName.compareTo("xmlns") != 0) {
                String attrPrefix = attrObj.getPrefix();
                remappedPrefix = (String)replacementMap.get(attrPrefix);
                if (remappedPrefix != null) {
                    attrObj.setPrefix(remappedPrefix);
                }
            } else {
                vecUnneededPrefixes.add(attrName);
            }
            if (attrName.compareTo("base") == 0 || attrName.compareTo("type") == 0 || attrName.compareTo("ref") == 0) {
                String refValue = attrObj.getValue();
                String refLocalName = StringUtils.getLocalForColonizedName(refValue);
                String refLocalPrefix = StringUtils.getPrefixForColonizedName(refValue);
                if (refLocalPrefix == null) {
                    refLocalPrefix = "";
                }
                if ((remappedPrefix = (String)replacementMap.get(refLocalPrefix)) != null) {
                    if (remappedPrefix.length() == 0) {
                        attrObj.setValue(refLocalName);
                    } else {
                        attrObj.setValue(String.valueOf(remappedPrefix) + ":" + refLocalName);
                    }
                }
            }
            ++i;
        }
        for (String prefixAttrName : vecUnneededPrefixes) {
            contextElement.removeAttribute(prefixAttrName);
        }
        NodeList childNodes = contextElement.getChildNodes();
        int childNumber = childNodes.getLength();
        int i2 = 0;
        while (i2 < childNumber) {
            Node childNode = childNodes.item(i2);
            if (1 == childNode.getNodeType()) {
                HashMap replacementMapCopy = new HashMap();
                replacementMapCopy.putAll(replacementMap);
                this.normalizeSchemaElementNamespaces((Element)childNode, nsr, replacementMapCopy);
            }
            ++i2;
        }
    }

    public String getTargetNamespace() {
        String targetNS = this.document.getDocumentElement().getAttribute("targetNamespace");
        return targetNS;
    }

    public Attr createAttributeWithNamespace(String uri, String attrName, boolean createMappingIfNeeded) throws TransformerException {
        Attr attr = this.document.createAttributeNS(uri, attrName);
        String prefix = this.resolver.getPrefix(uri);
        if (prefix == null && createMappingIfNeeded && (prefix = NamespaceResolver.getPrefixForDefaultNamespace(uri)) != null) {
            this.document.getDocumentElement().setAttribute("xmlns:" + prefix, uri);
        }
        if (prefix == null) {
            throw new TransformerException("The URI [" + uri + "] has no available mapping");
        }
        if (prefix.compareTo("") != 0) {
            attr.setPrefix(prefix);
        }
        return attr;
    }

    public void renameNamespace(String namespaceURI, String updatedURI) throws TransformerException {
        try {
            NodeList itNSReferences = this.getMultiXPathResult("//namespace::*[string(.) = '" + namespaceURI + "']");
            int index = 0;
            while (index < itNSReferences.getLength()) {
                Node refNode = itNSReferences.item(index);
                refNode.setNodeValue(updatedURI);
                ++index;
            }
        }
        catch (TransformerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransformerException("Unexpected problem while patching all URI references: " + e.getMessage(), e);
        }
        this.resolver.setContext(this.document.getDocumentElement());
    }

    public Element createElementWithNamespace(String uri, String elementName, boolean createMappingIfNeeded) throws TransformerException {
        Element elem = null;
        elem = this.document.createElementNS(uri, elementName);
        String prefix = this.getPrefixForNamespace(uri);
        if (prefix == null && createMappingIfNeeded && (prefix = this.resolver.allocatePrefix(uri)) != null) {
            this.document.getDocumentElement().setAttribute("xmlns:" + prefix, uri);
        }
        if (prefix == null) {
            throw new TransformerException("The URI [" + uri + "] has no available mapping");
        }
        if (prefix.compareTo("") != 0) {
            elem.setPrefix(prefix);
        }
        return elem;
    }

    public String getXPath(Node node) {
        StringBuffer buf = new StringBuffer("");
        while (node != null) {
            StringBuffer fragment = null;
            if (node instanceof Element) {
                fragment = this.computeXPathFragment((Element)node);
                node = node.getParentNode();
            } else if (node instanceof Attr) {
                fragment = this.computeXPathFragment((Attr)node);
                node = ((Attr)node).getOwnerElement();
            } else {
                node = node.getParentNode();
            }
            if (fragment == null) continue;
            buf.insert(0, fragment);
        }
        return new String(buf);
    }

    private StringBuffer computeXPathFragment(Attr at) {
        StringBuffer ret = new StringBuffer("/@").append(at.getNodeName());
        return ret;
    }

    private StringBuffer computeXPathFragment(Element el) {
        StringBuffer ret = new StringBuffer("");
        Node node = el;
        int num = 1;
        String localName = el.getLocalName();
        String prefixName = el.getPrefix();
        String namespaceURI = null;
        if (prefixName == null) {
            prefixName = "";
        }
        namespaceURI = this.resolver.getNamespaceURI(prefixName, el);
        while ((node = node.getPreviousSibling()) != null) {
            Node similarElem;
            if (!(node instanceof Element) || localName.compareTo((similarElem = node).getLocalName()) != 0) continue;
            String similarElemPrefix = similarElem.getPrefix();
            if (similarElemPrefix == null) {
                similarElemPrefix = "";
            }
            if (prefixName.compareTo(similarElemPrefix) != 0 && (namespaceURI == null || namespaceURI.compareTo(this.resolver.getNamespaceURI(similarElemPrefix, similarElem)) != 0)) continue;
            ++num;
        }
        ret.append("/");
        if (namespaceURI != null) {
            String resolvedPrefix = NamespaceResolver.getPrefixForDefaultNamespace(namespaceURI);
            ret.append(resolvedPrefix != null ? resolvedPrefix : prefixName);
            ret.append(":");
        }
        ret.append(localName);
        ret.append("[");
        ret.append(num);
        ret.append("]");
        return ret;
    }

    public Node addNodeByXPath(String xpath, Element nextSibling) throws TransformerException {
        String head;
        Node parent;
        Node ret = null;
        if (!xpath.startsWith("/")) {
            throw new TransformerException("XPath must start at root element");
        }
        int split = xpath.lastIndexOf(47);
        String tail = xpath.substring(split + 1);
        if ("text()".equals(tail)) {
            xpath = xpath.substring(0, split);
            split = xpath.lastIndexOf(47);
            tail = xpath.substring(split + 1);
        }
        if ((parent = this.getSingleXPathResult(head = xpath.substring(0, split))) == null) {
            parent = this.addNodeByXPath(head, nextSibling);
        }
        if (parent == null || !(parent instanceof Element)) {
            throw new TransformerException("Could not create element for XPath " + head);
        }
        int paren = tail.lastIndexOf(91);
        String attDef = null;
        if (paren != -1) {
            attDef = tail.substring(paren + 1, tail.length() - 1);
            tail = tail.substring(0, paren);
        }
        ret = this.addSingleNode((Element)parent, nextSibling, tail);
        if (attDef != null) {
            this.addAttribute(ret, attDef);
        }
        return ret;
    }

    private void addAttribute(Node ret, String attDef) throws TransformerException {
        if (!(ret instanceof Element)) {
            throw new TransformerException("Cannot add attribute to non-element: " + attDef);
        }
        if (!attDef.matches("@\\w+=\"[A-Za-z0-9:_.]*\"") && !attDef.matches("\"[A-Za-z0-9:_.]*\"=@\\w+")) {
            throw new TransformerException("Malformed attribute definition: " + attDef);
        }
        String name = null;
        String val = null;
        String[] defs = attDef.split("=");
        if (defs[0].startsWith("\"")) {
            val = defs[0].substring(1, defs[0].length() - 1);
            name = defs[1];
        } else if (defs[1].startsWith("\"")) {
            val = defs[1].substring(1, defs[1].length() - 1);
            name = defs[0];
        } else {
            throw new TransformerException("Malformed attribute definition: " + attDef);
        }
        Node test = this.addSingleNode((Element)ret, null, name);
        if (!(test instanceof Attr)) {
            throw new TransformerException("Could not create attribute with name " + name + " for def " + attDef);
        }
        ((Attr)test).setValue(val);
    }

    public Node addNodeByXPath(String xpath) throws TransformerException {
        return this.addNodeByXPath(xpath, (Element)null);
    }

    public Node addNodeByXPath(String xpath, String nextSiblingPath) throws TransformerException {
        Node nextSibling = this.getSingleXPathResult(nextSiblingPath);
        if (!(nextSibling instanceof Element)) {
            throw new TransformerException("XPath result is not an Element: " + nextSiblingPath);
        }
        return this.addNodeByXPath(xpath, (Element)nextSibling);
    }

    private Node addSingleNode(Element parent, Element nextSibling, String tail) {
        Node ret = null;
        if (tail.startsWith("@")) {
            tail = tail.substring(1);
            ret = this.document.createAttribute(tail);
            parent.setAttributeNode((Attr)ret);
        } else {
            ret = this.document.createElement(tail);
            parent.insertBefore(ret, nextSibling);
        }
        return ret;
    }

    public String getNamespaceForPrefix(String prefix) {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.getNamespaceURI(prefix);
    }

    public String getPrefixForNamespace(String namespace) {
        if (this.resolver == null) {
            return null;
        }
        this.resolver.setContext(this.document.getDocumentElement());
        return this.resolver.getPrefix(namespace);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.resolver;
    }

    public Node getSingleXPathResult(String xpath) throws TransformerException {
        Node node = this.getSingleXPathResult(this.document.getDocumentElement(), xpath);
        return node;
    }

    public Node getSingleXPathResult(Node context, String xpath) throws TransformerException {
        Node node = null;
        XPathExpression xPathExpression = this.getXPathExpression(context, xpath);
        try {
            Object obj = xPathExpression.evaluate(context, XPathConstants.NODE);
            if (obj instanceof Node) {
                node = (Node)obj;
            } else if (obj != null) {
                throw new TransformerException("Wrong Object type returned as result of expression evaluation : " + obj.getClass().toString());
            }
        }
        catch (XPathExpressionException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new TransformerException(e);
        }
        return node;
    }

    public NodeList getMultiXPathResult(String xpath) throws TransformerException {
        return this.getMultiXPathResult(this.document.getDocumentElement(), xpath);
    }

    public NodeList getMultiXPathResult(Node context, String xpath) throws TransformerException {
        NodeList nl = null;
        XPathExpression xPathExpression = this.getXPathExpression(context, xpath);
        try {
            Object obj = xPathExpression.evaluate(context, XPathConstants.NODESET);
            if (!(obj instanceof NodeList)) {
                throw new TransformerException("Wrong Object type returned as result of expression evaluation : " + obj.getClass().toString());
            }
            nl = (NodeList)obj;
        }
        catch (XPathExpressionException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new TransformerException(e);
        }
        return nl;
    }

    private static XPathFactory getXPathFactory() {
        if (xPathFactory == null) {
            xPathFactory = XPathFactory.newInstance();
        }
        return xPathFactory;
    }

    private static XPath getNewXPath() {
        XPath xPath = XPathHelper.getXPathFactory().newXPath();
        return xPath;
    }

    private Element getNodeContextElement(Node contextNode) {
        Element contextElem = null;
        contextElem = contextNode instanceof Element ? (Element)contextNode : (contextNode != null ? contextNode.getOwnerDocument().getDocumentElement() : this.document.getDocumentElement());
        return contextElem;
    }

    private XPathExpression getXPathExpression(Node nodeContext, String xPath) throws TransformerException {
        XPathExpression xPathExpression = (XPathExpression)this.mapCompiledXPath.get(xPath);
        if (xPathExpression == null) {
            XPath xPathObj = XPathHelper.getNewXPath();
            Element contextElement = this.getNodeContextElement(nodeContext);
            this.resolver.setContext(contextElement);
            xPathObj.setNamespaceContext(this.resolver);
            try {
                xPathExpression = xPathObj.compile(xPath);
                this.mapCompiledXPath.put(xPath, xPathExpression);
            }
            catch (XPathExpressionException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new TransformerException(e);
            }
        }
        return xPathExpression;
    }
}

