/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.common.utils;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.eclipse.stp.policy.wtp.common.utils.BaseException;
import org.eclipse.stp.policy.wtp.common.utils.DOMProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLProvider {
    private static final Logger log = Logger.getLogger(XSLProvider.class);
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Transformer transformer;

    public XSLProvider(InputStream xsl) throws BaseException {
        this(new DOMProvider(xsl).getDocument());
    }

    public XSLProvider(Document xsl) throws BaseException {
        try {
            this.transformer = transformerFactory.newTransformer(new DOMSource(xsl));
        }
        catch (TransformerConfigurationException e) {
            String msg = "Could not instantiate Transformer.";
            log.fatal((Object)msg, (Throwable)e);
            msg = String.valueOf(msg) + " Reason:\n" + e.getMessage();
            throw new BaseException(msg, e);
        }
    }

    public Document transform(Document source, Map parameters) throws TransformerException {
        return (Document)this.transform((Node)source, parameters, false);
    }

    public Document transform(Document source, Node context, Map parameters) throws TransformerException {
        Document result = (Document)this.transform(context, parameters, false);
        Element documentElement = result.getDocumentElement();
        if (documentElement != null) {
            context.getParentNode().replaceChild(source.importNode(documentElement, true), context);
        } else {
            context.getParentNode().removeChild(context);
        }
        return source;
    }

    public Document transform(Document source) throws TransformerException {
        return (Document)this.transform((Node)source, null, false);
    }

    public String transformToString(Document source) throws TransformerException {
        return (String)this.transform((Node)source, null, true);
    }

    private Object transform(Node source, Map parameters, boolean transformToString) throws TransformerException {
        this.transformer.clearParameters();
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                this.transformer.setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        DOMSource domSource = new DOMSource(source);
        if (transformToString) {
            StreamResult streamResult = new StreamResult();
            StringWriter stringWriter = new StringWriter();
            streamResult.setWriter(stringWriter);
            this.transformer.transform(domSource, streamResult);
            String result = stringWriter.toString();
            return result;
        }
        DOMResult domResult = new DOMResult();
        this.transformer.transform(domSource, domResult);
        Node result = domResult.getNode();
        return result;
    }
}

