/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.common.utils.ui;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.policy.wtp.common.utils.FileUtils;
import org.eclipse.stp.policy.wtp.common.utils.Messages;
import org.eclipse.stp.policy.wtp.common.utils.ui.EclipseUI;

public class ParameterValidator {
    private ParameterValidator() {
    }

    public static String validateTargetFile(String containerLocation, String fileName, String fileExt) {
        String errMsg = ParameterValidator.validateContainer(containerLocation);
        if (errMsg != null) {
            return errMsg;
        }
        errMsg = ParameterValidator.validateTargetFile(fileName, fileExt);
        if (errMsg != null) {
            return errMsg;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validatePath(String.valueOf(containerLocation) + File.separatorChar + fileName, 1);
        if (!status.isOK()) {
            return status.getMessage();
        }
        try {
            IFile file = EclipseUI.getIFile(containerLocation, fileName);
            if (EclipseUI.hasActiveEditor(file.getLocation().toOSString())) {
                return Messages.getString("WizardPage.MESSAGE_FILE_ALREADY_OPENED_IN_EDITOR");
            }
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public static String validateTargetFile(String fileName, String fileExt) {
        if (fileName == null || fileName.length() == 0 || fileName.lastIndexOf(46) == 0) {
            return Messages.getString("WizardPage.ERROR_FILENAME_MUST_BE_SPECIFIED");
        }
        if (fileExt != null && !fileName.endsWith("." + fileExt)) {
            return MessageFormat.format(Messages.getString("WizardPage.ERROR_INVALID_EXTENSION"), fileExt);
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(fileName, 1);
        if (!status.isOK()) {
            return status.getMessage();
        }
        return null;
    }

    public static String validateContainer(String containerLocation) {
        if (containerLocation == null || containerLocation.length() == 0) {
            return Messages.getString("WizardPage.ERROR_CONTAINER_MUST_BE_SPECIFIED");
        }
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(containerLocation));
        if (container == null || (container.getType() & 6) == 0) {
            return Messages.getString("WizardPage.ERROR_CONTAINER_MUST_EXIST");
        }
        if (!container.isAccessible()) {
            return Messages.getString("WizardPage.ERROR_PROJECT_MUST_BE_WRITABLE");
        }
        return null;
    }

    public static final String validateTargetDirectory(String directoryPath) {
        if (directoryPath == null || directoryPath.length() == 0) {
            return Messages.getString("WizardPage.ERROR_NO_TARGET_DIR");
        }
        File dir = new File(directoryPath);
        if (!dir.isAbsolute()) {
            return Messages.getString("WizardPage.ERROR_INVALID_TARGET_DIR");
        }
        if (dir.isFile()) {
            return Messages.getString("WizardPage.ERROR_FILE_NOT_DIR");
        }
        Path path = new Path(directoryPath);
        int iSegment = 0;
        while (iSegment < path.segmentCount()) {
            String segment = path.segment(iSegment);
            int iChar = 0;
            while (iChar < OS.INVALID_RESOURCE_CHARACTERS.length) {
                if (segment.indexOf(OS.INVALID_RESOURCE_CHARACTERS[iChar]) != -1) {
                    return Messages.getString("WizardPage.ERROR_INVALID_TARGET_DIR");
                }
                ++iChar;
            }
            ++iSegment;
        }
        return null;
    }

    public static String validateURI(String uri) {
        if (uri == null || uri.length() == 0) {
            return Messages.getString("WizardPage.ERROR_NO_URI");
        }
        try {
            new URI(uri);
        }
        catch (URISyntaxException e) {
            return String.valueOf(Messages.getString("WizardPage.ERROR_INVALID_URI")) + e.getMessage();
        }
        return null;
    }

    public static String validateInputFile(String fileLocation, String fileExt) {
        if (fileLocation == null || fileLocation.length() == 0) {
            return MessageFormat.format(Messages.getString("WizardPage.ERROR_NO_FILE"), EclipseUI.getFileDescription(fileExt));
        }
        File file = new File(fileLocation);
        if (!fileExt.equals(FileUtils.getExtension(file))) {
            return MessageFormat.format(Messages.getString("WizardPage.ERROR_INVALID_EXTENSION"), fileExt);
        }
        if (!file.exists() || !file.isFile()) {
            return MessageFormat.format(Messages.getString("WizardPage.ERROR_INVALID_FILE"), EclipseUI.getFileDescription(fileExt));
        }
        return null;
    }

    public static String validateInputSDX(String fileLocation) {
        return ParameterValidator.validateInputFile(fileLocation, "sdx");
    }

    public static String validateInputSPDX(String fileLocation) {
        return ParameterValidator.validateInputFile(fileLocation, "spdx");
    }

    public static final boolean validatePattern(String val, Pattern pattern) {
        Matcher matcher = pattern.matcher(val);
        return matcher.matches();
    }

    public static String validateProjectName(String projectName) {
        try {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(projectName, 4);
            if (!status.isOK()) {
                return status.getMessage();
            }
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = String.valueOf(Messages.getString("WizardPage.ERROR_PROJECT_NAME_VALIDATION_FAILED")) + e.getClass().getName();
            }
            return errMsg;
        }
        return null;
    }
}

