/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.stp.policy.wtp.editor.editparts.PolicyContainerEditPart;
import org.eclipse.stp.policy.wtp.editor.figures.CollapsibleFigure;
import org.eclipse.stp.policy.wtp.editor.model.PolicyModel;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.HeadingFigure;

public class PolicyEditPart
extends BaseEditPart
implements INamedEditPart {
    private IFigure contentPane;
    private HeadingFigure headingFigure;
    private boolean isExpanded = true;
    public static final int IDENT = 16;

    protected IFigure createFigure() {
        Figure figure = new Figure();
        figure.setBorder((Border)new LineBorder(1){

            public Insets getInsets(IFigure figure) {
                Insets insets = super.getInsets(figure);
                insets.bottom = 0;
                --insets.left;
                --insets.right;
                insets.top = 0;
                return insets;
            }
        });
        ToolbarLayout toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setMinorAlignment(0);
        toolbarLayout.setStretchMinorAxis(true);
        figure.setLayoutManager((LayoutManager)toolbarLayout);
        this.headingFigure = new HeadingFigure();
        this.headingFigure.getLabel().setIcon(((PolicyModel)((Object)this.getModel())).getImage());
        figure.add((IFigure)this.headingFigure);
        this.contentPane = new CollapsibleFigure();
        toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        this.contentPane.setLayoutManager((LayoutManager)toolbarLayout);
        figure.add(this.contentPane);
        if (this.isReadOnly()) {
            this.headingFigure.getLabel().setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
        } else {
            this.headingFigure.getLabel().setForegroundColor(ColorConstants.black);
        }
        this.headingFigure.setIsReadOnly(this.isReadOnly());
        return figure;
    }

    public void addFeedback() {
        LineBorder boxFigureLineBorder = (LineBorder)this.getFigure().getBorder();
        boxFigureLineBorder.setWidth(2);
        this.headingFigure.setSelected(true);
        this.figure.repaint();
    }

    public void removeFeedback() {
        LineBorder boxFigureLineBorder = (LineBorder)this.getFigure().getBorder();
        boxFigureLineBorder.setWidth(1);
        this.headingFigure.setSelected(false);
        this.figure.repaint();
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    public void performDirectEdit(Point cursorLocation) {
    }

    public Label getLabelFigure() {
        return this.headingFigure.getLabel();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
    }

    protected List getModelChildren() {
        PolicyModel policy = (PolicyModel)((Object)this.getModel());
        return policy.getModelChildren();
    }

    protected void refreshVisuals() {
        PolicyModel policy = (PolicyModel)((Object)this.getModel());
        this.headingFigure.getLabel().setText(policy.getText());
        super.refreshVisuals();
    }

    public void performRequest(Request request) {
        if (request.getType() == "open" && this.isReadOnly()) {
            this.isExpanded = !this.isExpanded;
            this.getContentPane().setVisible(this.isExpanded);
            this.refresh();
        }
    }

    public static int getIdent(EditPart editPart) {
        int i = 0;
        EditPart part = editPart;
        while (part != null && !(part instanceof PolicyEditPart)) {
            ++i;
            part = part.getParent();
        }
        return (i - 1) * 16;
    }

    public static EditPart getPolicyEditPart(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        EditPart parent = editPart.getParent();
        if (editPart instanceof PolicyEditPart && parent instanceof PolicyContainerEditPart) {
            return editPart;
        }
        return PolicyEditPart.getPolicyEditPart(parent);
    }
}

