/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.gef.commands.Command;
import org.eclipse.stp.policy.model.Assertion;
import org.eclipse.stp.policy.model.Policy;
import org.eclipse.stp.policy.wtp.editor.Activator;
import org.eclipse.stp.policy.wtp.editor.model.NestedPolicyModel;
import org.eclipse.stp.policy.wtp.editor.model.PolicyCompositeModel;
import org.eclipse.stp.policy.wtp.editor.model.PolicyModel;
import org.eclipse.stp.policy.wtp.editor.model.actions.OperationPolicyDeleteAction;
import org.eclipse.stp.policy.wtp.editor.model.commands.AddNestedPolicyCommand;
import org.eclipse.stp.policy.wtp.editor.model.commands.DeleteAssertionCommand;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;

public class AssertionModel
extends WSDLBaseAdapter {
    private Assertion assertion;
    private PolicyCompositeModel parent;
    private boolean isReadOnly;
    List models = null;

    public AssertionModel(Assertion assertion, PolicyCompositeModel parent, boolean isReadOnly) {
        this.assertion = assertion;
        this.parent = parent;
        this.isReadOnly = isReadOnly;
    }

    public ITreeElement[] getChildren() {
        List models = this.getModelChildren();
        return models.toArray(new ITreeElement[models.size()]);
    }

    public boolean hasChildren() {
        return this.assertion.getNestedPolicy() != null;
    }

    public List getModelChildren() {
        if (this.models == null) {
            this.models = new ArrayList();
            if (this.assertion.getNestedPolicy() != null) {
                this.models.add(new NestedPolicyModel(this, this.assertion.getNestedPolicy(), this.isReadOnly()));
            }
        }
        return this.models;
    }

    public Image getImage() {
        return Activator.getDefault().getImage(this.getOptional() ? "icons/polopt.gif" : "icons/polreq.gif");
    }

    public ITreeElement getParent() {
        return this.parent;
    }

    public String getText() {
        QName name = this.assertion.getName();
        return String.valueOf(name.getPrefix()) + ':' + name.getLocalPart();
    }

    public String[] getActions(Object object) {
        ArrayList<String> actions = new ArrayList<String>();
        if (!this.isReadOnly()) {
            actions.add("org.eclipse.stp.policy.wtp.editor.model.actions.AddNestedPolicyAction");
            actions.add(OperationPolicyDeleteAction.ID);
        }
        return actions.toArray(new String[actions.size()]);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public Command getAddNestedPolicyCommand() {
        return new AddNestedPolicyCommand(this);
    }

    public Command getDeleteAssertionCommand() {
        return new DeleteAssertionCommand(this);
    }

    public PolicyModel createNestedPolicy() {
        Policy policy = this.assertion.createNestedPolicy();
        NestedPolicyModel policyModel = new NestedPolicyModel(this, policy, this.isReadOnly());
        this.getModelChildren().add(policyModel);
        return policyModel;
    }

    public void deleteAssertion() {
        this.parent.deleteAssertion(this);
    }

    public boolean getOptional() {
        return this.assertion.isOptional();
    }

    public void setOptional(boolean optional) {
        this.assertion.setOptional(optional);
    }

    public boolean canOptional() {
        return true;
    }

    public void deleteNestedPolicy() {
        this.assertion.removePolicy();
        this.models.clear();
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AssertionModel) {
            return this.assertion.equals(((AssertionModel)((Object)obj)).assertion);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.assertion.hashCode();
    }
}

