/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.properties.sections;

import org.eclipse.stp.policy.wtp.editor.Messages;
import org.eclipse.stp.policy.wtp.editor.model.PolicyModel;
import org.eclipse.stp.policy.wtp.editor.properties.sections.SectionHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.ASDAbstractSection;

public class PolicySection
extends ASDAbstractSection {
    private Text idText;
    private Text nameText;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createComposite(parent);
        SectionHelper.adaptComposite(this.composite);
        Label label = this.getWidgetFactory().createLabel(this.composite, Messages.PolicySection_LABEL_ID);
        label.setLayoutData((Object)SectionHelper.getLabelGridData());
        this.idText = this.getWidgetFactory().createText(this.composite, "");
        this.idText.addListener(24, (Listener)this);
        this.idText.setLayoutData((Object)SectionHelper.getFillGridData());
        label = this.getWidgetFactory().createLabel(this.composite, Messages.AssertionSection_LABEL_NAME);
        label.setLayoutData((Object)SectionHelper.getLabelGridData());
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        this.nameText.addListener(24, (Listener)this);
        this.nameText.setLayoutData((Object)SectionHelper.getFillGridData());
    }

    public void refresh() {
        super.refresh();
        boolean refreshIdText = true;
        boolean refreshNameText = true;
        if (this.idText.isFocusControl()) {
            refreshIdText = false;
        }
        if (this.nameText.isFocusControl()) {
            refreshNameText = false;
        }
        this.setListenerEnabled(false);
        if (refreshIdText) {
            this.idText.setText("");
        }
        if (refreshNameText) {
            this.nameText.setText("");
        }
        if (this.getPolicyModel() != null) {
            String value;
            PolicyModel model = this.getPolicyModel();
            if (refreshIdText) {
                value = model.getID();
                this.idText.setText(value != null ? value : "");
            }
            if (refreshNameText) {
                value = model.getName();
                this.nameText.setText(value != null ? value : "");
            }
        }
        this.setListenerEnabled(true);
    }

    public void doHandleEvent(Event event) {
        PolicyModel model = this.getPolicyModel();
        if (event.widget == this.idText) {
            String value = this.idText.getText();
            if (value.length() == 0) {
                SectionHelper.showErrorTooltip(SectionHelper.MESSAGE_MANDATORY, SectionHelper.getCaretLocation(this.idText));
            }
            model.setID(value);
        } else if (event.widget == this.nameText) {
            SectionHelper.hideErrorTooltip();
            String value = this.nameText.getText();
            model.setName(value);
        }
    }

    private PolicyModel getPolicyModel() {
        Object model = this.getModel();
        if (model instanceof PolicyModel) {
            return (PolicyModel)((Object)model);
        }
        return null;
    }
}

