/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.generator.wizards;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stp.policy.wtp.common.utils.BaseException;
import org.eclipse.stp.policy.wtp.common.utils.ui.EclipseUI;
import org.eclipse.stp.policy.wtp.generator.OpdxGenerator;
import org.eclipse.stp.policy.wtp.generator.wizards.Messages;

public class OperationPolicyGenerationRunnable
implements IRunnableWithProgress {
    private static final Logger log = Logger.getLogger(OperationPolicyGenerationRunnable.class);
    private String _containerName = null;
    private String _targetFileName = null;
    private String _policyName = null;
    private String _idName = null;
    private boolean _isNotification;

    public OperationPolicyGenerationRunnable(String containerName, String targetFileName, String policyName, String idName, boolean isNotification) {
        this._containerName = containerName;
        this._targetFileName = targetFileName;
        this._policyName = policyName;
        this._idName = idName;
        this._isNotification = isNotification;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                log.debug((Object)"The generation of Operation Policy Document carried out...");
                monitor.beginTask(String.valueOf(Messages.getString("Runnable.MESSAGE_CREATING")) + this._targetFileName, 2);
                IFile file = EclipseUI.getIFile((String)this._containerName, (String)this._targetFileName);
                InputStream stream = this.openContentStream();
                log.debug((Object)"The stream with Operation Policy Document content obtained...");
                try {
                    if (file.exists()) {
                        file.setContents(stream, true, true, monitor);
                    } else {
                        file.create(stream, true, monitor);
                    }
                    log.debug((Object)"The result document successfully stored");
                }
                finally {
                    stream.close();
                }
                monitor.worked(1);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private InputStream openContentStream() throws BaseException {
        InputStream inputStream = OpdxGenerator.generateOPDXStream(this._policyName, this._idName, this._isNotification);
        return inputStream;
    }
}

