/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.java.composite2java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stp.sca.common.java.Messages;
import org.eclipse.stp.sca.common.java.ScaCommonJdtPlugin;
import org.eclipse.stp.sca.common.java.composite2java.JComposite;
import org.eclipse.stp.sca.common.java.composite2java.JInterface;
import org.eclipse.stp.sca.common.java.utils.JDTUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationSelectionDialog
extends TitleAreaDialog {
    private final IFile compositeFile;
    private final JComposite jComposite;
    private IClasspathEntry selectedEntry;
    private final List<JavaFile> selectedFiles = new ArrayList<JavaFile>();
    private Image cuImg;
    private Image packageImg;
    private Image sourceImg;

    public GenerationSelectionDialog(Shell parentShell, IFile compositeFile, JComposite jComposite) {
        super(parentShell);
        this.compositeFile = compositeFile;
        this.jComposite = jComposite;
        this.setShellStyle(35952);
        this.cuImg = ScaCommonJdtPlugin.getImage("icons/obj16/jcu_obj.gif");
        this.packageImg = ScaCommonJdtPlugin.getImage("icons/obj16/package_obj.gif");
        this.sourceImg = ScaCommonJdtPlugin.getImage("icons/obj16/packagefolder_obj.gif");
    }

    protected Control createDialogArea(Composite parent) {
        Composite bigContainer = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        bigContainer.setLayout((Layout)layout);
        bigContainer.setLayoutData((Object)new GridData(1808));
        Composite container = new Composite(bigContainer, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label l = new Label(container, 0);
        l.setText(Messages.GenerationSelectionDialog_3);
        Composite comp = new Composite(container, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        l = new Label(comp, 0);
        l.setImage(this.sourceImg);
        Combo combo = new Combo(comp, 2060);
        combo.setLayoutData((Object)new GridData(768));
        ComboViewer comboViewer = new ComboViewer(combo);
        final IJavaProject jp = JDTUtils.getJavaProject(this.compositeFile.getProject());
        List<IClasspathEntry> entries = JDTUtils.getSourceFolders(jp);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IPath path = ((IClasspathEntry)element).getPath();
                return " " + path.lastSegment() + " - " + path.toString();
            }

            public Image getImage(Object element) {
                return GenerationSelectionDialog.this.sourceImg;
            }
        });
        comboViewer.setInput(entries);
        if (entries.size() > 0) {
            this.selectedEntry = entries.get(0);
            comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedEntry));
        }
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GenerationSelectionDialog.this.selectedEntry = (IClasspathEntry)((IStructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        l = new Label(container, 0);
        l.setText(Messages.GenerationSelectionDialog_6);
        GridData layoutData = new GridData();
        layoutData.verticalIndent = 15;
        l.setLayoutData((Object)layoutData);
        int style = 35588;
        final CheckboxTreeViewer treeViewer = new CheckboxTreeViewer(container, style);
        treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof JavaPackage) {
                    String pckName = ((JavaPackage)element).name;
                    if (pckName.length() == 0) {
                        return "default";
                    }
                    return pckName;
                }
                if (element instanceof JavaFile) {
                    return ((JavaFile)element).name;
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof JavaPackage) {
                    return GenerationSelectionDialog.this.packageImg;
                }
                if (element instanceof JavaFile) {
                    return GenerationSelectionDialog.this.cuImg;
                }
                return super.getImage(element);
            }
        });
        final HashMap javaPackages = new HashMap();
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof JavaPackage) {
                    return ((JavaPackage)parentElement).classes.toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof JavaFile) {
                    return ((JavaFile)element).pck;
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof JavaPackage) {
                    return ((JavaPackage)element).classes.size() > 0;
                }
                return false;
            }

            public Object[] getElements(Object inputElement) {
                if (!(inputElement instanceof JComposite)) {
                    return new Object[0];
                }
                ArrayList<JInterface> elements = new ArrayList<JInterface>();
                elements.addAll(((JComposite)inputElement).getInterfaces().values());
                elements.addAll(((JComposite)inputElement).getImplementations().values());
                javaPackages.clear();
                for (JInterface ji : elements) {
                    String[] parts;
                    String pn;
                    JavaPackage pck;
                    try {
                        IType iType = jp.findType(ji.getName());
                        if (iType != null) {
                            continue;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                    if ((pck = (JavaPackage)javaPackages.get(pn = (parts = JDTUtils.getQualifiedNameElements(ji.getName()))[0])) == null) {
                        pck = new JavaPackage();
                        pck.name = pn;
                    }
                    JavaFile jf = new JavaFile();
                    jf.name = parts[1];
                    jf.pck = pck;
                    jf.jInterface = ji;
                    pck.classes.add(jf);
                    javaPackages.put(pck.name, pck);
                }
                return javaPackages.values().toArray();
            }
        });
        treeViewer.setInput((Object)this.jComposite);
        treeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1.getClass().equals(e2.getClass())) {
                    if (e1 instanceof JavaPackage) {
                        return ((JavaPackage)e1).getName().compareTo(((JavaPackage)e2).getName());
                    }
                    return ((JavaFile)e1).getName().compareTo(((JavaFile)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        treeViewer.expandAll();
        for (JavaPackage pck : javaPackages.values()) {
            this.selectedFiles.addAll(pck.classes);
        }
        for (JavaPackage pck : javaPackages.values()) {
            treeViewer.setSubtreeChecked((Object)pck, true);
        }
        treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof JavaPackage) {
                    JavaPackage pck = (JavaPackage)event.getElement();
                    treeViewer.setSubtreeChecked((Object)pck, event.getChecked());
                    if (event.getChecked()) {
                        GenerationSelectionDialog.this.selectedFiles.addAll(pck.classes);
                    } else {
                        GenerationSelectionDialog.this.selectedFiles.removeAll(pck.classes);
                    }
                } else {
                    JavaFile jf = (JavaFile)event.getElement();
                    int checked = 0;
                    for (JavaFile jfRun : jf.pck.classes) {
                        if (!treeViewer.getChecked((Object)jfRun)) continue;
                        ++checked;
                    }
                    if (checked == jf.pck.classes.size()) {
                        treeViewer.setGrayChecked((Object)jf.pck, false);
                        treeViewer.setChecked((Object)jf.pck, true);
                    } else if (checked == 0) {
                        treeViewer.setGrayChecked((Object)jf.pck, false);
                    } else {
                        treeViewer.setGrayChecked((Object)jf.pck, true);
                    }
                    if (event.getChecked()) {
                        GenerationSelectionDialog.this.selectedFiles.add(jf);
                    } else {
                        GenerationSelectionDialog.this.selectedFiles.remove(jf);
                    }
                }
            }
        });
        this.getShell().setText(Messages.GenerationSelectionDialog_8);
        this.setTitle(Messages.GenerationSelectionDialog_8);
        if (this.selectedFiles.size() == this.jComposite.getImplementations().size() + this.jComposite.getInterfaces().size()) {
            this.setMessage(Messages.GenerationSelectionDialog_10);
        } else {
            this.setMessage(Messages.GenerationSelectionDialog_11, 2);
        }
        return bigContainer;
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    public boolean close() {
        if (this.sourceImg != null) {
            this.sourceImg.dispose();
            this.sourceImg = null;
        }
        if (this.packageImg != null) {
            this.packageImg.dispose();
            this.packageImg = null;
        }
        if (this.cuImg != null) {
            this.cuImg.dispose();
            this.cuImg = null;
        }
        return super.close();
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        IJavaProject jp = JDTUtils.getJavaProject(this.compositeFile.getProject());
        IPackageFragmentRoot[] roots = jp.findPackageFragmentRoots(this.selectedEntry);
        if (roots.length != 0) {
            return roots[0];
        }
        return null;
    }

    public List<JavaFile> getSelectedFiles() {
        return this.selectedFiles;
    }

    public class JavaFile {
        String name;
        JInterface jInterface;
        JavaPackage pck;

        public String getName() {
            return this.name;
        }

        public JInterface getJInterface() {
            return this.jInterface;
        }

        public JavaPackage getPck() {
            return this.pck;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JavaPackage {
        String name;
        HashSet<JavaFile> classes = new HashSet();

        public String getName() {
            return this.name;
        }

        public HashSet<JavaFile> getClasses() {
            return this.classes;
        }
    }
}

