/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.stp.sca.common.internal.builder.ScaMarkerHelper;
import org.eclipse.stp.sca.common.internal.provisional.builder.ScaAbstractValidationExtension;
import org.eclipse.stp.sca.common.internal.provisional.builder.ScaValidator;
import org.eclipse.stp.sca.common.internal.provisional.filters.ScaResourceFiltersEPManager;
import org.eclipse.stp.sca.common.utils.ResourceUtils;

public class ScaIncrementalBuilder
extends IncrementalProjectBuilder {
    public static String SCA_BUILDER_EXTENSION_POINT = "org.eclipse.stp.sca.common.scaBuilderExtension";
    private final ScaValidator scaValidator = new ScaValidator();

    public ScaIncrementalBuilder() {
        IConfigurationElement[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = reg.getConfigurationElementsFor(SCA_BUILDER_EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement filterElement = iConfigurationElementArray[n2];
            String theClassName = filterElement.getAttribute("class");
            if (theClassName != null && theClassName.length() != 0) {
                try {
                    Object theClass = filterElement.createExecutableExtension("class");
                    this.scaValidator.addValidationExtension((ScaAbstractValidationExtension)theClass);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            ScaMarkerHelper.clearScaMarkers((IResource)this.getProject(), 2);
            Set<IFolder> sourceFolders = ScaResourceFiltersEPManager.getInstance().getSourceFolders(this.getProject());
            List<IFile> compositeFiles = ResourceUtils.getFiles("composite", sourceFolders);
            ArrayList<File> files = new ArrayList<File>(compositeFiles.size());
            for (IFile file : compositeFiles) {
                files.add(file.getLocation().toFile());
            }
            Set<IFolder> binaryFolders = ScaResourceFiltersEPManager.getInstance().getBinaryFolders(this.getProject());
            IProject[] iProjectArray = this.getProject().getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                Set<IFolder> f = ScaResourceFiltersEPManager.getInstance().getBinaryFolders(project);
                binaryFolders.addAll(f);
                ++n2;
            }
            File[] rootContainers = new File[binaryFolders.size()];
            int i = 0;
            for (IFolder folder : binaryFolders) {
                rootContainers[i] = folder.getLocation().toFile();
                ++i;
            }
            Map<Diagnostic, File> diagnostics = this.scaValidator.performValidation(files, rootContainers);
            ScaMarkerHelper.createAllScaMarkers(diagnostics);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        ValidatingScaDeltaVisitor visitor = new ValidatingScaDeltaVisitor(monitor);
        delta.accept((IResourceDeltaVisitor)visitor);
        visitor.getClass();
        List compositeFiles = visitor.filesToValidate;
        ArrayList<File> files = new ArrayList<File>(compositeFiles.size());
        Set<IFolder> sourceFolders = ScaResourceFiltersEPManager.getInstance().getSourceFolders(this.getProject());
        block0: for (IFile file : compositeFiles) {
            for (IFolder srcFolder : sourceFolders) {
                if (!srcFolder.getLocation().isPrefixOf(file.getLocation())) continue;
                files.add(file.getLocation().toFile());
                ScaMarkerHelper.clearScaMarkers(file);
                continue block0;
            }
        }
        Set<IFolder> binaryFolders = ScaResourceFiltersEPManager.getInstance().getBinaryFolders(this.getProject());
        IProject[] iProjectArray = this.getProject().getReferencedProjects();
        int n = iProjectArray.length;
        int srcFolder = 0;
        while (srcFolder < n) {
            IProject project = iProjectArray[srcFolder];
            Set<IFolder> f = ScaResourceFiltersEPManager.getInstance().getBinaryFolders(project);
            binaryFolders.addAll(f);
            ++srcFolder;
        }
        File[] rootContainers = new File[binaryFolders.size()];
        int i = 0;
        for (IFolder folder : binaryFolders) {
            rootContainers[i] = folder.getLocation().toFile();
            ++i;
        }
        Map<Diagnostic, File> diagnostics = this.scaValidator.performValidation(files, rootContainers);
        ScaMarkerHelper.createAllScaMarkers(diagnostics);
    }

    protected void checkCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            this.forgetLastBuiltState();
            throw new OperationCanceledException();
        }
    }

    private class ValidatingScaDeltaVisitor
    implements IResourceDeltaVisitor {
        private final IProgressMonitor monitor;
        private final List<IFile> filesToValidate = new ArrayList<IFile>();
        private final boolean javaResourcesChanged = false;

        public ValidatingScaDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IFile file;
            ScaIncrementalBuilder.this.checkCancel(this.monitor);
            IResource resource = delta.getResource();
            if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                return false;
            }
            if (resource instanceof IFile && (file = (IFile)resource).getFileExtension().equals("composite") && file.exists()) {
                this.filesToValidate.add(file);
            }
            return true;
        }
    }
}

