/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.nature;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.sca.common.internal.provisional.nature.IScaNatureConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaNature
implements IProjectNature {
    private IProject project;
    public static String SCA_NATURE_CONFIGURATION_EXTENSION_POINT = "org.eclipse.stp.sca.common.scaNatureConfiguration";

    public void configure() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.stp.sca.common.scaBuilder");
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        this.project.setDescription(desc, null);
        for (IScaNatureConfiguration conf : this.getConfigurations()) {
            conf.configure(this.project);
        }
    }

    public void deconfigure() throws CoreException {
        for (IScaNatureConfiguration conf : this.getConfigurations()) {
            conf.deconfigure(this.project);
        }
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.stp.sca.common.scaBuilder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                return;
            }
            ++i;
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private List<IScaNatureConfiguration> getConfigurations() {
        IConfigurationElement[] extensions;
        ArrayList<IScaNatureConfiguration> configurations = new ArrayList<IScaNatureConfiguration>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = reg.getConfigurationElementsFor(SCA_NATURE_CONFIGURATION_EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement filterElement = iConfigurationElementArray[n2];
            String theClassName = filterElement.getAttribute("class");
            if (theClassName != null && theClassName.length() != 0) {
                try {
                    Object theClass = filterElement.createExecutableExtension("class");
                    configurations.add((IScaNatureConfiguration)theClass);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return configurations;
    }
}

