/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.preferences;

import java.io.File;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.stp.sca.common.internal.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

public class URLFieldEditor
extends StringButtonFieldEditor {
    public URLFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setEmptyStringAllowed(true);
        this.setChangeButtonText(Messages.URLFieldEditor_0);
        this.setErrorMessage(Messages.URLFieldEditor_1);
    }

    protected boolean doCheckState() {
        String text = this.getTextControl().getText();
        if (text != null && text.length() > 0) {
            return new File(text).exists();
        }
        return true;
    }

    protected String changePressed() {
        File f = new File(this.getTextControl().getText());
        f = f.exists() ? f : null;
        File d = this.getDirectory(f);
        return d == null ? null : d.getAbsolutePath();
    }

    private File getDirectory(File startingDirectory) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell(), 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }
}

