/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.provisional.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.sca.common.internal.provisional.filters.ScaAbstractResourcesFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaResourceFiltersEPManager {
    public static String SCA_FILTERS_EXTENSION_POINT = "org.eclipse.stp.sca.common.scaResourceFilters";
    private static ScaResourceFiltersEPManager instance = new ScaResourceFiltersEPManager();
    private final Collection<ScaAbstractResourcesFilter<?>> filters = new ArrayList();

    private ScaResourceFiltersEPManager() {
        IConfigurationElement[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = reg.getConfigurationElementsFor(SCA_FILTERS_EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement filterElement = iConfigurationElementArray[n2];
            String theClassName = filterElement.getAttribute("class");
            if (theClassName != null && theClassName.length() != 0) {
                try {
                    Object theClass = filterElement.createExecutableExtension("class");
                    this.filters.add((ScaAbstractResourcesFilter)theClass);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public static ScaResourceFiltersEPManager getInstance() {
        return instance;
    }

    public Set<IFolder> getBinaryFolders(IProject project) {
        HashSet<IFolder> folders = new HashSet<IFolder>();
        for (ScaAbstractResourcesFilter<?> filter : this.filters) {
            Set<IFolder> fs = filter.getBinaryFolders(project);
            if (fs == null) continue;
            folders.addAll(fs);
        }
        return folders;
    }

    public Set<IFolder> getSourceFolders(IProject project) {
        HashSet<IFolder> folders = new HashSet<IFolder>();
        for (ScaAbstractResourcesFilter<?> filter : this.filters) {
            Set<IFolder> fs = filter.getSourceFolders(project);
            if (fs == null) continue;
            folders.addAll(fs);
        }
        return folders;
    }
}

